/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.entity.hostile;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.tropicraft.entity.EntityTropicraftAnimal;
import net.tropicraft.entity.projectile.EntityPoisonBlot;
import net.tropicraft.registry.TCItemRegistry;

public abstract class EntityTreeFrog
extends EntityTropicraftAnimal
implements IEntityAdditionalSpawnData,
IRangedAttackMob {
    public int type = 0;
    public int jumpDelay = 0;
    public int jumpDelayMax = 10;
    public boolean wasOnGround = false;
    public double leapVecX;
    public double leapVecZ;

    public EntityTreeFrog(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70144_Y = 0.8f;
        this.field_70728_aV = 5;
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public EntityTreeFrog(World world, int parType) {
        this(world);
        this.type = parType;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        if (!this.func_70661_as().func_75500_f() || this.func_70638_az() != null) {
            if (this.field_70122_E || this.func_70090_H()) {
                if (this.jumpDelay > 0) {
                    --this.jumpDelay;
                }
                if (this.jumpDelay <= 0) {
                    this.jumpDelay = this.field_70146_Z.nextInt(4);
                    this.func_70661_as().func_75501_e();
                    this.func_70664_aZ();
                    this.field_70181_x += -0.01 + this.field_70146_Z.nextDouble() * 0.1;
                    double speed = 0.4;
                    if (this.func_70661_as().func_75505_d() != null) {
                        try {
                            if (this.func_70661_as().func_75505_d().func_75873_e() > this.func_70661_as().func_75505_d().func_75874_d()) {
                                this.func_70661_as().func_75499_g();
                                return;
                            }
                            Vec3 pos = this.func_70661_as().func_75505_d().func_75878_a((Entity)this);
                            this.leapVecX = pos.field_72450_a - this.field_70165_t;
                            this.leapVecZ = pos.field_72449_c - this.field_70161_v;
                            speed = 0.2;
                        }
                        catch (Exception ex) {
                            return;
                        }
                    } else if (this.func_70638_az() != null) {
                        this.leapVecX = this.func_70638_az().field_70165_t - this.field_70165_t;
                        this.leapVecZ = this.func_70638_az().field_70161_v - this.field_70161_v;
                    }
                    if (this.leapVecX != 0.0) {
                        double dist2 = Math.sqrt(this.leapVecX * this.leapVecX + this.leapVecZ * this.leapVecZ);
                        this.field_70159_w += this.leapVecX / dist2 * speed;
                        this.field_70179_y += this.leapVecZ / dist2 * speed;
                    }
                }
            } else if (this.leapVecX != 0.0) {
                double speed = 0.1;
                if (this.func_70090_H()) {
                    speed = 0.2;
                }
                double dist2 = Math.sqrt(this.leapVecX * this.leapVecX + this.leapVecZ * this.leapVecZ);
                this.field_70159_w += this.leapVecX / dist2 * speed;
                this.field_70179_y += this.leapVecZ / dist2 * speed;
            }
            if (this.func_70090_H()) {
                this.field_70181_x += 0.07;
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
    }

    protected void func_70628_a(boolean par1, int par2) {
        int j = 2;
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(TCItemRegistry.frogLeg, 1);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.type);
    }

    public void readSpawnData(ByteBuf buf) {
        this.type = buf.readInt();
    }

    public void func_82196_d(EntityLivingBase entity, float f) {
        if (this.type == 0) {
            return;
        }
        if (f < 4.0f && !this.field_70170_p.field_72995_K && this.field_70724_aR == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            double d = entity.field_70165_t - this.field_70165_t;
            double d1 = entity.field_70161_v - this.field_70161_v;
            EntityPoisonBlot entitypoisonblot = new EntityPoisonBlot(this.field_70170_p, (EntityLivingBase)this);
            entitypoisonblot.field_70163_u += (double)1.4f;
            double d2 = entity.field_70163_u + (double)entity.func_70047_e() - (double)0.2f - entitypoisonblot.field_70163_u;
            float f1 = MathHelper.func_76133_a((double)(d * d + d1 * d1)) * 0.2f;
            this.field_70170_p.func_72956_a((Entity)this, "frogspit", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)entitypoisonblot);
            entitypoisonblot.func_70186_c(d, d2 + (double)f1, d1, 0.6f, 12.0f);
            this.field_70724_aR = 50;
            this.field_70177_z = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
            this.field_70787_b = true;
        }
    }

    public float func_70053_R() {
        return 0.0f;
    }
}

