/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.entity.underdasea;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityTropicraftWaterMob
extends EntityWaterMob {
    protected WaterMobType type;
    public Entity targetEntity;
    protected float climbFactor = 0.1f;
    protected float horFactor = 0.1f;
    protected int hyperness = 30;
    protected int fickleness = 150;
    public boolean isSurfacing = false;
    public boolean reachedTarget = true;
    public float important1 = 0.0f;
    public float randomMotionSpeed = 0.0f;
    public float important2 = 0.0f;
    protected float randomMotionVecX = 0.0f;
    protected float randomMotionVecY = 0.0f;
    protected float randomMotionVecZ = 0.0f;
    public int targetHeight = 62;
    public int surfaceTick = 0;
    public int targetHeightTick = 120;
    public boolean isCatchable;
    public int outOfWaterTick = 0;
    public double fishingMaxLookDist = 10.0;
    public int fishingImmediateDispatchOdds = 10;
    public int fishingInterestOdds = 10;
    public int fishingBreakLineOdds = 500;
    public float fishingApproachSpeed = 1.4f;
    public float fishingEscapeSpeed = 2.4f;
    public static boolean fishingDebug = false;
    public List<String> fishingLog = new ArrayList<String>();
    public boolean fishingIsInterested = false;

    public EntityTropicraftWaterMob(World world) {
        super(world);
        this.important2 = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
        this.field_70728_aV = 5;
        this.type = WaterMobType.OCEAN_DWELLER;
    }

    public EntityTropicraftWaterMob(World par1World, WaterMobType type) {
        this(par1World);
        this.type = type;
    }

    protected abstract int attackStrength();

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.important1 += this.important2;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70760_ar = this.field_70761_aq = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / 3.1415927410125732);
        }
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / 3.1415927410125732);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        if (this.important1 > 6.283185f) {
            this.important1 -= 6.283185f;
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.important2 = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.surfaceTick != 0) {
            --this.surfaceTick;
        }
        if (!this.isSurfacing) {
            if (this.important1 < 3.141593f) {
                float f = this.important1 / 3.141593f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                }
            } else {
                this.randomMotionSpeed *= 0.95f;
            }
            if (!this.field_70170_p.field_72995_K && this.targetEntity == null) {
                this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            if (this.targetEntity == null) {
                this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / 3.141593f - this.field_70761_aq) * 0.1f;
                this.field_70177_z = this.field_70761_aq;
            }
        }
        if (!this.func_70090_H()) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = 0.0;
                this.field_70181_x *= (double)0.98f;
                this.field_70179_y = 0.0;
            }
            if (this.surfaceTick == 0) {
                this.isSurfacing = false;
            }
            this.func_70050_g(400);
            if (this.func_70090_H() || this.field_70725_aQ == 0) {
                // empty if block
            }
            Block blockUnder = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v));
            Block blockAt = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            if (!blockUnder.func_149688_o().func_76220_a()) {
                if (blockAt == Blocks.field_150350_a) {
                    this.field_70181_x -= 0.08;
                }
            } else {
                this.field_70181_x += 0.2;
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
    }

    public boolean func_70650_aV() {
        return false;
    }

    protected void func_70626_be() {
        ++this.field_70708_bq;
        if (this.targetEntity != null) {
            if (this.targetEntity.field_70128_L || !this.targetEntity.func_70090_H() || this.func_70032_d(this.targetEntity) > 10.0f) {
                this.targetEntity = null;
            } else if (this.field_70171_ac) {
                if (this.targetEntity.field_70163_u > (double)this.type.shallowDepth || !this.targetEntity.func_70090_H()) {
                    this.targetEntity = null;
                }
                if (this.field_70724_aR == 0 && this.targetEntity != null) {
                    this.attackEntity(this.targetEntity);
                }
                if (this.field_70724_aR > 0) {
                    this.field_70179_y = Math.cos((double)this.field_70761_aq / 57.26) * (double)this.horFactor;
                    this.field_70159_w = Math.sin((double)this.field_70761_aq / 57.26) * (double)this.horFactor;
                    this.field_70181_x = 0.0;
                }
            }
        }
        if (this.targetEntity == null) {
            this.targetEntity = this.func_70638_az();
            if (this.field_70146_Z.nextInt(this.hyperness) == 0 || !this.field_70171_ac || this.randomMotionVecX == 0.0f && this.randomMotionVecY == 0.0f && this.randomMotionVecZ == 0.0f) {
                float f = this.field_70146_Z.nextFloat() * 3.141593f * 2.0f;
                this.randomMotionVecX = MathHelper.func_76134_b((float)f) * this.horFactor;
                this.randomMotionVecZ = MathHelper.func_76126_a((float)f) * this.horFactor;
            }
            if (!this.isSurfacing && this.func_70090_H()) {
                if (!this.reachedTarget) {
                    --this.targetHeightTick;
                }
                if (this.targetHeightTick == 0) {
                    this.targetHeightTick = 120;
                    this.reachedTarget = true;
                }
                if (this.field_70163_u <= (double)this.targetHeight + 0.15 && this.field_70163_u >= (double)this.targetHeight - 0.15 || this.reachedTarget) {
                    this.reachedTarget = true;
                    this.targetHeightTick = 120;
                    this.randomMotionVecY = 0.0f;
                    if (this.field_70146_Z.nextInt(this.fickleness) == 0) {
                        this.reachedTarget = this.getTargetHeight();
                    }
                } else if (this.field_70163_u > (double)this.targetHeight && !this.reachedTarget) {
                    this.randomMotionVecY = -this.climbFactor;
                } else if (this.field_70163_u < (double)this.targetHeight && !this.reachedTarget) {
                    this.randomMotionVecY = this.climbFactor;
                }
            }
        }
    }

    protected int getDistanceToBase(int i, int height) {
        if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), height - i, MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o().func_76224_d()) {
            return this.getDistanceToBase(i + 1, height);
        }
        return i;
    }

    protected int getDistanceToSurface(int i) {
        if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), (int)this.field_70163_u + i, MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o().func_76224_d()) {
            return this.getDistanceToSurface(i + 1);
        }
        return i;
    }

    protected boolean getTargetHeight() {
        if (this.func_70026_G() && !this.isSurfacing) {
            if (this.field_70163_u < (double)(this.type.shallowDepth + 1)) {
                int depth = this.getDistanceToBase(0, 62);
                if (depth < 1) {
                    this.targetHeight = (int)this.field_70163_u;
                    return false;
                }
                if (depth < 63 - this.type.shallowDepth) {
                    this.targetHeight = 63 - this.field_70146_Z.nextInt(depth + 1);
                    if (this.targetHeight == 63) {
                        --this.targetHeight;
                    }
                    return false;
                }
                if ((depth -= 63 - this.type.shallowDepth) > this.type.deepDepth) {
                    depth = this.type.deepDepth;
                }
                this.targetHeight = this.type.shallowDepth - this.field_70146_Z.nextInt(depth + 1);
                return false;
            }
            int height = this.getDistanceToSurface(0);
            int depth = this.getDistanceToBase(0, (height += (int)this.field_70163_u) - 1);
            if (depth < 1) {
                this.targetHeight = (int)this.field_70163_u;
                return false;
            }
            int i1 = this.field_70146_Z.nextInt(depth);
            if (i1 == 0) {
                i1 = 1;
            }
            this.targetHeight = height - i1;
            return false;
        }
        return true;
    }

    public void setAttackHeading(double d, double d1, double d2, float f, float f1) {
        float f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        this.field_70159_w = d *= (double)f;
        this.field_70181_x = d1 *= (double)f;
        this.field_70179_y = d2 *= (double)f;
    }

    protected void attackEntity(Entity entity) {
        double d = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70161_v - this.field_70161_v;
        this.func_70625_a(this.targetEntity, 360.0f, 360.0f);
        double d2 = entity.field_70163_u - this.field_70163_u;
        float f1 = MathHelper.func_76133_a((double)(d * d + d1 * d1)) * 0.2f;
        this.setAttackHeading(d, d2, d1, this.horFactor, 12.0f);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70090_H() {
        return super.func_70090_H();
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 45.0 && this.field_70163_u < 63.0 && super.func_70601_bi();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (this.targetEntity != null && entity.equals((Object)this.targetEntity) && this.attackStrength() != 0) {
            this.targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.attackStrength());
            this.field_70724_aR = 60;
        }
    }

    public WaterMobType getType() {
        return this.type;
    }

    public int func_70627_aG() {
        return 120;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected int func_70693_a(EntityPlayer entityplayer) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public void func_70612_e(float f, float f1) {
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70673_aS() {
        return null;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void func_70088_a() {
        this.field_70180_af.func_75682_a(26, (Object)-1);
        super.func_70088_a();
    }

    public int getHookID() {
        return this.field_70180_af.func_75679_c(26);
    }

    public void setHookID(int i) {
        this.field_70180_af.func_75692_b(26, (Object)i);
    }

    public void onFishingUpdate() {
        if (this.getHookID() != -1) {
            List l = this.field_70170_p.field_72996_f;
            for (Entity e : l) {
                if (e.func_145782_y() != this.getHookID()) continue;
                if (e.field_70128_L) {
                    this.setHookID(-1);
                }
                if (this.field_70146_Z.nextInt(this.fishingBreakLineOdds) == 0 && this.field_70170_p.field_72995_K) continue;
            }
        }
    }

    public void fishDebug(String s) {
        try {
            if (fishingDebug && !this.field_70170_p.field_72995_K) {
                String out = "<" + this.func_70022_Q().split("\\.")[1] + this.func_145782_y() + ">: " + s;
                if (this.fishingLog.contains(out)) {
                    return;
                }
                System.out.println(out);
                this.fishingLog.add(out);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70625_a(Entity par1Entity, float par2, float par3) {
        double d2;
        double d0 = par1Entity.field_70165_t - this.field_70165_t;
        double d1 = par1Entity.field_70161_v - this.field_70161_v;
        if (par1Entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)par1Entity;
            d2 = entityliving.field_70163_u + (double)entityliving.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            d2 = (par1Entity.field_70121_D.field_72338_b + par1Entity.field_70121_D.field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        this.field_70125_A = this.func_70663_b(this.field_70125_A, f3, par3);
        this.field_70177_z = this.field_70761_aq = this.func_70663_b(this.field_70761_aq, f2, par2);
    }

    public void faceEntity(EntityLivingBase entSource, Entity par1Entity, float par2, float par3) {
        double d2;
        double d0 = par1Entity.field_70165_t - entSource.field_70165_t;
        double d1 = par1Entity.field_70161_v - entSource.field_70161_v;
        if (par1Entity instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)par1Entity;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (entSource.field_70163_u + (double)entSource.func_70047_e());
        } else {
            d2 = (par1Entity.field_70121_D.field_72338_b + par1Entity.field_70121_D.field_72337_e) / 2.0 - (entSource.field_70163_u + (double)entSource.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        entSource.field_70125_A = this.func_70663_b(entSource.field_70125_A, f3, par3);
        entSource.field_70177_z = this.func_70663_b(entSource.field_70177_z, f2, par2);
    }

    public float func_70663_b(float p_70663_1_, float p_70663_2_, float p_70663_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_70663_2_ - p_70663_1_));
        if (f3 > p_70663_3_) {
            f3 = p_70663_3_;
        }
        if (f3 < -p_70663_3_) {
            f3 = -p_70663_3_;
        }
        return p_70663_1_ + f3;
    }

    public static enum WaterMobType {
        SURFACE_TROPICS(90, 88),
        SURFACE_OVERWORLD(63, 62),
        OCEAN_DWELLER(62, 32);

        final int shallowDepth;
        final int deepDepth;

        private WaterMobType(int shallowDepth, int deepDepth) {
            this.shallowDepth = shallowDepth;
            this.deepDepth = deepDepth;
        }

        public int getShallowDepth() {
            return this.shallowDepth;
        }

        public int getDeepDepth() {
            return this.deepDepth;
        }
    }
}

