/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.item.scuba;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.tropicraft.item.scuba.ItemScubaChestplateGear;
import net.tropicraft.item.scuba.ItemScubaFlippers;
import net.tropicraft.item.scuba.ItemScubaGear;
import net.tropicraft.item.scuba.ItemScubaHelmet;
import net.tropicraft.item.scuba.ItemScubaLeggings;
import net.tropicraft.registry.TCCreativeTabRegistry;

public class ItemDiveComputer
extends ItemMap {
    public static final int UPDATE_RATE = 20;
    public int ticksUntilUpdate = 20;

    public ItemDiveComputer() {
        this.func_77637_a(TCCreativeTabRegistry.tabMisc);
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K) {
            return;
        }
        if (this.ticksUntilUpdate <= 0) {
            ItemStack flippersStack;
            ItemStack leggingsStack;
            ItemStack chestplateStack;
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            if (!this.isFullyUnderwater(world, player)) {
                return;
            }
            ItemStack helmetStack = player.func_71124_b(4);
            if (!this.armorCheck(world, player, helmetStack, chestplateStack = player.func_71124_b(3), leggingsStack = player.func_71124_b(2), flippersStack = player.func_71124_b(1))) {
                return;
            }
            player.func_70050_g(300);
            float air = this.getTagCompound(chestplateStack).func_74760_g("AirContained");
            ItemScubaGear.AirType airType = chestplateStack.func_77960_j() >= 2 ? ItemScubaGear.AirType.TRIMIX : ItemScubaGear.AirType.REGULAR;
            chestplateStack.func_77978_p().func_74776_a("AirContained", air - airType.getUsageRate());
            int currentDepth = MathHelper.func_76128_c((double)player.field_70163_u);
            if (currentDepth < chestplateStack.func_77978_p().func_74762_e("MaxDepth") || chestplateStack.func_77978_p().func_74762_e("MaxDepth") == 0) {
                chestplateStack.func_77978_p().func_74768_a("MaxDepth", currentDepth);
            }
            int waterBlocksAbove = 0;
            int waterBlocksBelow = 0;
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.field_70131_O - 0.5));
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            while (world.func_147439_a(x, y + waterBlocksAbove + 1, z).func_149688_o().func_76224_d()) {
                ++waterBlocksAbove;
            }
            while (world.func_147439_a(x, y - waterBlocksBelow - 1, z).func_149688_o().func_76224_d()) {
                ++waterBlocksBelow;
            }
            chestplateStack.func_77978_p().func_74768_a("WaterBlocksAbove", waterBlocksAbove);
            chestplateStack.func_77978_p().func_74768_a("WaterBlocksBelow", waterBlocksBelow);
            this.ticksUntilUpdate = 20;
        } else {
            --this.ticksUntilUpdate;
        }
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    private boolean isFullyUnderwater(World world, EntityPlayer player) {
        int x = MathHelper.func_76143_f((double)player.field_70165_t);
        int y = MathHelper.func_76143_f((double)(player.field_70163_u + (double)player.field_70131_O - 0.5));
        int z = MathHelper.func_76143_f((double)player.field_70161_v);
        return player.func_70055_a(Material.field_151586_h);
    }

    private boolean armorCheck(World world, EntityPlayer player, ItemStack helmetStack, ItemStack chestplateStack, ItemStack leggingsStack, ItemStack flippersStack) {
        if (helmetStack == null || chestplateStack == null || leggingsStack == null || flippersStack == null) {
            return false;
        }
        if (!(helmetStack.func_77973_b() instanceof ItemScubaHelmet)) {
            return false;
        }
        if (!(leggingsStack.func_77973_b() instanceof ItemScubaLeggings)) {
            return false;
        }
        if (!(flippersStack.func_77973_b() instanceof ItemScubaFlippers)) {
            return false;
        }
        if (!(chestplateStack.func_77973_b() instanceof ItemScubaChestplateGear)) {
            return false;
        }
        ItemScubaHelmet helmet = (ItemScubaHelmet)helmetStack.func_77973_b();
        ItemScubaLeggings leggings = (ItemScubaLeggings)leggingsStack.func_77973_b();
        ItemScubaFlippers flippers = (ItemScubaFlippers)flippersStack.func_77973_b();
        ItemScubaChestplateGear chestplate = (ItemScubaChestplateGear)chestplateStack.func_77973_b();
        return helmet.scubaMaterial == leggings.scubaMaterial && leggings.scubaMaterial == flippers.scubaMaterial && flippers.scubaMaterial == chestplate.scubaMaterial;
    }
}

