/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.tropicraft.block.tileentity.TileEntityEIHMixer;
import net.tropicraft.drinks.Ingredient;
import net.tropicraft.drinks.MixerRecipe;
import net.tropicraft.item.ItemCocktail;
import net.tropicraft.registry.TCItemRegistry;

public class TCDrinkMixerRegistry {
    private static TCDrinkMixerRegistry instance = null;
    private List<MixerRecipe> recipes = new LinkedList<MixerRecipe>();

    private TCDrinkMixerRegistry() {
    }

    public static TCDrinkMixerRegistry getInstance() {
        if (instance == null) {
            instance = new TCDrinkMixerRegistry();
        }
        return instance;
    }

    public void registerRecipe(MixerRecipe recipe) {
        this.recipes.add(recipe);
    }

    public boolean isRegisteredIngredient(ItemStack item) {
        if (item.func_77973_b() != null && item.func_77973_b() == TCItemRegistry.cocktail) {
            return true;
        }
        for (MixerRecipe recipe : this.recipes) {
            for (Ingredient i : recipe.getIngredients()) {
                if (!ItemStack.func_77989_b((ItemStack)i.getIngredient(), (ItemStack)item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRegisteredIngredient(Item item) {
        return this.isRegisteredIngredient(new ItemStack(item, 1, 0));
    }

    public ItemStack getResult(ItemStack[] ingredients) {
        for (MixerRecipe recipe : this.recipes) {
            if (ItemStack.func_77989_b((ItemStack)recipe.getIngredients()[0].getIngredient(), (ItemStack)ingredients[0]) && ItemStack.func_77989_b((ItemStack)recipe.getIngredients()[1].getIngredient(), (ItemStack)ingredients[1])) {
                return ItemCocktail.makeCocktail(recipe);
            }
            if (!ItemStack.func_77989_b((ItemStack)recipe.getIngredients()[0].getIngredient(), (ItemStack)ingredients[1]) || !ItemStack.func_77989_b((ItemStack)recipe.getIngredients()[1].getIngredient(), (ItemStack)ingredients[0])) continue;
            return ItemCocktail.makeCocktail(recipe);
        }
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        is.addAll(TileEntityEIHMixer.listIngredients(ingredients[0]));
        is.addAll(TileEntityEIHMixer.listIngredients(ingredients[1]));
        Collections.sort(is);
        return ItemCocktail.makeCocktail(is.toArray(new Ingredient[is.size()]));
    }

    public List<MixerRecipe> getRecipes() {
        return this.recipes;
    }
}

