/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.tropicraft.config.ConfigBiomes;
import net.tropicraft.entity.hostile.EntityAshenHunter;
import net.tropicraft.entity.hostile.EntityEIH;
import net.tropicraft.entity.hostile.EntityTreeFrogBlue;
import net.tropicraft.entity.hostile.EntityTreeFrogRed;
import net.tropicraft.entity.hostile.EntityTreeFrogYellow;
import net.tropicraft.entity.hostile.EntityTropiCreeper;
import net.tropicraft.entity.hostile.EntityTropiSkeleton;
import net.tropicraft.entity.hostile.SpiderAdult;
import net.tropicraft.entity.passive.EntityIguana;
import net.tropicraft.entity.passive.EntityTreeFrogGreen;
import net.tropicraft.entity.passive.Failgull;
import net.tropicraft.entity.passive.VMonkey;
import net.tropicraft.entity.underdasea.EntityEagleRay;
import net.tropicraft.entity.underdasea.EntityManOWar;
import net.tropicraft.entity.underdasea.EntityMarlin;
import net.tropicraft.entity.underdasea.EntitySeaTurtle;
import net.tropicraft.entity.underdasea.EntitySeaUrchin;
import net.tropicraft.entity.underdasea.EntitySeahorse;
import net.tropicraft.entity.underdasea.EntityStarfish;
import net.tropicraft.entity.underdasea.EntityTropicalFish;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.biomes.BiomeGenRainforest;
import net.tropicraft.world.biomes.BiomeGenTropics;
import net.tropicraft.world.biomes.BiomeGenTropicsBeach;
import net.tropicraft.world.biomes.BiomeGenTropicsOcean;
import net.tropicraft.world.biomes.BiomeGenTropicsRiver;
import net.tropicraft.world.worldgen.WorldGenBamboo;
import net.tropicraft.world.worldgen.WorldGenCoral;
import net.tropicraft.world.worldgen.WorldGenEIH;
import net.tropicraft.world.worldgen.WorldGenSunkenShip;
import net.tropicraft.world.worldgen.WorldGenTallFlower;
import net.tropicraft.world.worldgen.WorldGenTropicraftCurvedPalm;
import net.tropicraft.world.worldgen.WorldGenTropicraftFlowers;
import net.tropicraft.world.worldgen.WorldGenTropicraftLargePalmTrees;
import net.tropicraft.world.worldgen.WorldGenTropicraftNormalPalms;
import net.tropicraft.world.worldgen.WorldGenWaterfall;

public class BiomeGenTropicraft
extends BiomeGenBase {
    public static final int[] DEFAULT_FLOWER_META = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    public static BiomeGenBase tropicsOcean = new BiomeGenTropicraft(ConfigBiomes.tropicsOceanID).func_150570_a(new BiomeGenBase.Height(-1.0f, 0.4f)).func_76732_a(1.5f, 1.25f).func_76735_a("Tropical Ocean");
    public static BiomeGenBase tropics = new BiomeGenTropics(ConfigBiomes.tropicsID).func_150570_a(new BiomeGenBase.Height(0.15f, 0.15f)).func_76732_a(2.0f, 1.5f).func_76735_a("Tropics");
    public static BiomeGenBase rainforestPlains = new BiomeGenRainforest(ConfigBiomes.rainforestPlainsID).func_150570_a(new BiomeGenBase.Height(0.25f, 0.1f)).func_76739_b(1148975).func_76732_a(1.5f, 2.0f).func_76735_a("Rainforest Plains");
    public static BiomeGenBase rainforestHills = new BiomeGenRainforest(ConfigBiomes.rainforestHillsID).func_150570_a(new BiomeGenBase.Height(0.45f, 0.425f)).func_76739_b(1148975).func_76732_a(1.5f, 2.0f).func_76735_a("Rainforest Hills");
    public static BiomeGenBase rainforestMountains = new BiomeGenRainforest(ConfigBiomes.rainforestMountainsID).func_150570_a(new BiomeGenBase.Height(1.0f, 1.2f)).func_76732_a(1.5f, 2.0f).func_76735_a("Rainforest Mountains");
    public static BiomeGenBase islandMountains = new BiomeGenRainforest(ConfigBiomes.islandMountainsID).func_150570_a(new BiomeGenBase.Height(0.1f, 2.5f)).func_76732_a(1.5f, 2.0f).func_76735_a("Extreme Rainforest Mountains");
    public static BiomeGenBase tropicsRiver = new BiomeGenTropicsRiver(ConfigBiomes.tropicsRiverID).func_150570_a(new BiomeGenBase.Height(-0.7f, 0.05f)).func_76732_a(1.5f, 1.25f).func_76735_a("Tropical River");
    public static BiomeGenBase tropicsBeach = new BiomeGenTropicsBeach(ConfigBiomes.tropicsBeachID).func_150570_a(new BiomeGenBase.Height(-0.1f, 0.1f)).func_76732_a(1.5f, 1.25f).func_76735_a("Tropical Beach");
    public static BiomeGenBase tropicsLake = new BiomeGenTropicsOcean(ConfigBiomes.tropicsLakeID).func_150570_a(new BiomeGenBase.Height(-0.6f, 0.1f)).func_76732_a(1.5f, 1.5f).func_76735_a("Tropical Lake");
    public Block sandBlock = Blocks.field_150354_m;
    public short sandMetadata = 0;
    public static boolean DISABLEDECORATION = false;

    public BiomeGenTropicraft(int biomeID) {
        super(biomeID);
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_82914_M.clear();
        this.field_76755_L.clear();
        if (biomeID == ConfigBiomes.rainforestMountainsID || biomeID == ConfigBiomes.rainforestHillsID || biomeID == ConfigBiomes.rainforestPlainsID) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTreeFrogBlue.class, 25, 1, 2));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTreeFrogGreen.class, 25, 1, 2));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTreeFrogRed.class, 25, 1, 2));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTreeFrogYellow.class, 25, 1, 2));
        }
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(VMonkey.class, 20, 1, 3));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityIguana.class, 20, 1, 1));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTropiCreeper.class, 2, 1, 2));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEIH.class, 10, 1, 1));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTropiSkeleton.class, 25, 1, 8));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityAshenHunter.class, 2, 3, 12));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(Failgull.class, 30, 5, 15));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntityTropicalFish.class, 10, 1, 12));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntityEagleRay.class, 6, 1, 3));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntitySeaTurtle.class, 6, 1, 3));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntitySeahorse.class, 6, 1, 3));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntityMarlin.class, 10, 1, 3));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntityManOWar.class, 4, 1, 2));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntityStarfish.class, 4, 1, 4));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntitySeaUrchin.class, 4, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(SpiderAdult.class, 50, 1, 3));
    }

    public void func_76728_a(World world, Random rand, int x, int z) {
        int k;
        int i;
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (biome == tropicsOcean && rand.nextInt(5) == 0) {
            new WorldGenCoral().func_76484_a(world, rand, x + 6 + rand.nextInt(4), 64, z + 6 + rand.nextInt(4));
        }
        if (rand.nextInt(2) == 0) {
            i = this.randCoord(rand, x, 16);
            k = this.randCoord(rand, z, 16);
            new WorldGenBamboo(world, rand).generate(i, this.getTerrainHeightAt(world, i, k), k);
        }
        if (rand.nextInt(50) == 0) {
            i = this.randCoord(rand, x, 16);
            k = this.randCoord(rand, z, 16);
            new WorldGenEIH(world, rand).generate(i, this.getTerrainHeightAt(world, i, k), k);
        }
        if (rand.nextInt(3) == 0) {
            i = this.randCoord(rand, x, 16);
            k = this.randCoord(rand, z, 16);
            new WorldGenTallFlower(world, rand, (Block)TCBlockRegistry.tallFlowers, 0, 1).generate(i, this.getTerrainHeightAt(world, i, k), k);
        }
        if (rand.nextInt(3) == 0) {
            i = this.randCoord(rand, x, 16);
            k = this.randCoord(rand, z, 16);
            new WorldGenTallFlower(world, rand, (Block)TCBlockRegistry.pineapple, 7, 8).generate(i, this.getTerrainHeightAt(world, i, k), k);
        }
        i = this.randCoord(rand, x, 16);
        k = this.randCoord(rand, z, 16);
        new WorldGenTropicraftFlowers(world, rand, (Block)TCBlockRegistry.flowers, DEFAULT_FLOWER_META).generate(i, this.getTerrainHeightAt(world, i, k), k);
        if (rand.nextInt(300) == 0) {
            i = this.randCoord(rand, x, 16);
            k = this.randCoord(rand, z, 16);
            new WorldGenSunkenShip(world, rand).generate(i, this.getTerrainHeightAt(world, i, k), k);
        }
        if (rand.nextInt(3) == 0) {
            i = this.randCoord(rand, x, 16);
            k = this.randCoord(rand, z, 16);
            new WorldGenTropicraftCurvedPalm(world, rand).generate(i, this.getTerrainHeightAt(world, i, k), k);
        }
        if (rand.nextInt(3) == 0) {
            i = this.randCoord(rand, x, 16);
            k = this.randCoord(rand, z, 16);
            new WorldGenTropicraftLargePalmTrees(false).func_76484_a(world, rand, i, this.getTerrainHeightAt(world, i, k), k);
        }
        if (rand.nextInt(3) == 0) {
            i = this.randCoord(rand, x, 16);
            k = this.randCoord(rand, z, 16);
            new WorldGenTropicraftNormalPalms(false).func_76484_a(world, rand, i, this.getTerrainHeightAt(world, i, k), k);
        }
        if (rand.nextInt(4) == 0) {
            i = this.randCoord(rand, x, 16);
            k = this.randCoord(rand, z, 16);
            new WorldGenTallGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, i, this.getTerrainHeightAt(world, i, k), k);
        }
        for (int a = 0; a < 25; ++a) {
            new WorldGenWaterfall(world, rand).generate(this.randCoord(rand, x, 16), 63 + rand.nextInt(193), this.randCoord(rand, z, 16));
        }
    }

    public int getTerrainHeightAt(World world, int x, int z) {
        for (int y = world.func_72976_f(x, z) + 1; y > 0; --y) {
            Block id = world.func_147439_a(x, y, z);
            if (id != Blocks.field_150349_c && id != Blocks.field_150346_d && id != Blocks.field_150354_m) continue;
            return y + 1;
        }
        return 0;
    }

    public final int randCoord(Random rand, int base, int variance) {
        return base + rand.nextInt(variance);
    }
}

