/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.perlin;

import java.util.Random;

public class SimplexNoise {
    int[] perm = new int[512];
    public int[][] grad2d = new int[][]{{0, 0}, {0, 1}, {1, 1}, {1, 0}};

    public SimplexNoise(long seed) {
        int i;
        Random rand = new Random(seed);
        for (i = 0; i < 256; ++i) {
            this.perm[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int j = rand.nextInt(256);
            this.perm[i] = this.perm[i] ^ this.perm[j];
            this.perm[j] = this.perm[i] ^ this.perm[j];
            this.perm[i] = this.perm[i] ^ this.perm[j];
        }
        for (i = 0; i < 256; ++i) {
            this.perm[i + 256] = this.perm[i];
        }
    }

    private static double lerp(double x, double y, double n) {
        return x + n * (y - x);
    }

    private static int fastFloor(double x) {
        return x > 0.0 ? (int)x : (int)x - 1;
    }

    private static double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    private static double dot2(int[] grad2, double x, double y) {
        return (double)grad2[0] * x + (double)grad2[1] * y;
    }
}

