/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.tropicraft.block.tileentity.TileEntityBambooChest;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCItemRegistry;
import net.tropicraft.world.worldgen.TCDirectionalGen;

public class WorldGenSunkenShip
extends TCDirectionalGen {
    public WorldGenSunkenShip(World world, Random random) {
        super(world, random, random.nextInt(4));
    }

    @Override
    public boolean generate(int i, int j, int k) {
        this.setOrigin(i, k);
        if (this.worldObj.func_147439_a(i, j + 4, k) != TCBlockRegistry.tropicsWater) {
            return false;
        }
        int length = this.rand.nextInt(25) + 25;
        int y = ++j;
        while (true) {
            boolean hasGenned = false;
            int fib = 2;
            int lastFib = 1;
            int width = y - j;
            for (int x = 0; x < length; ++x) {
                if (x == fib && (double)x <= (double)length / 3.0) {
                    ++width;
                    lastFib = (fib += lastFib) - lastFib;
                }
                if (x > length - 3) {
                    --width;
                }
                if (width < 0) continue;
                for (int z = -width; z <= width; ++z) {
                    if (this.rand.nextInt(5) >= 3) continue;
                    if (y == j || x == length - 1) {
                        this.placeBlockWithDir(x, y, z, TCBlockRegistry.planks, 1);
                        if (z == -width || z == width || x == length - 1) {
                            this.placeBlockWithDir(x, y + 1, z, TCBlockRegistry.planks, 1);
                        }
                        if (x != length / 2 || z != 0) continue;
                        this.placeBlockWithDir(x, y + 1, z, TCBlockRegistry.planks, 1);
                        this.placeBlockWithDir(x, y + 2, z, TCBlockRegistry.planks, 1);
                        this.placeBlockWithDir(x, y + 3, z, TCBlockRegistry.planks, 1);
                        continue;
                    }
                    if (x == length / 2 && z == 0 && y == j - 2) {
                        this.placeBlockWithDir(x, y, z, (Block)TCBlockRegistry.bambooChest, 0);
                        TileEntityBambooChest chest = (TileEntityBambooChest)this.getTEWithDir(x, y, z);
                        if (chest == null) continue;
                        chest.func_70299_a(0, this.randLoot());
                        continue;
                    }
                    if (z == -width || z == width) {
                        this.placeBlockWithDir(x, y, z, TCBlockRegistry.planks, 1);
                        continue;
                    }
                    this.placeBlockWithDir(x, y, z, Blocks.field_150350_a, 0);
                }
                hasGenned = true;
            }
            if (!hasGenned) break;
            --y;
        }
        return false;
    }

    public ItemStack randLoot() {
        int picker = this.rand.nextInt(18);
        if (picker < 6) {
            return new ItemStack((Block)TCBlockRegistry.bambooChute, this.rand.nextInt(20) + 1);
        }
        if (picker < 10) {
            return new ItemStack((Item)TCItemRegistry.scale, this.rand.nextInt(3) + 1);
        }
        if (picker < 12) {
            return new ItemStack(Items.field_151043_k, this.rand.nextInt(4) + 2);
        }
        if (picker < 15) {
            return new ItemStack(TCItemRegistry.shells, this.rand.nextInt(5) + 1, this.rand.nextInt(6));
        }
        return new ItemStack((Item)TCItemRegistry.blowGun, 1);
    }
}

