/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenTCUndergrowth
extends TCGenBase {
    private static final int LARGE_BUSH_CHANCE = 10;
    private static final Block WOOD_BLOCK = TCBlockRegistry.logs;
    private static final int WOOD_META = 1;
    private static final Block LEAF_BLOCK = TCBlockRegistry.rainforestLeaves;
    private static final int LEAF_META = 1;

    public WorldGenTCUndergrowth(World world, Random rand) {
        super(world, rand);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        Block blockUnder = this.worldObj.func_147439_a(i, j - 1, k);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        this.worldObj.func_147465_d(i, j, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
        int size = 2;
        if (this.rand.nextInt(10) == 0) {
            size = 3;
        }
        for (int y = j; y < j + size; ++y) {
            int bushWidth = size - (y - j);
            for (int x = i - bushWidth; x < i + bushWidth; ++x) {
                int xVariance = x - i;
                for (int z = k - bushWidth; z < k + bushWidth; ++z) {
                    int zVariance = z - k;
                    if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && this.rand.nextInt(2) == 0 || this.worldObj.func_147439_a(x, y, z).func_149662_c()) continue;
                    this.worldObj.func_147465_d(x, y, z, LEAF_BLOCK, 1, blockGenNotifyFlag);
                }
            }
        }
        return true;
    }
}

