/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenTropicraftFruitTrees
extends TCGenBase {
    private static final Block WOOD_BLOCK = Blocks.field_150364_r;
    private static final Block FRUIT_LEAF_BLOCK = TCBlockRegistry.fruitLeaves;
    private static final Block REGULAR_LEAF_BLOCK = TCBlockRegistry.rainforestLeaves;
    int treeType;

    public WorldGenTropicraftFruitTrees(World world, Random rand, int i) {
        super(world, rand);
        this.treeType = i;
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int y;
        int height = this.rand.nextInt(3) + 4;
        boolean canGenerate = true;
        if (j < 1 || j + height + 1 > this.worldObj.func_72800_K()) {
            return false;
        }
        for (int y2 = j; y2 <= j + 1 + height; ++y2) {
            int size = 1;
            if (y2 == j) {
                size = 0;
            }
            if (y2 >= j + 1 + height - 2) {
                size = 2;
            }
            for (int x = i - size; x <= i + size && canGenerate; ++x) {
                for (int z = k - size; z <= k + size && canGenerate; ++z) {
                    if (y2 >= 0 && y2 < this.worldObj.func_72800_K()) {
                        Block block = this.worldObj.func_147439_a(x, y2, z);
                        if (block == Blocks.field_150350_a || block == FRUIT_LEAF_BLOCK) continue;
                        canGenerate = false;
                        continue;
                    }
                    canGenerate = false;
                }
            }
        }
        if (!canGenerate) {
            return false;
        }
        Block blockUnder = this.worldObj.func_147439_a(i, j - 1, k);
        if (blockUnder != Blocks.field_150349_c && blockUnder != Blocks.field_150346_d || j >= this.worldObj.func_72800_K() - height - 1) {
            return false;
        }
        this.worldObj.func_147465_d(i, j - 1, k, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        for (y = j - 3 + height; y <= j + height; ++y) {
            int presizeMod = y - (j + height);
            int size = 1 - presizeMod / 2;
            for (int x = i - size; x <= i + size; ++x) {
                int localX = x - i;
                for (int z = k - size; z <= k + size; ++z) {
                    int localZ = z - k;
                    if (Math.abs(localX) == size && Math.abs(localZ) == size && (this.rand.nextInt(2) == 0 || presizeMod == 0) || this.worldObj.func_147439_a(x, y, z).func_149662_c()) continue;
                    if (this.rand.nextBoolean()) {
                        this.worldObj.func_147465_d(x, y, z, FRUIT_LEAF_BLOCK, this.treeType, blockGenNotifyFlag);
                        continue;
                    }
                    this.worldObj.func_147465_d(x, y, z, REGULAR_LEAF_BLOCK, 2, blockGenNotifyFlag);
                }
            }
        }
        for (y = 0; y < height; ++y) {
            Block k2 = this.worldObj.func_147439_a(i, j + y, k);
            if (k2 != Blocks.field_150350_a && k2.func_149688_o() != Material.field_151584_j) continue;
            this.worldObj.func_147465_d(i, j + y, k, WOOD_BLOCK, 0, blockGenNotifyFlag);
        }
        return true;
    }
}

