/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapData;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCItemRegistry;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenTropicsTreasure
extends TCGenBase {
    private static final List<Item> treasureList = new ArrayList<Item>();
    private static final List<Block> sandBlocks = new ArrayList<Block>();

    public WorldGenTropicsTreasure(World worldObj, Random rand) {
        super(worldObj, rand);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int depth = this.rand.nextInt(2) + 2;
        block0: for (int tries = 0; tries < 10; ++tries) {
            int surroundX;
            int surroundZ;
            int y;
            int x = i + this.rand.nextInt(8) - this.rand.nextInt(8);
            int z = k + this.rand.nextInt(8) - this.rand.nextInt(8);
            for (y = j = this.getTerrainHeightAt(x, z) - 1; y > j - depth; --y) {
                if (!sandBlocks.contains(this.worldObj.func_147439_a(x, y, z))) continue block0;
            }
            int sandArea = 3;
            for (surroundZ = z - sandArea; surroundZ <= z + sandArea; ++surroundZ) {
                for (surroundX = x - sandArea; surroundX <= x + sandArea; ++surroundX) {
                    if (!sandBlocks.contains(this.worldObj.func_147439_a(surroundX, j, surroundZ))) continue block0;
                }
            }
            for (surroundZ = z - sandArea; surroundZ <= z + sandArea; ++surroundZ) {
                for (surroundX = x - sandArea; surroundX <= x + sandArea; ++surroundX) {
                    if (!(this.rand.nextFloat() < 0.2f)) continue;
                    this.worldObj.func_147449_b(surroundX, j, surroundZ, (Block)TCBlockRegistry.purifiedSand);
                }
            }
            this.worldObj.func_147449_b(x, y, z, (Block)TCBlockRegistry.bambooChest);
            TileEntityChest tileentitychest = (TileEntityChest)this.worldObj.func_147438_o(x, y, z);
            if (tileentitychest == null) {
                return false;
            }
            boolean hasAddedMap = false;
            for (int e = 0; e < 8; ++e) {
                ItemStack itemstack = this.pickCheckLootItem(this.worldObj, this.rand, x, y, z);
                if (itemstack == null || itemstack.func_77973_b() == Items.field_151148_bJ && hasAddedMap) continue;
                if (itemstack.func_77973_b() == Items.field_151148_bJ) {
                    hasAddedMap = true;
                    this.initializeMap(this.worldObj, itemstack, x, y, z);
                }
                tileentitychest.func_70299_a(this.rand.nextInt(tileentitychest.func_70302_i_()), itemstack);
            }
            return true;
        }
        return true;
    }

    private ItemStack pickCheckLootItem(World worldObj, Random rand, int x, int y, int z) {
        Item loot = treasureList.get(rand.nextInt(treasureList.size()));
        if (loot == Items.field_151042_j) {
            return new ItemStack(loot, rand.nextInt(36) + 1);
        }
        if (loot == Items.field_151043_k) {
            return new ItemStack(loot, rand.nextInt(46) + 1);
        }
        if (loot == Items.field_151045_i) {
            return new ItemStack(loot, rand.nextInt(24) + 6);
        }
        if (loot == Items.field_151032_g) {
            return new ItemStack(loot, rand.nextInt(45) + 1);
        }
        if (loot == Items.field_151074_bl) {
            return new ItemStack(loot, rand.nextInt(40) + 1);
        }
        if (loot == TCItemRegistry.ore) {
            return new ItemStack(loot, rand.nextInt(10) + 5, rand.nextInt(5));
        }
        if (loot == TCItemRegistry.shells) {
            return new ItemStack(loot, rand.nextInt(4) + 2, rand.nextInt(6));
        }
        return new ItemStack(loot);
    }

    private void initializeMap(World worldObj, ItemStack mapItem, int x, int y, int z) {
        mapItem.func_77964_b(worldObj.func_72841_b("map"));
        String mapName = "map_" + mapItem.func_77960_j();
        MapData data = new MapData(mapName);
        worldObj.func_72823_a(mapName, (WorldSavedData)data);
        data.field_76201_a = x;
        data.field_76199_b = z;
        data.field_76197_d = (byte)3;
        data.func_76185_a();
    }

    static {
        treasureList.add(Items.field_151042_j);
        treasureList.add(Items.field_151043_k);
        treasureList.add(Items.field_151045_i);
        treasureList.add(TCItemRegistry.ore);
        treasureList.add(TCItemRegistry.shells);
        treasureList.add((Item)TCItemRegistry.scaleHelmet);
        treasureList.add((Item)TCItemRegistry.scaleBoots);
        treasureList.add((Item)TCItemRegistry.scaleChestplate);
        treasureList.add((Item)TCItemRegistry.scaleLeggings);
        treasureList.add(Items.field_151153_ao);
        treasureList.add(Items.field_151032_g);
        treasureList.add((Item)TCItemRegistry.swordEudialyte);
        treasureList.add((Item)TCItemRegistry.swordZircon);
        treasureList.add(Items.field_151074_bl);
        treasureList.add((Item)Items.field_151148_bJ);
        treasureList.add(Items.field_151070_bp);
        treasureList.add(TCItemRegistry.recordTradeWinds);
        treasureList.add(TCItemRegistry.recordEasternIsles);
        treasureList.add(TCItemRegistry.recordBuriedTreasure);
        treasureList.add(TCItemRegistry.recordLowTide);
        treasureList.add(TCItemRegistry.recordSummering);
        treasureList.add(TCItemRegistry.recordTheTribe);
        sandBlocks.add((Block)Blocks.field_150354_m);
        sandBlocks.add(Blocks.field_150322_A);
        sandBlocks.add((Block)TCBlockRegistry.purifiedSand);
    }
}

