/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenUpTree
extends TCGenBase {
    private static final Block WOOD_BLOCK = TCBlockRegistry.logs;
    private static final int WOOD_META = 1;
    private static final Block LEAF_BLOCK = TCBlockRegistry.rainforestLeaves;
    private static final int LEAF_META = 1;

    public WorldGenUpTree(World world, Random random) {
        super(world, random);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int y;
        Block blockUnder = this.worldObj.func_147439_a(i, j - 1, k);
        if (blockUnder != Blocks.field_150349_c && blockUnder != Blocks.field_150346_d) {
            return false;
        }
        int height = this.rand.nextInt(4) + 6;
        for (y = j; y < j + height; ++y) {
            Block block = this.worldObj.func_147439_a(i, y, k);
            if (block.func_149688_o() != Material.field_151584_j || block.func_149662_c()) continue;
            return false;
        }
        for (y = j; y < j + height; ++y) {
            this.worldObj.func_147465_d(i, y, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
            if (this.rand.nextInt(5) == 0) {
                int x = this.rand.nextInt(3) - 1 + i;
                int z = k;
                if (x - i == 0) {
                    z += this.rand.nextBoolean() ? 1 : -1;
                }
                this.worldObj.func_147465_d(x, y, z, LEAF_BLOCK, 1, blockGenNotifyFlag);
            }
            if (y != j + height - 1) continue;
            this.worldObj.func_147465_d(i + 1, y, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i - 1, y, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i, y, k + 1, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i, y, k - 1, WOOD_BLOCK, 1, blockGenNotifyFlag);
        }
        int radius = this.rand.nextInt(2) + 3;
        this.genCircle(i, j + height, k, radius, 0.0, LEAF_BLOCK, 1, false);
        this.genCircle(i, j + height + 1, k, radius + 2, radius, LEAF_BLOCK, 1, false);
        this.genCircle(i, j + height + 2, k, radius + 3, radius + 2, LEAF_BLOCK, 1, false);
        return true;
    }
}

