/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.API;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeBlacklist {
    private static Class tile;
    private static Method add;

    public static void addBlacklist(BiomeConnection bc) {
        try {
            add.invoke(null, bc);
        }
        catch (IllegalAccessException e) {
            ReikaJavaLibrary.pConsole("Error adding Biome Changer Blacklist:");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            ReikaJavaLibrary.pConsole("Error adding Biome Changer Blacklist:");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            ReikaJavaLibrary.pConsole("Error adding Biome Changer Blacklist:");
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            ReikaJavaLibrary.pConsole("Error adding Biome Changer Blacklist: Class not loaded properly!");
            e.printStackTrace();
        }
    }

    static {
        try {
            tile = Class.forName("Reika.ChromatiCraft.TileEntity.TileEntityBiomeChanger");
            add = tile.getMethod("addBiomeConnection", BiomeConnection.class);
        }
        catch (ClassNotFoundException e) {
            ReikaJavaLibrary.pConsole("Could not load ChromatiCraft class!");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            ReikaJavaLibrary.pConsole("Could not read ChromatiCraft class!");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            ReikaJavaLibrary.pConsole("Could not read ChromatiCraft class!");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            ReikaJavaLibrary.pConsole("Could not read ChromatiCraft class!");
            e.printStackTrace();
        }
    }

    public static final class BlacklistOutputBiomeConnection
    extends BlacklistBiomeConnection {
        @Override
        public boolean isLegalTransition(BiomeGenBase in, BiomeGenBase out) {
            Collection list = (Collection)this.blacklist.get(in);
            return list == null || !list.contains(out);
        }
    }

    public static final class BlacklistInputBiomeConnection
    extends BlacklistBiomeConnection {
        @Override
        public boolean isLegalTransition(BiomeGenBase in, BiomeGenBase out) {
            Collection list = (Collection)this.blacklist.get(out);
            return list == null || !list.contains(in);
        }
    }

    public static abstract class BlacklistBiomeConnection
    implements BiomeConnection {
        protected final HashMap<BiomeGenBase, Collection<BiomeGenBase>> blacklist = new HashMap();

        public BlacklistBiomeConnection() {
        }

        public BlacklistBiomeConnection(HashMap<BiomeGenBase, Collection<BiomeGenBase>> list) {
            for (BiomeGenBase b : list.keySet()) {
                this.blacklist.put(b, list.get(b));
            }
        }
    }

    public static final class DisallowAsOutputConnection
    implements BiomeConnection {
        private final BiomeGenBase biome;

        public DisallowAsOutputConnection(BiomeGenBase b) {
            this.biome = b;
        }

        @Override
        public boolean isLegalTransition(BiomeGenBase in, BiomeGenBase out) {
            return this.biome != out;
        }
    }

    public static final class DisallowAsInputConnection
    implements BiomeConnection {
        private final BiomeGenBase biome;

        public DisallowAsInputConnection(BiomeGenBase b) {
            this.biome = b;
        }

        @Override
        public boolean isLegalTransition(BiomeGenBase in, BiomeGenBase out) {
            return this.biome != in;
        }
    }

    public static final class TotalDisallowConnection
    implements BiomeConnection {
        private final BiomeGenBase biome;

        public TotalDisallowConnection(BiomeGenBase b) {
            this.biome = b;
        }

        @Override
        public boolean isLegalTransition(BiomeGenBase in, BiomeGenBase out) {
            return this.biome != in && this.biome != out;
        }
    }

    public static interface BiomeConnection {
        public boolean isLegalTransition(BiomeGenBase var1, BiomeGenBase var2);
    }
}

