/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM;

import Reika.DragonAPI.ASM.Patchers.Patcher;
import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Entity.TameHostile;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenMutated;
import net.minecraftforge.common.BiomeDictionary;

public class DragonAPIClassTransformer
implements IClassTransformer {
    private static final MultiMap<String, Patcher> classes;
    private static int bukkitFlags;
    private static boolean nullItemPrintout;
    private static boolean nullItemCrash;

    public static boolean updateSetBlockLighting(int x, int y, int z, World world, int flags) {
        if ((flags & 8) == 0) {
            return world.func_147451_t(x, y, z);
        }
        return false;
    }

    public static boolean allowMobSleeping(List li) {
        for (Object o : li) {
            if (o instanceof TameHostile) continue;
            return false;
        }
        return true;
    }

    public static void validateItemStack(Item i) {
        if (i == null && (nullItemCrash || nullItemPrintout)) {
            String s = "A mod created an ItemStack of a null item.\n";
            s = s + "Though somewhat common, this is a very bad practice as such ItemStacks crash almost immediately upon even basic use.\n";
            s = s + "Check the Stacktrace for the mod code coming before ItemStack.func_150996_a or ItemStack.<init>.\n";
            s = s + "Notify the developer of that mod.\n";
            s = s + "Though it is possible that in this case, the mod was not going to do anything with the item, such stacks are commonly\n";
            s = s + "registered the OreDictionary, dropped as entities, or added to dungeon loot tables, resulting in crashes in other mods.\n";
            s = s + "As a result, and the fact that a null-item stack is never necessary, it should be avoided in all cases.\n";
            if (nullItemCrash) {
                s = s + "You can turn this crash off in the DragonAPI configs, but you would likely crash anyways, usually soon afterward.";
                throw new IllegalStateException(s);
            }
            s = s + "You can disable this printout with a JVM argument, but doing so is not recommended.";
            ReikaASMHelper.logError(s);
            Thread.dumpStack();
        }
    }

    public static void registerPermutedBiomesToDictionary() {
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase b = BiomeGenBase.field_76773_a[i];
            if (!(b instanceof BiomeGenMutated)) continue;
            BiomeGenBase parent = ((BiomeGenMutated)b).field_150611_aD;
            BiomeDictionary.registerBiomeType((BiomeGenBase)b, (BiomeDictionary.Type[])BiomeDictionary.getTypesForBiome((BiomeGenBase)parent));
        }
    }

    public byte[] transform(String className, String className2, byte[] opcodes) {
        Collection<Patcher> c;
        if (!classes.isEmpty() && (c = classes.get(className)) != null) {
            ReikaASMHelper.activeMod = "DragonAPI";
            for (Patcher p : c) {
                ReikaASMHelper.log("Running patcher " + p);
                try {
                    opcodes = p.apply(opcodes);
                }
                catch (ASMException e) {
                    if (p.isExceptionThrowing()) {
                        throw e;
                    }
                    ReikaASMHelper.logError("ASM ERROR IN " + p + ":");
                    e.printStackTrace();
                }
            }
            classes.remove(className);
            ReikaASMHelper.activeMod = null;
        }
        return opcodes;
    }

    public static int getBukkitFlags() {
        return bukkitFlags;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum BukkitBitflags {
        CAULDRON("kcauldron.KCauldron"),
        THERMOS("thermos.Thermos");

        private final String className;
        public final int flag;
        private static final BukkitBitflags[] list;

        private BukkitBitflags(String s) {
            this.className = s;
            this.flag = 1 << this.ordinal();
        }

        private boolean test() {
            try {
                return Class.forName(this.className) != null;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        private static int calculateFlags() {
            int flags = 0;
            for (int i = 0; i < list.length; ++i) {
                BukkitBitflags b = list[i];
                if (!b.test()) continue;
                flags |= b.flag;
            }
            return flags;
        }

        static /* synthetic */ int access$000() {
            return BukkitBitflags.calculateFlags();
        }

        static {
            list = BukkitBitflags.values();
        }
    }
}

