/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Auxiliary.Trackers.RemoteAssetLoader;
import Reika.DragonAPI.Command.ClearItemsCommand;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Exception.WTFException;
import Reika.DragonAPI.Instantiable.Event.AddRecipeEvent;
import Reika.DragonAPI.Instantiable.Event.AddSmeltingEvent;
import Reika.DragonAPI.Instantiable.Event.Client.ChatEvent;
import Reika.DragonAPI.Instantiable.Event.Client.GameFinishedLoadingEvent;
import Reika.DragonAPI.Instantiable.Event.Client.HotbarKeyEvent;
import Reika.DragonAPI.Instantiable.Event.ItemUpdateEvent;
import Reika.DragonAPI.Instantiable.Event.MobTargetingEvent;
import Reika.DragonAPI.Instantiable.Event.XPUpdateEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.TileEntity.PlayerBreakHook;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.NEIIntercept;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderWorldEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import paulscode.sound.SoundSystemConfig;

public class DragonAPIEventWatcher {
    public static final DragonAPIEventWatcher instance = new DragonAPIEventWatcher();
    private long IDMsgCooldown = 0L;

    private DragonAPIEventWatcher() {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fixRespirationFourPlusFog(EntityViewRenderEvent.FogColors evt) {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        ItemStack helm = ep.func_82169_q(3);
        if (helm != null && ReikaEnchantmentHelper.getEnchantmentLevel(Enchantment.field_77340_h, helm) > 3) {
            if (ep.func_70644_a(Potion.field_76440_q)) {
                evt.blue = 0.0f;
                evt.green = 0.0f;
                evt.red = 0.0f;
            } else if (ep.func_70055_a(Material.field_151586_h)) {
                evt.blue = 1.0f;
                evt.red = 0.6f;
                evt.green = 0.8f;
            } else if (ep.func_70055_a(Material.field_151587_i)) {
                evt.blue = 0.2f;
                evt.red = 1.0f;
                evt.green = 0.6f;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fixRespirationFourPlusFog(EntityViewRenderEvent.FogDensity evt) {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        ItemStack helm = ep.func_82169_q(3);
        if (helm != null && ReikaEnchantmentHelper.getEnchantmentLevel(Enchantment.field_77340_h, helm) > 3 && (ep.func_70055_a(Material.field_151586_h) || ep.func_70055_a(Material.field_151587_i))) {
            GL11.glFogi((int)2917, (int)2048);
            evt.density = Math.min(evt.density, ep.func_70055_a(Material.field_151587_i) ? 0.1f : 0.0025f);
            if (ep.func_70644_a(Potion.field_76440_q)) {
                evt.density = 0.9f;
            }
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void protectNewPlayers(MobTargetingEvent.Pre evt) {
        if (evt.player.field_70173_aa < 200 && DragonOptions.PROTECTNEW.getState()) {
            evt.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void stillAllowPetTargeting(MobTargetingEvent.Pre evt) {
        if (ReikaEntityHelper.tameMobTargeting) {
            evt.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void trackBrokenBlocks(BlockEvent.BreakEvent evt) {
        TileEntity te = evt.world.func_147438_o(evt.x, evt.y, evt.z);
        if (te instanceof PlayerBreakHook && !((PlayerBreakHook)te).breakByPlayer(evt.getPlayer())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void catchNullOreDict(OreDictionary.OreRegisterEvent evt) {
        if (evt.Ore == null || evt.Ore.func_77973_b() == null) {
            throw new WTFException("Someone registered null to the OreDictionary under the name '" + evt.Name + "'!", true);
        }
        if (evt.Name == null || evt.Name.isEmpty()) {
            throw new WTFException("Someone registered " + evt.Ore + " under a null or empty OreDict name!", true);
        }
        DragonAPICore.log("Logged OreDict registration of " + evt.Ore + " as '" + evt.Name + "'.");
    }

    @SubscribeEvent
    public void mapFluidContainers(FluidContainerRegistry.FluidContainerRegisterEvent evt) {
        ReikaFluidHelper.initEarlyRegistrations();
        Fluid f = evt.data.fluid.getFluid();
        ItemStack fill = evt.data.filledContainer;
        ItemStack empty = evt.data.emptyContainer;
        StringBuilder sb = new StringBuilder();
        sb.append("Logged FluidContainer registration of ");
        sb.append(f.getName());
        sb.append(" with filled '");
        sb.append(fill != null ? fill.func_82833_r() : "[null]");
        sb.append("' and empty '");
        sb.append(empty != null ? empty.func_82833_r() : "[null]");
        sb.append("'.");
        DragonAPICore.log(sb.toString());
        ReikaFluidHelper.mapContainerToFluid(f, empty, fill);
    }

    @SubscribeEvent
    public void onClose(WorldEvent.Unload evt) {
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load evt) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void increaseChannels(SoundSetupEvent evt) {
        if (DragonOptions.SOUNDCHANNELS.getState()) {
            SoundSystemConfig.setNumberNormalChannels((int)256);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGameLoaded(GameFinishedLoadingEvent evt) throws InterruptedException {
        this.checkRemoteAssetDownload();
        if (!ReikaObfuscationHelper.isDeObfEnvironment()) {
            Minecraft.func_71410_x().func_110436_a();
        }
        if (ModList.NEI.isLoaded()) {
            NEIIntercept.instance.register();
        }
        DragonAPIInit.proxy.registerSidedHandlersGameLoaded();
        ReflectiveFailureTracker.instance.print();
    }

    private void checkRemoteAssetDownload() throws InterruptedException {
        long time = 0L;
        long d = 100L;
        while (!RemoteAssetLoader.instance.isDownloadComplete()) {
            if (time % 5000L == 0L) {
                String p = String.format("%.2f", Float.valueOf(100.0f * RemoteAssetLoader.instance.getDownloadProgress()));
                String s = "Remote asset downloads not yet complete (current = " + p + "%). Pausing game load. Total delay: " + time + " ms.";
                DragonAPICore.log(s);
            }
            Thread.sleep(d);
            time += d;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void stopHotbarSwap(HotbarKeyEvent evt) {
        if (DragonOptions.NOHOTBARSWAP.getState()) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void disableAlphaTest(RenderWorldEvent.Pre evt) {
        GL11.glPushAttrib((int)1048575);
        if (DragonOptions.NOALPHATEST.getState()) {
            GL11.glAlphaFunc((int)518, (float)0.01f);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void disableAlphaTest(RenderWorldEvent.Post evt) {
        GL11.glPopAttrib();
    }

    @SubscribeEvent
    public void sendInteractToClient(PlayerInteractEvent evt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !ReikaPlayerAPI.isFake(evt.entityPlayer)) {
            ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.PLAYERINTERACT.ordinal(), (PacketTarget)new PacketTarget.PlayerTarget((EntityPlayerMP)evt.entityPlayer), evt.x, evt.y, evt.z, evt.face, evt.action.ordinal());
        }
    }

    @SubscribeEvent
    public void clearItems(ItemUpdateEvent evt) {
        if (ClearItemsCommand.clearItem(evt.entityItem)) {
            evt.entityItem.func_70106_y();
        }
    }

    @SubscribeEvent
    public void tagDroppedItems(ItemTossEvent evt) {
        if (evt.player != null) {
            String s = evt.player.func_110124_au().toString();
            evt.entityItem.getEntityData().func_74778_a("dropper", s);
        }
    }

    @SubscribeEvent
    public void tagDroppedItems(EntityJoinWorldEvent evt) {
        if (evt.entity instanceof EntityItem && evt.world.field_72995_K) {
            ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.ITEMDROPPERREQUEST.ordinal(), PacketTarget.server, evt.entity.func_145782_y());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void confirmNumericIDs(ChatEvent.ChatEventPost evt) {
        if (System.currentTimeMillis() - this.IDMsgCooldown >= 30000L && evt.chatMessage.startsWith("Warning: Using numeric IDs will not be supported in the future")) {
            String item1 = EnumChatFormatting.GOLD + "/give item.forestry.apiculture.bee.template.root3";
            String item2 = EnumChatFormatting.GOLD + "/give item.gregtech.machine.primary.transformer.hv.ruby";
            String c = EnumChatFormatting.LIGHT_PURPLE.toString();
            ReikaChatHelper.writeString(c + "Numeric IDs will remain functional as long as I am here,");
            ReikaChatHelper.writeString(c + "because not everyone wants to type");
            ReikaChatHelper.writeString(c + "'" + item1 + c + "'");
            ReikaChatHelper.writeString(c + "or");
            ReikaChatHelper.writeString(c + "'" + item2 + c + "'.");
            ReikaChatHelper.writeString(c + "-DragonAPI");
            this.IDMsgCooldown = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public void verifyCraftingRecipe(AddRecipeEvent evt) {
        if (!AddRecipeEvent.isVanillaPass) {
            try {
                if (!ReikaRecipeHelper.verifyRecipe(evt.recipe)) {
                    String msg = "Class=" + evt.recipe.getClass();
                    if (evt.recipe.func_77571_b() != null && evt.recipe.func_77571_b().func_77973_b() != null) {
                        msg = msg + ", Output=" + evt.recipe.func_77571_b();
                    } else if (evt.recipe.func_77571_b() != null) {
                        msg = msg + ", Output is a null-item ItemStack";
                    }
                    DragonAPICore.log("Invalid recipe, such as with nulled inputs, found. Removing to prevent crashes. " + msg + ".");
                    evt.setCanceled(true);
                }
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not parse crafting recipe");
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void verifySmeltingRecipe(AddSmeltingEvent evt) {
        if (!AddSmeltingEvent.isVanillaPass) {
            try {
                ItemStack in = evt.getInput();
                ItemStack out = evt.getOutput();
                if (in == null || in.func_77973_b() == null) {
                    DragonAPICore.logError("Found a null-input (or null-item input) smelting recipe! " + null + " > " + out + "! This is invalid!");
                    Thread.dumpStack();
                    evt.setCanceled(true);
                } else if (out == null || out.func_77973_b() == null) {
                    DragonAPICore.logError("Found a null-output (or null-item output) smelting recipe! " + in + " > " + null + "! This is invalid!");
                    Thread.dumpStack();
                    evt.setCanceled(true);
                } else if (!ReikaItemHelper.verifyItemStack(in, true)) {
                    DragonAPICore.logError("Found a smelting recipe with an invalid input!");
                    Thread.dumpStack();
                    evt.setCanceled(true);
                } else if (!ReikaItemHelper.verifyItemStack(out, true)) {
                    DragonAPICore.logError("Found a smelting recipe with an invalid output!");
                    Thread.dumpStack();
                    evt.setCanceled(true);
                }
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not parse smelting recipe");
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void collateXP(XPUpdateEvent evt) {
        AxisAlignedBB box;
        List li;
        if (DragonOptions.XPMERGE.getState() && !evt.xp.field_70128_L && !evt.xp.field_70170_p.field_72995_K && evt.xp.field_70531_b % 16 == 0 && (li = evt.xp.field_70170_p.func_72872_a(EntityXPOrb.class, box = ReikaAABBHelper.getEntityCenteredAABB((Entity)evt.xp, 1.0))).size() > 1) {
            EntityXPOrb xp = ReikaEntityHelper.mergeXPOrbs(evt.xp.field_70170_p, li);
        }
    }
}

