/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.IDConflictException;
import Reika.DragonAPI.Exception.StupidIDException;
import Reika.DragonAPI.Extras.IDType;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;

public final class BiomeCollisionTracker {
    private MultiMap<DragonAPIMod, Integer> IDs = new MultiMap();
    private HashMap<Integer, Class> classes = new HashMap();
    public static final BiomeCollisionTracker instance = new BiomeCollisionTracker();

    private BiomeCollisionTracker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void addEntry(DragonAPIMod mod, int id, Class biome) {
        this.IDs.addValue(mod, id);
        this.classes.put(id, biome);
    }

    public void addBiomeID(DragonAPIMod mod, int id, Class biomeClass) {
        if (id < 0 || id >= 255) {
            throw new StupidIDException(mod, id, IDType.BIOME);
        }
        BiomeGenBase biome = BiomeGenBase.field_76773_a[id];
        if (biome != null) {
            this.onConflict(null, id, biome.getClass(), biomeClass);
        } else if (this.classes.containsKey(id)) {
            this.onConflict(mod, id, this.classes.get(id), biomeClass);
        } else {
            this.addEntry(mod, id, biomeClass);
        }
    }

    public final void check() {
        for (DragonAPIMod mod : this.IDs.keySet()) {
            Collection<Integer> ids = this.IDs.get(mod);
            for (int id : ids) {
                BiomeGenBase biome = BiomeGenBase.field_76773_a[id];
                if (biome == null) {
                    DragonAPICore.logError("Biome ID " + id + " (" + this.classes.get(id) + ") was deleted post-registration!");
                    continue;
                }
                Class<?> c = biome.getClass();
                Class c1 = this.classes.get(id);
                if (c1 == c) continue;
                this.onConflict(mod, id, c, c1);
            }
        }
    }

    protected void onConflict(DragonAPIMod mod, int id, Class c, Class c1) {
        String s = "Biome IDs: " + BiomeGenBase.field_76773_a[id] + " @ ID " + id + " (" + c.getSimpleName() + " & " + c1.getSimpleName() + ")";
        if (mod == null) {
            throw new IDConflictException(s);
        }
        throw new IDConflictException(mod, s);
    }
}

