/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.EnumChatFormatting;

public final class DonatorController {
    public static final DonatorController instance = new DonatorController();
    public static final String reikaURL = "http://server.techjargaming.com/Reika/Donator/donators_";
    private final HashMap<DragonAPIMod, DonationList> data = new HashMap();
    private final MultiMap<DragonAPIMod, Donator> byModDonators = new MultiMap();
    private final HashSet<Donator> reikaDonators = new HashSet();

    private DonatorController() {
    }

    public void registerMod(DragonAPIMod mod, String root) {
        String url = root + ReikaStringParser.stripSpaces(mod.getDisplayName().toLowerCase(Locale.ENGLISH)) + ".txt";
        URL file = this.getURL(url);
        if (file == null) {
            DragonAPICore.logError("Could not create URL to donator file. Donators will not be loaded.");
            return;
        }
        ArrayList<String> lines = ReikaFileReader.getFileAsLines(file, 10000, false, null);
        if (lines != null) {
            this.addDonators(mod, lines);
        }
    }

    private void addDonators(DragonAPIMod mod, ArrayList<String> lines) {
        for (String s : lines) {
            s = ReikaStringParser.stripSpaces(s);
            String[] parts = s.split(":");
            parts[parts.length - 1] = ReikaStringParser.clipStringBefore(parts[parts.length - 1], "//");
            if (parts.length == 3) {
                this.addDonation(mod, parts[0], parts[1], Float.parseFloat(parts[2]));
                continue;
            }
            this.addDonation(mod, parts[0], Float.parseFloat(parts[1]));
        }
    }

    private URL getURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private float addDonation(DragonAPIMod mod, String donator, float donation) {
        return this.addDonation(mod, donator, null, donation);
    }

    private float addDonation(DragonAPIMod mod, String donator, String ingame, float donation) {
        boolean flag = false;
        DonationList li = this.data.get(mod);
        if (li == null) {
            li = new DonationList();
            this.data.put(mod, li);
        }
        Donator d = li.addDonation(donator, ingame != null ? UUID.fromString(ingame) : null, donation);
        this.byModDonators.addValue(mod, d);
        if (mod.isReikasMod()) {
            this.reikaDonators.add(d);
        }
        return ((Donation)li.data.get(donator)).donationAmount;
    }

    public String getTotalDonationsFromAllMods(String donator) {
        float amt = 0.0f;
        for (DragonAPIMod mod : this.data.keySet()) {
            amt += this.getNumericalTotalDonationsFrom(mod, donator);
        }
        return String.format("$%.2f", Float.valueOf(amt));
    }

    private float getNumericalTotalDonationsFrom(DragonAPIMod mod, String donator) {
        Donation d;
        DonationList li = this.data.get(mod);
        if (li != null && (d = (Donation)li.data.get(donator)) != null) {
            return d.donationAmount;
        }
        return 0.0f;
    }

    public String getTotalDonationsFrom(DragonAPIMod mod, String donator) {
        return String.format("$%.2f", Float.valueOf(this.getNumericalTotalDonationsFrom(mod, donator)));
    }

    public Collection<Donator> getAllDonatorsFor(DragonAPIMod mod) {
        return Collections.unmodifiableCollection(this.byModDonators.get(mod));
    }

    public Set<Donator> getReikasDonators() {
        return Collections.unmodifiableSet(this.reikaDonators);
    }

    public boolean donatedTo(UUID ingame, DragonAPIMod mod) {
        Collection<Donator> c = this.byModDonators.get(mod);
        for (Donator d : c) {
            if (!d.ingameName.equals(ingame)) continue;
            return true;
        }
        return false;
    }

    public String getDisplayList() {
        StringBuilder sb = new StringBuilder();
        sb.append(EnumChatFormatting.AQUA.toString());
        sb.append("Thank you to all these people whose donations made the following mods possible:");
        sb.append("\n\n");
        for (DragonAPIMod mod : this.data.keySet()) {
            DonationList li = this.data.get(mod);
            sb.append(EnumChatFormatting.BLUE.toString());
            sb.append(mod.getDisplayName());
            sb.append(":\n");
            sb.append(li.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class DonationList {
        private final HashMap<String, Donation> data = new HashMap();

        private DonationList() {
        }

        private Donator addDonation(String name, UUID ign, float amt) {
            Donator d = new Donator(name, ign);
            Donation dn = this.data.get(d);
            if (dn == null) {
                dn = new Donation(d);
                this.data.put(name, dn);
            }
            dn.donationAmount += amt;
            return d;
        }
    }

    public static class Donator {
        public final UUID ingameName;
        public final String displayName;

        Donator(String name, UUID ign) {
            this.displayName = name;
            this.ingameName = ign;
        }

        public boolean equals(Object o) {
            if (o instanceof Donator) {
                Donator d = (Donator)o;
                if (d.ingameName == null || this.ingameName == null) {
                    return false;
                }
                return d.ingameName.equals(this.ingameName) && d.displayName.equals(this.displayName);
            }
            return false;
        }

        public int hashCode() {
            return (this.ingameName != null ? this.ingameName.hashCode() : 0) ^ this.displayName.hashCode();
        }

        public String toString() {
            return this.displayName + " (" + this.ingameName + ")";
        }
    }

    private static class Donation
    implements Comparable<Donation> {
        private final Donator donator;
        private float donationAmount;

        public Donation(Donator d) {
            this(d, 0.0f);
        }

        public Donation(Donator d, float amt) {
            this.donator = d;
            this.donationAmount = amt;
        }

        public String toString() {
            return String.format("  %s%s%s: %s%.2f", this.getDisplayColor().toString(), this.getFormatting(), this.donator.toString(), "$", Float.valueOf(this.donationAmount));
        }

        public String getFormatting() {
            return "";
        }

        public boolean equals(Object o) {
            if (o instanceof Donation) {
                Donation d = (Donation)o;
                return d.donationAmount == this.donationAmount && d.donator.equals(this.donator);
            }
            return false;
        }

        public int hashCode() {
            return this.donator.hashCode() + (int)(this.donationAmount * 100.0f);
        }

        public EnumChatFormatting getDisplayColor() {
            if (this.donationAmount >= 100.0f) {
                return EnumChatFormatting.GOLD;
            }
            if (this.donationAmount >= 50.0f) {
                return EnumChatFormatting.LIGHT_PURPLE;
            }
            if (this.donationAmount >= 20.0f) {
                return EnumChatFormatting.GREEN;
            }
            return EnumChatFormatting.WHITE;
        }

        @Override
        public int compareTo(Donation o) {
            return (int)Math.signum(o.donationAmount - this.donationAmount);
        }
    }
}

