/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.IDConflictException;
import Reika.DragonAPI.Exception.StupidIDException;
import Reika.DragonAPI.Extras.IDType;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;

public final class EnchantmentCollisionTracker {
    private MultiMap<DragonAPIMod, Integer> IDs = new MultiMap();
    private ArrayList<DragonAPIMod> mods = new ArrayList();
    private HashMap<Integer, Class> classes = new HashMap();
    public static final EnchantmentCollisionTracker instance = new EnchantmentCollisionTracker();

    private EnchantmentCollisionTracker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void addEntry(DragonAPIMod mod, int id, Class Enchantment2) {
        this.IDs.addValue(mod, id);
        this.classes.put(id, Enchantment2);
    }

    public void addEnchantmentID(DragonAPIMod mod, int id, Class EnchantmentClass) {
        if (id < 0 || id >= Enchantment.field_77331_b.length) {
            throw new StupidIDException(mod, id, IDType.ENCHANTMENT);
        }
        Enchantment e = Enchantment.field_77331_b[id];
        if (e != null) {
            this.onConflict(null, id, e.getClass(), EnchantmentClass);
        }
        if (this.classes.containsKey(id)) {
            this.onConflict(mod, id, this.classes.get(id), EnchantmentClass);
        } else {
            this.addEntry(mod, id, EnchantmentClass);
        }
    }

    public final void check() {
        for (DragonAPIMod mod : this.IDs.keySet()) {
            Collection<Integer> ids = this.IDs.get(mod);
            for (int id : ids) {
                Enchantment e = Enchantment.field_77331_b[id];
                if (e == null) {
                    DragonAPICore.logError("Enchantment ID " + id + " (" + this.classes.get(id) + ") was deleted post-registration!");
                    continue;
                }
                Class<?> c = e.getClass();
                Class c1 = this.classes.get(id);
                if (c1 == c) continue;
                this.onConflict(mod, id, c, c1);
            }
        }
    }

    protected void onConflict(DragonAPIMod mod, int id, Class c, Class c1) {
        String s = "Enchantment IDs: " + Enchantment.field_77331_b[id] + " @ " + id + " (" + c.getSimpleName() + " & " + c1.getSimpleName() + ")";
        if (mod == null) {
            throw new IDConflictException(s);
        }
        throw new IDConflictException(mod, s);
    }
}

