/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Instantiable.Event.Client.GameFinishedLoadingEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraftforge.common.MinecraftForge;

public class TickRegistry {
    public static final TickRegistry instance = new TickRegistry();
    private ArrayList<TickHandler> playerTickers = new ArrayList();
    private ArrayList<TickHandler> worldTickers = new ArrayList();
    private ArrayList<TickHandler> renderTickers = new ArrayList();
    private ArrayList<TickHandler> clientTickers = new ArrayList();
    private ArrayList<TickHandler> serverTickers = new ArrayList();
    private static boolean posted = false;

    private TickRegistry() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent evt) {
        for (TickHandler h : this.playerTickers) {
            if (!h.canFire(evt.phase)) continue;
            h.tick(TickType.PLAYER, evt.player, evt.phase);
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent evt) {
        for (TickHandler h : this.renderTickers) {
            if (!h.canFire(evt.phase)) continue;
            h.tick(TickType.RENDER, Float.valueOf(evt.renderTickTime), evt.phase);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        for (TickHandler h : this.clientTickers) {
            if (!h.canFire(evt.phase)) continue;
            h.tick(TickType.CLIENT, evt.phase);
        }
        if (!posted) {
            MinecraftForge.EVENT_BUS.post((Event)new GameFinishedLoadingEvent());
            posted = true;
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent evt) {
        for (TickHandler h : this.worldTickers) {
            if (!h.canFire(evt.phase)) continue;
            h.tick(TickType.WORLD, evt.world, evt.phase);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent evt) {
        for (TickHandler h : this.serverTickers) {
            if (!h.canFire(evt.phase)) continue;
            h.tick(TickType.SERVER, evt.phase);
        }
    }

    public void registerTickHandler(TickHandler h) {
        for (TickType type : h.getType()) {
            switch (type) {
                case CLIENT: {
                    this.clientTickers.add(h);
                    break;
                }
                case PLAYER: {
                    this.playerTickers.add(h);
                    break;
                }
                case RENDER: {
                    this.renderTickers.add(h);
                    break;
                }
                case SERVER: {
                    this.serverTickers.add(h);
                    break;
                }
                case WORLD: {
                    this.worldTickers.add(h);
                }
            }
        }
    }

    public static enum TickType {
        WORLD,
        RENDER,
        CLIENT,
        PLAYER,
        SERVER;

    }

    public static interface TickHandler {
        public void tick(TickType var1, Object ... var2);

        public EnumSet<TickType> getType();

        public boolean canFire(TickEvent.Phase var1);

        public String getLabel();
    }
}

