/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Exception;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.DragonAPIException;
import Reika.DragonAPI.Extras.IDType;
import net.minecraft.potion.Potion;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Property;

public class StupidIDException
extends DragonAPIException {
    public StupidIDException(DragonAPIMod mod, Property id, Property.Type req) {
        this.message.append(mod.getDisplayName() + " was not installed correctly:\n");
        this.message.append("ID '" + id.getString() + "' is completely invalid, as it is the wrong type (" + id.getType() + " when it should be " + req + ").\n");
        this.message.append("Please learn how IDs work before attempting to modify configs.\n");
        if (req == Property.Type.INTEGER) {
            this.message.append("IDs must be integers.\n");
        }
        this.message.append("This is NOT a mod bug. Do not post it or ask for support or you will look extremely foolish.");
        this.crash();
    }

    public StupidIDException(DragonAPIMod mod, int ID, IDType type) {
        this.message.append(mod.getDisplayName() + " was not installed correctly:\n");
        this.message.append(type.getName() + " ID " + ID + " is completely invalid, as it is " + this.getError(ID, type) + ".\n");
        this.message.append("Please learn how IDs work before attempting to modify configs.\n");
        if (ID > 100000) {
            this.message.append("No sane ID would be this large, and you would do well to realize this.\n");
        }
        this.message.append("This is NOT a mod bug. Do not post it or ask for support or you will look extremely foolish.");
        if (ID <= 0) {
            this.message.append("\nIf you picked " + ID + " in an attempt to disable the feature, this is not how, and disabling may not be possible.");
        }
        this.crash();
    }

    private String getError(int id, IDType type) {
        int max = this.getMaxAllowable(type);
        return id < 0 ? "negative" : (id > max ? "too large" : "wrong");
    }

    private int getMaxAllowable(IDType type) {
        switch (type) {
            case BIOME: {
                return BiomeGenBase.field_76773_a.length - 1 - 1;
            }
            case BLOCK: {
                return 4095;
            }
            case ITEM: {
                return Short.MAX_VALUE;
            }
            case POTION: {
                return Potion.field_76425_a.length - 1;
            }
        }
        return -1;
    }
}

