/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.IO.XMLInterface;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;

public class GuiGuide
extends GuiScreen {
    private static final ArrayList<ModList> mods = new ArrayList();
    private static final String PARENT = "Resources/";
    private static final XMLInterface guide = new XMLInterface(DragonAPICore.class, "Resources/guide.xml", !ReikaObfuscationHelper.isDeObfEnvironment());
    private static HashMap<String, String> data = new HashMap();
    private static final String[] tabLabels = new String[]{"Info", "Getting Started", "Useful Notes", "Tips and Tricks"};
    private static final String[] tabTags = new String[]{"info", "tutorial", "notes", "tips"};
    private int screen;
    private int page;
    protected final int xSize = 256;
    protected final int ySize = 220;

    public GuiGuide() {
        guide.reread();
        this.loadData();
    }

    private static void loadData() {
        for (int i = 0; i < mods.size(); ++i) {
            ModList mod = mods.get(i);
            for (int j = 0; j < tabTags.length; ++j) {
                String tag = "dragonapi:" + mod.name().toLowerCase(Locale.ENGLISH) + ":" + tabTags[j];
                String desc = guide.getValueAtNode(tag);
                data.put(tag, desc);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int j = (this.field_146294_l - 256) / 2;
        int k = (this.field_146295_m - 220) / 2 - 8;
        String file = "/Reika/DragonAPI/Resources/guidetab.png";
        this.field_146292_n.add(new GuiButton(10, j - 19, 17 + k + 163, 20, 20, "-"));
        this.field_146292_n.add(new GuiButton(11, j - 19, 17 + k + 143, 20, 20, "+"));
        this.field_146292_n.add(new GuiButton(15, j - 19, 17 + k + 183, 20, 20, "<<"));
        this.field_146292_n.add(new GuiButton(12, j + 256 - 27, k + 6, 20, 20, "X"));
        if (this.screen > 0) {
            for (int i = 0; i < tabLabels.length; ++i) {
                String s = tabLabels[i];
                this.field_146292_n.add(new GuiButton(i, j - 19 - 65 + 1, k + 20 * i, 85, 20, s));
            }
        }
    }

    public boolean func_73868_f() {
        return true;
    }

    private void drawModLogo(ModList mod) {
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 12) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        if (button.field_146127_k == 15) {
            this.screen = 0;
            this.page = 0;
            this.func_73866_w_();
            return;
        }
        if (button.field_146127_k == 10) {
            if (this.screen > 0) {
                --this.screen;
                this.page = 0;
            }
            this.func_73866_w_();
            return;
        }
        if (button.field_146127_k == 11) {
            if (this.screen < this.getMaxPage()) {
                ++this.screen;
                this.page = 0;
            } else {
                this.screen = 0;
                this.page = 0;
            }
            this.func_73866_w_();
            return;
        }
        this.page = button.field_146127_k;
        this.func_73866_w_();
    }

    private int getMaxPage() {
        return mods.size();
    }

    private void drawTabIcons() {
        int posX = (this.field_146294_l - 256) / 2;
        int posY = (this.field_146295_m - 220) / 2;
    }

    private void drawGraphics() {
        int posX = (this.field_146294_l - 256) / 2 - 2;
        int posY = (this.field_146295_m - 220) / 2 - 8;
        String s = "";
        s = this.screen >= 1 ? mods.get(this.screen - 1).getDisplayName() : "Reika's Mods";
        this.field_146289_q.func_78276_b(String.format("%s", s), posX + 10, posY + 8, 0);
        if (this.screen >= 1) {
            int w = this.field_146289_q.func_78256_a(s + " ");
            if (mods.get(this.screen - 1).isLoaded()) {
                this.field_146289_q.func_78276_b("(Installed)", posX + 10 + w, posY + 8, 30464);
            } else {
                this.field_146289_q.func_78276_b("(Not Installed)", posX + 10 + w, posY + 8, 0x770000);
            }
        }
    }

    public void func_73863_a(int x, int y, float f) {
        String var4 = "/Reika/DragonAPI/Resources/guidebcg.png";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(DragonAPICore.class, var4);
        int posX = (this.field_146294_l - 256) / 2;
        int posY = (this.field_146295_m - 220) / 2 - 8;
        this.func_73729_b(posX, posY, 0, 0, 256, 220);
        boolean xo = false;
        boolean yo = false;
        String s = "This book contains basic information about each of Reika's mods.";
        if (this.screen > 0) {
            String tag = "dragonapi:" + mods.get(this.screen - 1).name().toLowerCase(Locale.ENGLISH) + ":" + tabTags[this.page];
            s = data.get(tag);
        }
        this.field_146289_q.func_78279_b(String.format("%s", s), posX + 9, posY + 88, 241, 0xFFFFFF);
        this.drawGraphics();
        super.func_73863_a(x, y, f);
        this.drawTabIcons();
    }

    static {
        GuiGuide.loadData();
        List<ModList> reika = ModList.getReikasMods();
        for (int i = 0; i < reika.size(); ++i) {
            mods.add(reika.get(i));
        }
    }
}

