/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FastBlockCache {
    private final HashSet<Coordinate> data = new HashSet();

    public Collection<Coordinate> getBlocks() {
        return Collections.unmodifiableSet(this.data);
    }

    public boolean removeBlock(Coordinate c) {
        return c != null && this.data.remove(c);
    }

    public boolean removeBlock(int x, int y, int z) {
        return this.removeBlock(new Coordinate(x, y, z));
    }

    public boolean addBlock(Coordinate c) {
        return c != null && this.data.add(c);
    }

    public boolean addBlock(int x, int y, int z) {
        return this.addBlock(new Coordinate(x, y, z));
    }

    public boolean containsBlock(Coordinate c) {
        return c != null && this.data.contains(c);
    }

    public boolean containsBlock(int x, int y, int z) {
        return this.containsBlock(new Coordinate(x, y, z));
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList li = new NBTTagList();
        for (Coordinate c : this.data) {
            NBTTagCompound dat = c.writeToTag();
            li.func_74742_a((NBTBase)dat);
        }
        tag.func_74782_a("data", (NBTBase)li);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.data.clear();
        NBTTagList li = tag.func_150295_c("data", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound dat = (NBTTagCompound)o;
            Coordinate c = Coordinate.readTag(dat);
            if (c == null) continue;
            this.data.add(c);
        }
    }
}

