/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.ImmutableItemStack;
import Reika.DragonAPI.Interfaces.Matcher;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class ItemHashMap<V> {
    private final HashMap<ItemKey, V> data = new HashMap();
    private ArrayList<ItemStack> sorted = null;
    private Collection<ItemStack> keyset = null;
    private boolean modifiedKeys = true;
    private Matcher<V> matcher = null;
    private boolean oneWay = false;

    public ItemHashMap<V> setOneWay() {
        return this.setOneWay(null);
    }

    public ItemHashMap<V> setOneWay(Matcher m) {
        this.oneWay = true;
        this.matcher = m;
        return this;
    }

    private void updateKeysets() {
        this.modifiedKeys = false;
        this.keyset = this.createKeySet();
        this.sorted = new ArrayList<ItemStack>(this.keySet());
        ReikaItemHelper.sortItems(this.sorted);
    }

    private V put(ItemKey is, V value) {
        if (this.oneWay && this.data.containsKey(is)) {
            V v;
            if (this.matcher != null && ((v = this.data.get(is)) == value || this.matcher.match(v, value))) {
                return v;
            }
            throw new UnsupportedOperationException("This map does not support overwriting values! Item " + is + " already mapped to '" + this.data.get(is) + "'!");
        }
        V ret = this.data.put(is, value);
        this.modifiedKeys = true;
        return ret;
    }

    private V get(ItemKey is) {
        return this.data.get(is);
    }

    private boolean containsKey(ItemKey is) {
        return this.data.containsKey(is);
    }

    public V put(ItemStack is, V value) {
        return this.put(new ItemKey(is), value);
    }

    public V get(ItemStack is) {
        return this.get(new ItemKey(is));
    }

    public V get(ImmutableItemStack is) {
        return this.get(is.getItemStack());
    }

    public boolean containsKey(ItemStack is) {
        return this.containsKey(new ItemKey(is));
    }

    public V put(Block i, V value) {
        return this.put(new ItemStack(i), value);
    }

    public V put(Item i, V value) {
        return this.put(new ItemStack(i), value);
    }

    public V put(Item i, int meta, V value) {
        return this.put(new ItemStack(i, 1, meta), value);
    }

    public V put(ImmutableItemStack is, V obj) {
        return this.put(is.getItemStack(), obj);
    }

    public V get(Item i, int meta) {
        return this.get(new ItemStack(i, meta));
    }

    public boolean containsKey(Item i, int meta) {
        return this.containsKey(new ItemStack(i, meta));
    }

    public V put(Block b, int meta, V value) {
        return this.put(new ItemStack(b, meta), value);
    }

    public V get(Block b, int meta) {
        return this.get(new ItemStack(b, meta));
    }

    public boolean containsKey(Block b, int meta) {
        return this.containsKey(new ItemStack(b, meta));
    }

    public int size() {
        return this.data.size();
    }

    public Collection<ItemStack> keySet() {
        if (this.modifiedKeys || this.keyset == null) {
            this.updateKeysets();
        }
        return Collections.unmodifiableCollection(this.keyset);
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    private Collection<ItemStack> createKeySet() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemKey key : this.data.keySet()) {
            li.add(key.asItemStack());
        }
        return li;
    }

    public String toString() {
        return this.data.toString();
    }

    public V remove(ItemStack is) {
        return this.remove(new ItemKey(is));
    }

    private V remove(ItemKey is) {
        if (this.oneWay) {
            throw new UnsupportedOperationException("This map does not support removing values!");
        }
        V ret = this.data.remove(is);
        this.modifiedKeys = true;
        return ret;
    }

    public boolean removeValue(V value) {
        return ReikaJavaLibrary.removeValuesFromMap(this.data, value);
    }

    public void clear() {
        if (this.oneWay) {
            throw new UnsupportedOperationException("This map does not support removing values!");
        }
        this.data.clear();
        this.modifiedKeys = true;
    }

    public List<ItemStack> sortedKeyset() {
        if (this.modifiedKeys || this.sorted == null) {
            this.updateKeysets();
        }
        return Collections.unmodifiableList(this.sorted);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public static ItemHashMap<Integer> getFromInventory(IInventory ii) {
        ItemHashMap<Integer> map = new ItemHashMap<Integer>();
        int s = ii.func_70302_i_();
        for (int i = 0; i < s; ++i) {
            ItemStack in = ii.func_70301_a(i);
            if (in == null) continue;
            Integer has = map.get(in);
            int amt = has != null ? has : 0;
            map.put(in, (Integer)(amt + 1));
        }
        return map;
    }

    public ItemHashMap<V> clone() {
        ItemHashMap<V> map = new ItemHashMap<V>();
        for (ItemKey is : this.data.keySet()) {
            map.data.put(is, this.data.get(is));
        }
        return map;
    }

    public void putAll(ItemHashMap<V> map) {
        this.data.putAll(map.data);
    }

    private static final class ItemKey
    implements Comparable<ItemKey> {
        public final Item itemID;
        private final int metadata;

        private ItemKey(ItemStack is) {
            if (is == null) {
                throw new MisuseException("You cannot add a null itemstack to the map!");
            }
            if (is.func_77973_b() == null) {
                throw new MisuseException("You cannot add a null-item itemstack to the map!");
            }
            this.itemID = is.func_77973_b();
            this.metadata = is.func_77960_j();
        }

        public int hashCode() {
            return this.itemID.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ItemKey) {
                ItemKey i = (ItemKey)o;
                return i.itemID == this.itemID && (!this.hasMetadata() || !i.hasMetadata() || i.metadata == this.metadata);
            }
            return false;
        }

        public String toString() {
            return this.itemID.func_77658_a() + ":" + this.metadata;
        }

        public boolean hasMetadata() {
            return this.metadata >= 0 && this.metadata != Short.MAX_VALUE;
        }

        public ItemStack asItemStack() {
            return new ItemStack(this.itemID, 1, this.metadata);
        }

        @Override
        public int compareTo(ItemKey o) {
            return Item.func_150891_b((Item)this.itemID) - Item.func_150891_b((Item)o.itemID);
        }
    }
}

