/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.world.World;

public final class LocationCache<V> {
    private final HashMap<WorldLocation, V> data = new HashMap();

    public V put(World world, int x, int y, int z, V tile) {
        return this.put(new WorldLocation(world, x, y, z), tile);
    }

    public V put(WorldLocation loc, V tile) {
        return this.data.put(loc, tile);
    }

    public V get(World world, int x, int y, int z) {
        return this.get(new WorldLocation(world, x, y, z));
    }

    public V get(WorldLocation c) {
        return this.data.get(c);
    }

    public boolean containsKey(World world, int x, int y, int z) {
        return this.containsKey(new WorldLocation(world, x, y, z));
    }

    public boolean containsKey(WorldLocation c) {
        return this.data.containsKey(c);
    }

    public V remove(World world, int x, int y, int z) {
        return this.remove(new WorldLocation(world, x, y, z));
    }

    public V remove(WorldLocation c) {
        return this.data.remove(c);
    }

    public Set<WorldLocation> keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public void clear() {
        this.data.clear();
    }

    public void removeWorld(World world) {
        Iterator<WorldLocation> it = this.data.keySet().iterator();
        while (it.hasNext()) {
            WorldLocation loc = it.next();
            if (loc.dimensionID != world.field_73011_w.field_76574_g) continue;
            it.remove();
        }
    }

    public int size() {
        return this.data.size();
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String toString() {
        return this.data.toString();
    }
}

