/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TimerMap<V> {
    private final Map<V, Integer> timer;

    public TimerMap() {
        this(new HashMap());
    }

    public TimerMap(Map<V, Integer> map) {
        this.timer = map;
    }

    public void put(V val, int time) {
        this.timer.put((Integer)val, time);
    }

    public void putAll(Map<V, Integer> map) {
        this.timer.putAll(map);
    }

    public void clear() {
        this.timer.clear();
    }

    public void tick() {
        this.tick(1);
    }

    public void tick(int amt) {
        if (!this.timer.isEmpty()) {
            Iterator<Map.Entry<V, Integer>> it = this.timer.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Integer> e = it.next();
                if (e.getValue() > amt) {
                    e.setValue(e.getValue() - amt);
                    continue;
                }
                if (e.getKey() instanceof TimerCallback) {
                    ((TimerCallback)e.getKey()).call();
                }
                it.remove();
            }
        }
    }

    public boolean containsKey(V val) {
        return this.timer.containsKey(val);
    }

    public boolean isEmpty() {
        return this.timer.isEmpty();
    }

    public Collection<V> keySet() {
        return Collections.unmodifiableCollection(this.timer.keySet());
    }

    public int get(V val) {
        return this.timer.get(val);
    }

    public final String toString() {
        return this.timer.toString();
    }

    public final int size() {
        return this.timer.size();
    }

    public Map<V, Integer> toMap() {
        return Collections.unmodifiableMap(this.timer);
    }

    public static interface TimerCallback {
        public void call();
    }
}

