/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class Proportionality<F> {
    private static final Random rand = new Random();
    private final HashMap<F, Double> data = new HashMap();
    private double totalValue = 0.0;
    private static ArrayList<Integer> defaultColors = new ArrayList();

    public void addValue(F o, double amt) {
        Double get = this.data.get(o);
        double val = get != null ? get : 0.0;
        this.data.put(o, val + amt);
        this.totalValue += amt;
    }

    public void removeValue(F o, double amt) {
        Double get = this.data.get(o);
        double val = get != null ? get : 0.0;
        double res = val - amt;
        this.totalValue -= Math.min(amt, val);
        if (res > 0.0) {
            this.data.put(o, res);
        } else {
            this.data.remove(o);
        }
    }

    public double getValue(F o) {
        Double get = this.data.get(o);
        return get != null ? get : 0.0;
    }

    public double getFraction(F o) {
        return this.getValue(o) / this.totalValue;
    }

    public Collection<F> getElements() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public boolean hasMajority(F o) {
        return this.getFraction(o) >= 0.5;
    }

    public F getLargestCategory() {
        double max = -1.0;
        F big = null;
        for (F o : this.data.keySet()) {
            double has = this.getValue(o);
            if (!(has > max)) continue;
            has = max;
            big = o;
        }
        return big;
    }

    public void clear() {
        this.data.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderAsPie(double x, double y, double r, double zeroAng) {
        this.renderAsPie(x, y, r, zeroAng, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderAsPie(double x, double y, double r, double zeroAng, Map<F, Integer> colorMap) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        double ang = zeroAng;
        Tessellator v5 = Tessellator.field_78398_a;
        int i = 0;
        for (F o : this.data.keySet()) {
            double angw = 360.0 * this.getFraction(o);
            v5.func_78371_b(6);
            int c = 0;
            if (colorMap != null && colorMap.containsKey(o)) {
                c = colorMap.get(o);
            } else {
                if (i >= defaultColors.size()) {
                    int newcolor = ReikaColorAPI.RGBtoHex(rand.nextInt(255), rand.nextInt(255), rand.nextInt(255));
                    defaultColors.add(newcolor);
                    c = newcolor;
                } else {
                    c = defaultColors.get(i);
                }
                ++i;
            }
            v5.func_78378_d(c);
            v5.func_78377_a(x, y, 0.0);
            for (double d = ang; d <= ang + angw; d += 0.25) {
                double dx = x + r * Math.cos(Math.toRadians(d));
                double dy = y + r * Math.sin(Math.toRadians(d));
                v5.func_78377_a(dx, dy, 0.0);
            }
            double dx = x + r * Math.cos(Math.toRadians(ang + angw));
            double dy = y + r * Math.sin(Math.toRadians(ang + angw));
            v5.func_78377_a(dx, dy, 0.0);
            v5.func_78381_a();
            ang += angw;
        }
        GL11.glPopAttrib();
    }

    static {
        defaultColors.add(0xFF0000);
        defaultColors.add(65280);
        defaultColors.add(255);
        defaultColors.add(0xFFFF00);
        defaultColors.add(0xFF00FF);
        defaultColors.add(65535);
        defaultColors.add(0xA0A0A0);
    }
}

