/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Effects;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TruncatedCube {
    public double mainSize;
    public double cutSize;
    private List<DecimalPosition>[] faces;
    private List<ArrayList<DecimalPosition>> corners;

    public TruncatedCube(double s, double s2) {
        this.mainSize = s2;
        this.cutSize = s;
    }

    public TruncatedCube cache(boolean startCenter, double x0, double y0, double z0) {
        this.faces = new List[6];
        for (int i = 0; i < 6; ++i) {
            this.faces[i] = Collections.unmodifiableList(this.getFaceVertices(ForgeDirection.VALID_DIRECTIONS[i], startCenter, x0, y0, z0));
        }
        this.corners = Collections.unmodifiableList(this.getCornerVertices(x0, y0, z0));
        return this;
    }

    public List<DecimalPosition> getFaceVertices(ForgeDirection face, boolean startCenter, double x0, double y0, double z0) {
        if (this.faces != null) {
            return this.faces[face.ordinal()];
        }
        ArrayList<DecimalPosition> li = new ArrayList<DecimalPosition>();
        switch (face) {
            case DOWN: {
                if (startCenter) {
                    li.add(new DecimalPosition(x0, y0 - this.mainSize, z0));
                }
                li.add(new DecimalPosition(x0 - this.cutSize, y0 - this.mainSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 + this.cutSize, y0 - this.mainSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 - this.mainSize, z0 - this.cutSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 - this.mainSize, z0 + this.cutSize));
                li.add(new DecimalPosition(x0 + this.cutSize, y0 - this.mainSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 - this.cutSize, y0 - this.mainSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.mainSize, z0 + this.cutSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.mainSize, z0 - this.cutSize));
                li.add(new DecimalPosition(x0 - this.cutSize, y0 - this.mainSize, z0 - this.mainSize));
                break;
            }
            case UP: {
                if (startCenter) {
                    li.add(new DecimalPosition(x0, y0 + this.mainSize, z0));
                }
                li.add(new DecimalPosition(x0 - this.cutSize, y0 + this.mainSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 + this.mainSize, z0 - this.cutSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 + this.mainSize, z0 + this.cutSize));
                li.add(new DecimalPosition(x0 - this.cutSize, y0 + this.mainSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 + this.cutSize, y0 + this.mainSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 + this.mainSize, z0 + this.cutSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 + this.mainSize, z0 - this.cutSize));
                li.add(new DecimalPosition(x0 + this.cutSize, y0 + this.mainSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 - this.cutSize, y0 + this.mainSize, z0 - this.mainSize));
                break;
            }
            case WEST: {
                if (startCenter) {
                    li.add(new DecimalPosition(x0 - this.mainSize, y0, z0));
                }
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.cutSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.mainSize, z0 - this.cutSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.mainSize, z0 + this.cutSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.cutSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 + this.cutSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 + this.mainSize, z0 + this.cutSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 + this.mainSize, z0 - this.cutSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 + this.cutSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.cutSize, z0 - this.mainSize));
                break;
            }
            case EAST: {
                if (startCenter) {
                    li.add(new DecimalPosition(x0 + this.mainSize, y0, z0));
                }
                li.add(new DecimalPosition(x0 + this.mainSize, y0 - this.cutSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 + this.cutSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 + this.mainSize, z0 - this.cutSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 + this.mainSize, z0 + this.cutSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 + this.cutSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 - this.cutSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 - this.mainSize, z0 + this.cutSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 - this.mainSize, z0 - this.cutSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 - this.cutSize, z0 - this.mainSize));
                break;
            }
            case SOUTH: {
                if (startCenter) {
                    li.add(new DecimalPosition(x0, y0, z0 + this.mainSize));
                }
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.cutSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 - this.cutSize, y0 - this.mainSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 + this.cutSize, y0 - this.mainSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 - this.cutSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 + this.cutSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 + this.cutSize, y0 + this.mainSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 - this.cutSize, y0 + this.mainSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 + this.cutSize, z0 + this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.cutSize, z0 + this.mainSize));
                break;
            }
            case NORTH: {
                if (startCenter) {
                    li.add(new DecimalPosition(x0, y0, z0 - this.mainSize));
                }
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.cutSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 + this.cutSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 - this.cutSize, y0 + this.mainSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 + this.cutSize, y0 + this.mainSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 + this.cutSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 + this.mainSize, y0 - this.cutSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 + this.cutSize, y0 - this.mainSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 - this.cutSize, y0 - this.mainSize, z0 - this.mainSize));
                li.add(new DecimalPosition(x0 - this.mainSize, y0 - this.cutSize, z0 - this.mainSize));
                break;
            }
        }
        return li;
    }

    public List<ArrayList<DecimalPosition>> getCornerVertices(double x0, double y0, double z0) {
        if (this.corners != null) {
            return this.corners;
        }
        ArrayList<ArrayList<DecimalPosition>> li = new ArrayList<ArrayList<DecimalPosition>>();
        ArrayList<DecimalPosition> li2 = new ArrayList<DecimalPosition>();
        li2.add(new DecimalPosition(x0 + this.mainSize, y0 + this.mainSize, z0 - this.cutSize));
        li2.add(new DecimalPosition(x0 + this.mainSize, y0 + this.cutSize, z0 - this.mainSize));
        li2.add(new DecimalPosition(x0 + this.cutSize, y0 + this.mainSize, z0 - this.mainSize));
        li.add(li2);
        li2 = new ArrayList();
        li2.add(new DecimalPosition(x0 - this.cutSize, y0 + this.mainSize, z0 - this.mainSize));
        li2.add(new DecimalPosition(x0 - this.mainSize, y0 + this.cutSize, z0 - this.mainSize));
        li2.add(new DecimalPosition(x0 - this.mainSize, y0 + this.mainSize, z0 - this.cutSize));
        li.add(li2);
        li2 = new ArrayList();
        li2.add(new DecimalPosition(x0 + this.cutSize, y0 + this.mainSize, z0 + this.mainSize));
        li2.add(new DecimalPosition(x0 + this.mainSize, y0 + this.cutSize, z0 + this.mainSize));
        li2.add(new DecimalPosition(x0 + this.mainSize, y0 + this.mainSize, z0 + this.cutSize));
        li.add(li2);
        li2 = new ArrayList();
        li2.add(new DecimalPosition(x0 - this.mainSize, y0 + this.mainSize, z0 + this.cutSize));
        li2.add(new DecimalPosition(x0 - this.mainSize, y0 + this.cutSize, z0 + this.mainSize));
        li2.add(new DecimalPosition(x0 - this.cutSize, y0 + this.mainSize, z0 + this.mainSize));
        li.add(li2);
        li2 = new ArrayList();
        li2.add(new DecimalPosition(x0 + this.cutSize, y0 - this.mainSize, z0 - this.mainSize));
        li2.add(new DecimalPosition(x0 + this.mainSize, y0 - this.cutSize, z0 - this.mainSize));
        li2.add(new DecimalPosition(x0 + this.mainSize, y0 - this.mainSize, z0 - this.cutSize));
        li.add(li2);
        li2 = new ArrayList();
        li2.add(new DecimalPosition(x0 - this.mainSize, y0 - this.mainSize, z0 - this.cutSize));
        li2.add(new DecimalPosition(x0 - this.mainSize, y0 - this.cutSize, z0 - this.mainSize));
        li2.add(new DecimalPosition(x0 - this.cutSize, y0 - this.mainSize, z0 - this.mainSize));
        li.add(li2);
        li2 = new ArrayList();
        li2.add(new DecimalPosition(x0 + this.mainSize, y0 - this.mainSize, z0 + this.cutSize));
        li2.add(new DecimalPosition(x0 + this.mainSize, y0 - this.cutSize, z0 + this.mainSize));
        li2.add(new DecimalPosition(x0 + this.cutSize, y0 - this.mainSize, z0 + this.mainSize));
        li.add(li2);
        li2 = new ArrayList();
        li2.add(new DecimalPosition(x0 - this.cutSize, y0 - this.mainSize, z0 + this.mainSize));
        li2.add(new DecimalPosition(x0 - this.mainSize, y0 - this.cutSize, z0 + this.mainSize));
        li2.add(new DecimalPosition(x0 - this.mainSize, y0 - this.mainSize, z0 + this.cutSize));
        li.add(li2);
        return li;
    }

    public void render(double x, double y, double z, int c1, int c2, boolean edge, float pdist) {
        int a1 = ReikaColorAPI.getAlpha(c1);
        int a2 = ReikaColorAPI.getAlpha(c2);
        Tessellator v5 = Tessellator.field_78398_a;
        float p = GL11.glGetFloat((int)2849);
        if (edge) {
            float w = Math.max(0.125f, 2.0f - 0.0625f * pdist);
            GL11.glLineWidth((float)w);
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection forgeDirection = ForgeDirection.VALID_DIRECTIONS[i];
            List<DecimalPosition> li = this.getFaceVertices(forgeDirection, true, x, y, z);
            v5.func_78371_b(6);
            v5.func_78384_a(c1 & 0xFFFFFF, a1);
            v5.func_78380_c(240);
            for (DecimalPosition d : li) {
                v5.func_78377_a(d.xCoord, d.yCoord, d.zCoord);
            }
            v5.func_78381_a();
            if (!edge) continue;
            li = this.getFaceVertices(forgeDirection, false, x, y, z);
            v5.func_78371_b(2);
            v5.func_78384_a(c2 & 0xFFFFFF, a2);
            v5.func_78380_c(240);
            for (DecimalPosition d : li) {
                v5.func_78377_a(d.xCoord, d.yCoord, d.zCoord);
            }
            v5.func_78381_a();
        }
        for (List list : this.getCornerVertices(x, y, z)) {
            v5.func_78371_b(4);
            v5.func_78384_a(c1 & 0xFFFFFF, a1);
            v5.func_78380_c(240);
            for (DecimalPosition d : list) {
                v5.func_78377_a(d.xCoord, d.yCoord, d.zCoord);
            }
            v5.func_78381_a();
            if (!edge) continue;
            v5.func_78371_b(2);
            v5.func_78384_a(c2 & 0xFFFFFF, a2);
            v5.func_78380_c(240);
            for (DecimalPosition d : list) {
                v5.func_78377_a(d.xCoord, d.yCoord, d.zCoord);
            }
            v5.func_78381_a();
        }
        if (edge) {
            GL11.glLineWidth((float)p);
        }
    }
}

