/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Event.HasResult
public class GrassSustainCropEvent
extends Event {
    public final World world;
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    public final ForgeDirection side;
    public final IPlantable crop;

    public GrassSustainCropEvent(World world, int x, int y, int z, ForgeDirection dir, IPlantable p) {
        this.world = world;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.side = dir;
        this.crop = p;
    }

    public static boolean fireSustain(IBlockAccess world, int x, int y, int z, ForgeDirection dir, IPlantable p, boolean original) {
        if (!(world instanceof World)) {
            return original;
        }
        GrassSustainCropEvent e = new GrassSustainCropEvent((World)world, x, y, z, dir, p);
        MinecraftForge.EVENT_BUS.post((Event)e);
        switch (e.getResult()) {
            case ALLOW: {
                return Blocks.field_150458_ak.canSustainPlant(world, x, y, z, dir, p) || original;
            }
            case DENY: {
                return false;
            }
        }
        return original;
    }

    public static boolean fireFertility(World world, int x, int y, int z, boolean original) {
        GrassSustainCropEvent e = new GrassSustainCropEvent(world, x, y, z, ForgeDirection.UP, (IPlantable)Blocks.field_150464_aj);
        MinecraftForge.EVENT_BUS.post((Event)e);
        switch (e.getResult()) {
            case ALLOW: {
                return true;
            }
            case DENY: {
                return false;
            }
        }
        return original;
    }

    public static Block fireAgricraft_Block(Block caller, World world, int x, int y, int z) {
        GrassSustainCropEvent e = new GrassSustainCropEvent(world, x, y, z, ForgeDirection.UP, (IPlantable)Blocks.field_150464_aj);
        MinecraftForge.EVENT_BUS.post((Event)e);
        switch (e.getResult()) {
            case ALLOW: {
                return Blocks.field_150458_ak;
            }
        }
        return caller;
    }

    public static int fireAgricraft_Meta(World world, int x, int y, int z) {
        GrassSustainCropEvent e = new GrassSustainCropEvent(world, x, y, z, ForgeDirection.UP, (IPlantable)Blocks.field_150464_aj);
        MinecraftForge.EVENT_BUS.post((Event)e);
        switch (e.getResult()) {
            case ALLOW: {
                return 7;
            }
        }
        return world.func_72805_g(x, y, z);
    }
}

