/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import Reika.DragonAPI.Instantiable.Data.BarGraphData;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;

public class BarGraph {
    private final BarGraphData data;
    private final List<Integer> values;
    public final int xSize;
    public final int ySize;
    public final int barWidth;
    public final int maxY;

    public BarGraph(BarGraphData dat, int w, int h) {
        this.data = dat;
        this.xSize = w;
        this.ySize = h;
        this.values = this.data.getXValues();
        this.barWidth = this.xSize / this.data.getNumberEntries();
        int maxy = -1;
        for (int i = 0; i < this.values.size(); ++i) {
            int dx = this.values.get(i);
            int dy = this.data.getYOfX(dx);
            if (dy <= maxy) continue;
            maxy = dy;
        }
        this.maxY = maxy;
    }

    private int getBarHeight(int i) {
        int x = this.values.get(i);
        return this.data.getYOfX(x) * this.ySize / this.maxY;
    }

    public void render(int x, int y, Color barColor) {
        int w = this.barWidth;
        ReikaRenderHelper.prepareGeoDraw(false);
        int n = this.data.getNumberEntries();
        for (int i = 0; i < n; ++i) {
            int h = this.getBarHeight(i);
            int v = this.values.get(i);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            barColor = i % 2 == 0 ? barColor.darker().darker() : barColor.brighter().brighter();
            int color = barColor.getRGB();
            boolean line = false;
            if (line) {
                GuiScreen.func_73734_a((int)(x + i * w), (int)(y + this.ySize), (int)(x + i * w + w), (int)(y + this.ySize - h), (int)-16777216);
                GuiScreen.func_73734_a((int)(x + i * w + 1), (int)(y + this.ySize - 1), (int)(x + i * w + w - 1), (int)(y + this.ySize - h + 1), (int)color);
            } else {
                GuiScreen.func_73734_a((int)(x + i * w), (int)(y + this.ySize), (int)(x + i * w + w), (int)(y + this.ySize - h), (int)color);
            }
            int dx = x + i * w + w / 4;
            int dy = y + this.ySize;
            GL11.glTranslated((double)dx, (double)dy, (double)0.0);
            GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-dx), (double)(-dy), (double)0.0);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(String.valueOf(v), dx, dy, 0xFFFFFF);
            GL11.glTranslated((double)dx, (double)dy, (double)0.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-dx), (double)(-dy), (double)0.0);
        }
        ReikaRenderHelper.exitGeoDraw();
        ReikaRenderHelper.disableLighting();
    }
}

