/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemDrop {
    public final int minDrops;
    public final int maxDrops;
    private final ItemStack item;
    private static final Random rand = new Random();

    public ItemDrop(Block b) {
        this(b, 1, 1);
    }

    public ItemDrop(Block b, int min, int max) {
        this(new ItemStack(b), min, max);
    }

    public ItemDrop(Item i) {
        this(i, 1, 1);
    }

    public ItemDrop(Item i, int min, int max) {
        this(new ItemStack(i), min, max);
    }

    public ItemDrop(ItemStack is, int min, int max) {
        this.maxDrops = max;
        this.minDrops = min;
        this.item = is.func_77946_l();
    }

    public void enchant(HashMap<Enchantment, Integer> map) {
        ReikaEnchantmentHelper.applyEnchantments(this.item, map);
    }

    public void enchant(Enchantment ench, int level) {
        this.item.func_77966_a(ench, level);
    }

    public boolean equals(Object o) {
        if (o instanceof ItemDrop) {
            ItemDrop it = (ItemDrop)o;
            if (!ReikaItemHelper.matchStacks(this.item, it.item)) {
                return false;
            }
            return ItemStack.func_77970_a((ItemStack)this.item, (ItemStack)it.item);
        }
        return false;
    }

    public ItemStack getItemStack() {
        return this.item.func_77946_l();
    }

    public ItemStack getItem() {
        int num = this.getDropCount();
        ItemStack is = ReikaItemHelper.getSizedItemStack(this.item.func_77946_l(), num);
        return is;
    }

    public int getDropCount() {
        return this.minDrops + rand.nextInt(1 + this.maxDrops - this.minDrops);
    }

    public void drop(World world, double x, double y, double z) {
        ReikaItemHelper.dropItem(world, x, y, z, this.getItem());
    }

    public void drop(Entity e) {
        ReikaItemHelper.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u + 0.25, e.field_70161_v, this.getItem());
    }

    public Item getID() {
        return this.item.func_77973_b();
    }

    public int getMetadata() {
        return this.item.func_77960_j();
    }

    public boolean isEnchanted() {
        Map map = EnchantmentHelper.func_82781_a((ItemStack)this.item);
        return map != null && !map.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.item.func_82833_r());
        sb.append(": ");
        sb.append(this.item.func_77973_b());
        sb.append(":");
        sb.append(this.item.func_77960_j());
        sb.append(" (");
        if (this.minDrops != this.maxDrops) {
            sb.append(this.minDrops);
            sb.append("-");
        }
        sb.append(this.maxDrops);
        sb.append(")");
        if (this.isEnchanted()) {
            sb.append("; ");
            sb.append(EnchantmentHelper.func_82781_a((ItemStack)this.item));
        }
        return sb.toString();
    }
}

