/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import java.awt.Point;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class LineClipper {
    private static final int INSIDE = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 4;
    private static final int TOP = 8;
    public final int minX;
    public final int minY;
    public final int maxX;
    public final int maxY;

    public LineClipper(int x0, int y0, int x1, int y1) {
        this.minX = x0;
        this.minY = y0;
        this.maxX = x1;
        this.maxY = y1;
    }

    private int ComputeOutCode(int x, int y) {
        int code = 0;
        if (x < this.minX) {
            code |= 1;
        } else if (x > this.maxX) {
            code |= 2;
        }
        if (y < this.minY) {
            code |= 4;
        } else if (y > this.maxY) {
            code |= 8;
        }
        return code;
    }

    public ImmutablePair<Point, Point> clip(int x0, int y0, int x1, int y1) {
        int outcode0 = this.ComputeOutCode(x0, y0);
        int outcode1 = this.ComputeOutCode(x1, y1);
        while ((outcode0 | outcode1) != 0) {
            int outcodeOut;
            if ((outcode0 & outcode1) != 0) {
                return null;
            }
            int x = x0;
            int y = y0;
            int n = outcodeOut = outcode0 != 0 ? outcode0 : outcode1;
            if ((outcodeOut & 8) != 0) {
                x = x0 + (x1 - x0) * (this.maxY - y0) / (y1 - y0);
                y = this.maxY;
            } else if ((outcodeOut & 4) != 0) {
                x = x0 + (x1 - x0) * (this.minY - y0) / (y1 - y0);
                y = this.minY;
            } else if ((outcodeOut & 2) != 0) {
                y = y0 + (y1 - y0) * (this.maxX - x0) / (x1 - x0);
                x = this.maxX;
            } else if ((outcodeOut & 1) != 0) {
                y = y0 + (y1 - y0) * (this.minX - x0) / (x1 - x0);
                x = this.minX;
            }
            if (outcodeOut == outcode0) {
                x0 = x;
                y0 = y;
                outcode0 = this.ComputeOutCode(x0, y0);
                continue;
            }
            x1 = x;
            y1 = y;
            outcode1 = this.ComputeOutCode(x1, y1);
        }
        return new ImmutablePair((Object)new Point(x0, y0), (Object)new Point(x1, y1));
    }
}

