/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.ModInteract;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IAETagCompound;
import appeng.api.storage.data.IItemList;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class MENetwork {
    private static final Class baseTile;
    private BlockArray blocks = new BlockArray();
    private final Collection<IMEInventoryHandler> itemCache = new ArrayList<IMEInventoryHandler>();
    private final World world;

    private MENetwork() {
        this(null);
    }

    private MENetwork(World world) {
        this.world = world;
        if (!ModList.APPENG.isLoaded()) {
            throw new MisuseException("How do you plan to create an ME network object without AE installed?!");
        }
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public int getSize() {
        return this.blocks.getSize();
    }

    private void initializeStorage() {
        for (int i = 0; i < this.blocks.getSize(); ++i) {
            Coordinate c = this.blocks.getNthBlock(i);
            TileEntity te = this.world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
            if (!(te instanceof ICellProvider)) continue;
            ICellProvider icp = (ICellProvider)te;
            List<IMEInventoryHandler> li = icp.getCellArray(StorageChannel.ITEMS);
            for (IMEInventoryHandler ime : li) {
                this.itemCache.add(ime);
            }
        }
    }

    public ItemHashMap<Long> getMEContents() {
        ItemHashMap<Long> cache = new ItemHashMap<Long>();
        ItemList items = new ItemList();
        for (IMEInventoryHandler ime : this.itemCache) {
            items = (ItemList)ime.getAvailableItems(items);
        }
        for (IAEStack item : items.list) {
            if (!(item instanceof IAEItemStack)) continue;
            cache.put(((IAEItemStack)item).getItemStack(), (Long)item.getStackSize());
        }
        return cache;
    }

    public int removeFromMESystem(ItemStack is, int diff) {
        int rem = 0;
        for (IMEInventoryHandler ime : this.itemCache) {
            ItemList items = new ItemList();
            items = (ItemList)ime.getAvailableItems(items);
            for (IAEStack item : items.list) {
                IAEItemStack iae;
                if (!(item instanceof IAEItemStack) || !ReikaItemHelper.matchStacks(is, (iae = (IAEItemStack)item).getItemStack())) continue;
                int dec = (int)Math.min(iae.getStackSize(), (long)diff);
                IAEItemStack removed = ime.extractItems(iae, Actionable.MODULATE, new BaseActionSource());
                if (removed == null) continue;
                removed.decStackSize(dec);
                if (removed.getStackSize() > 0L) {
                    ime.injectItems(removed, Actionable.MODULATE, new BaseActionSource());
                }
                rem += dec;
                if ((diff -= dec) > 0) continue;
                return rem;
            }
            if (!(ime instanceof TileEntity)) continue;
            ((TileEntity)ime).func_70296_d();
        }
        return rem;
    }

    public String toString() {
        return this.blocks.toString() + " > " + this.itemCache.toString();
    }

    public static MENetwork getFromGridHost(IGridHost te, ForgeDirection dir) {
        if (!(te instanceof TileEntity)) {
            return null;
        }
        TileEntity tile = (TileEntity)te;
        MENetwork net = new MENetwork(tile.field_145850_b);
        IGrid ig = te.getGridNode(dir).getGrid();
        net.populate(ig);
        return net;
    }

    public static MENetwork getFromGridHost(IGridNode ign) {
        MENetwork net = new MENetwork();
        net.populate(ign.getGrid());
        return net;
    }

    private void populate(IGrid ig) {
        IStorageGrid isg = (IStorageGrid)ig.getCache(IStorageGrid.class);
        IMEMonitor<IAEItemStack> mon = isg.getItemInventory();
        IItemList<IAEItemStack> contained = mon.getStorageList();
    }

    public static MENetwork getConnectedTo(TileEntity te) {
        return MENetwork.getConnectedTo(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static MENetwork getConnectedTo(World world, int x, int y, int z) {
        MENetwork net = new MENetwork(world);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (te == null || !baseTile.isAssignableFrom(te.getClass())) continue;
            net.blocks.addBlockCoordinate(dx, dy, dz);
            MENetwork.recursiveConnect(world, dx, dy, dz, net);
        }
        net.initializeStorage();
        return net;
    }

    private static void recursiveConnect(World world, int x, int y, int z, MENetwork net) {
        for (int i = 0; i < 6; ++i) {
            TileEntity te;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (net.blocks.hasBlock(dx, dy, dz) || (te = world.func_147438_o(dx, dy, dz)) == null || !baseTile.isAssignableFrom(te.getClass())) continue;
            net.blocks.addBlockCoordinate(dx, dy, dz);
            MENetwork.recursiveConnect(world, dx, dy, dz, net);
        }
    }

    static {
        Class<?> c = null;
        try {
            c = Class.forName("appeng.tile.AEBaseTile");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        baseTile = c;
    }

    private static class ItemList
    implements IItemList {
        private final ArrayList<IAEStack> list = new ArrayList();

        private ItemList() {
        }

        public String toString() {
            return this.list.toString();
        }

        @Override
        public void add(IAEStack option) {
            this.list.add(option);
        }

        @Override
        public IAEStack findPrecise(IAEStack i) {
            return null;
        }

        @Override
        public Collection findFuzzy(IAEStack input, FuzzyMode fuzzy) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public void addStorage(IAEStack option) {
        }

        public void addCrafting(IAEStack option) {
        }

        public void addRequestable(IAEStack option) {
        }

        public IAEStack getFirstItem() {
            return this.list.get(0);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Iterator iterator() {
            return this.list.iterator();
        }

        @Override
        public void resetStatus() {
            this.list.clear();
        }
    }

    private static class AEStack
    implements IAEItemStack,
    Comparable<AEStack> {
        private final ItemStack stack;

        private AEStack(ItemStack is, int size) {
            this.stack = ReikaItemHelper.getSizedItemStack(is, size);
        }

        @Override
        public long getStackSize() {
            return this.stack.field_77994_a;
        }

        @Override
        public IAEItemStack setStackSize(long l) {
            this.stack.field_77994_a = (int)l;
            return this;
        }

        @Override
        public long getCountRequestable() {
            return 0L;
        }

        @Override
        public IAEItemStack setCountRequestable(long paramLong) {
            return this;
        }

        @Override
        public boolean isCraftable() {
            return false;
        }

        @Override
        public IAEItemStack setCraftable(boolean paramBoolean) {
            return this;
        }

        @Override
        public IAEItemStack reset() {
            return this;
        }

        @Override
        public void incStackSize(long l) {
            this.stack.field_77994_a = (int)((long)this.stack.field_77994_a + l);
        }

        @Override
        public void decStackSize(long l) {
            this.stack.field_77994_a = (int)((long)this.stack.field_77994_a - l);
        }

        @Override
        public void incCountRequestable(long paramLong) {
        }

        @Override
        public void decCountRequestable(long paramLong) {
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            this.stack.func_77955_b(tag);
        }

        @Override
        public boolean fuzzyComparison(Object obj, FuzzyMode mode) {
            return false;
        }

        @Override
        public void writeToPacket(ByteBuf buf) throws IOException {
        }

        @Override
        public IAEItemStack empty() {
            return this;
        }

        @Override
        public IAETagCompound getTagCompound() {
            return null;
        }

        @Override
        public boolean isItem() {
            return true;
        }

        @Override
        public boolean isFluid() {
            return false;
        }

        @Override
        public StorageChannel getChannel() {
            return StorageChannel.ITEMS;
        }

        @Override
        public ItemStack getItemStack() {
            return this.stack;
        }

        @Override
        public IAEItemStack copy() {
            return new AEStack(this.stack, this.stack.field_77994_a);
        }

        @Override
        public boolean hasTagCompound() {
            return false;
        }

        @Override
        public void add(IAEItemStack iae) {
        }

        @Override
        public Item getItem() {
            return this.stack.func_77973_b();
        }

        @Override
        public int getItemDamage() {
            return this.stack.func_77960_j();
        }

        @Override
        public boolean sameOre(IAEItemStack iae) {
            return Arrays.equals(OreDictionary.getOreIDs((ItemStack)this.stack), OreDictionary.getOreIDs((ItemStack)iae.getItemStack()));
        }

        @Override
        public boolean isSameType(IAEItemStack iae) {
            return ReikaItemHelper.matchStacks(this.stack, iae.getItemStack());
        }

        @Override
        public boolean isSameType(ItemStack is) {
            return ReikaItemHelper.matchStacks(this.stack, is);
        }

        @Override
        public int compareTo(AEStack o) {
            return (int)(o.getStackSize() - this.getStackSize());
        }

        @Override
        public boolean isMeaningful() {
            return false;
        }

        public boolean isMeaninful() {
            return false;
        }
    }
}

