/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.ParticleController;

import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import net.minecraft.entity.Entity;

public class CorkscrewMotionController
implements PositionController {
    public final double originX;
    public final double originY;
    public final double originZ;
    public final double length;
    public final double theta;
    public final double phi;
    public final double linearSpeed;
    public final double angleSpeed;
    public final double spiralRadius;
    private double pos;
    private double angle;

    public CorkscrewMotionController(double x, double y, double z, double len, double th, double ph, double v, double va, double r) {
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.linearSpeed = v;
        this.angleSpeed = va;
        this.spiralRadius = r;
        this.length = len;
        this.theta = th;
        this.phi = ph;
    }

    @Override
    public void update(Entity e) {
        this.angle += this.angleSpeed;
        this.pos += this.linearSpeed;
    }

    @Override
    public double getPositionX(Entity e) {
        return this.originX + ReikaPhysicsHelper.polarToCartesian(this.pos, this.theta, this.phi)[0] + this.spiralRadius * Math.cos(Math.toRadians(this.angle)) * Math.cos(Math.toRadians(this.theta));
    }

    @Override
    public double getPositionY(Entity e) {
        return this.originY + ReikaPhysicsHelper.polarToCartesian(this.pos, this.theta, this.phi)[1] + this.spiralRadius * Math.sin(Math.toRadians(this.angle)) * Math.sin(Math.toRadians(this.theta));
    }

    @Override
    public double getPositionZ(Entity e) {
        return this.originZ + ReikaPhysicsHelper.polarToCartesian(this.pos, this.theta, this.phi)[2] + this.spiralRadius * Math.cos(Math.toRadians(this.angle)) * Math.cos(Math.toRadians(this.theta));
    }
}

