/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerBlockHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Registry.BlockRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class RayTracer {
    private double originX;
    private double originY;
    private double originZ;
    private double targetX;
    private double targetY;
    private double targetZ;
    public boolean softBlocksOnly = false;
    public boolean allowFluids = true;
    private final ArrayList<BlockKey> forbiddenBlocks = new ArrayList();
    private final ArrayList<BlockKey> allowedBlocks = new ArrayList();

    public RayTracer(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.originX = x1;
        this.originY = y1;
        this.originZ = z1;
        this.targetX = x2;
        this.targetY = y2;
        this.targetZ = z2;
    }

    public void setOrigins(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.originX = x1;
        this.originY = y1;
        this.originZ = z1;
        this.targetX = x2;
        this.targetY = y2;
        this.targetZ = z2;
    }

    public void offset(double dx, double dy, double dz) {
        this.offset(dx, dy, dz, dx, dy, dz);
    }

    public void offset(double dx1, double dy1, double dz1, double dx2, double dy2, double dz2) {
        this.originX += dx1;
        this.originY += dy1;
        this.originZ += dz1;
        this.targetX += dx2;
        this.targetY += dy2;
        this.targetZ += dz2;
    }

    public void addOpaqueBlock(Block b) {
        this.addOpaqueBlock(b, -1);
    }

    public void addOpaqueBlock(Block b, int meta) {
        this.forbiddenBlocks.add(new BlockKey(b, meta));
    }

    public void addTransparentBlock(Block b) {
        this.addTransparentBlock(b, -1);
    }

    public void addTransparentBlock(Block b, int meta) {
        this.allowedBlocks.add(new BlockKey(b, meta));
    }

    public boolean isClearLineOfSight(World world) {
        Vec3 vec1 = Vec3.func_72443_a((double)this.originX, (double)this.originY, (double)this.originZ);
        Vec3 vec2 = Vec3.func_72443_a((double)this.targetX, (double)this.targetY, (double)this.targetZ);
        Vec3 ray = ReikaVectorHelper.subtract(vec1, vec2);
        double dx = vec2.field_72450_a - vec1.field_72450_a;
        double dy = vec2.field_72448_b - vec1.field_72448_b;
        double dz = vec2.field_72449_c - vec1.field_72449_c;
        double dd = ReikaMathLibrary.py3d(dx, dy, dz);
        for (double d = 0.25; d <= dd; d += 0.25) {
            int bz;
            int by;
            int bx;
            Vec3 vec0 = ReikaVectorHelper.scaleVector(ray, d);
            Vec3 vec = ReikaVectorHelper.scaleVector(ray, d - 0.25);
            vec0.field_72450_a += vec1.field_72450_a;
            vec0.field_72448_b += vec1.field_72448_b;
            vec0.field_72449_c += vec1.field_72449_c;
            vec.field_72450_a += vec1.field_72450_a;
            vec.field_72448_b += vec1.field_72448_b;
            vec.field_72449_c += vec1.field_72449_c;
            MovingObjectPosition mov = world.func_72933_a(vec, vec0);
            if (mov == null || mov.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || !this.isNonTerminal(bx = mov.field_72311_b, by = mov.field_72312_c, bz = mov.field_72309_d) || !this.isDisallowedBlock(world, bx, by, bz)) continue;
            return false;
        }
        return true;
    }

    private boolean isNonTerminal(int x, int y, int z) {
        if (x == MathHelper.func_76128_c((double)this.originX) && y == MathHelper.func_76128_c((double)this.originY) && z == MathHelper.func_76128_c((double)this.originZ)) {
            return false;
        }
        return x != MathHelper.func_76128_c((double)this.targetX) || y != MathHelper.func_76128_c((double)this.targetY) || z != MathHelper.func_76128_c((double)this.targetZ);
    }

    private boolean isDisallowedBlock(World world, int x, int y, int z) {
        int meta;
        Block b = world.func_147439_a(x, y, z);
        BlockKey key = new BlockKey(b, meta = world.func_72805_g(x, y, z));
        if (this.allowedBlocks.contains(key)) {
            return false;
        }
        if (this.forbiddenBlocks.contains(key)) {
            return true;
        }
        if (!this.allowFluids && ReikaBlockHelper.isLiquid(b)) {
            return true;
        }
        return !ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y, z) || this.softBlocksOnly && ReikaBlockHelper.isCollideable(world, x, y, z);
    }

    public boolean isBlockPassable(World world, int x, int y, int z) {
        return !this.isDisallowedBlock(world, x, y, z);
    }

    public static RayTracer getVisualLOS() {
        RayTracer trace = new RayTracer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        trace.addTransparentBlock(Blocks.field_150359_w);
        trace.addTransparentBlock(Blocks.field_150432_aD);
        trace.addTransparentBlock(Blocks.field_150410_aZ);
        trace.addTransparentBlock(Blocks.field_150411_aY);
        trace.addTransparentBlock(Blocks.field_150422_aJ);
        trace.addTransparentBlock(Blocks.field_150386_bk);
        trace.addTransparentBlock(Blocks.field_150474_ac);
        trace.addTransparentBlock((Block)Blocks.field_150362_t);
        trace.addTransparentBlock((Block)Blocks.field_150361_u);
        trace.addTransparentBlock((Block)Blocks.field_150329_H);
        trace.allowFluids = true;
        if (ModList.CHROMATICRAFT.isLoaded()) {
            RayTracer.addCCGlass(trace);
        }
        if (ModList.ROTARYCRAFT.isLoaded()) {
            RayTracer.addRCGlass(trace);
        }
        if (ModList.EXTRAUTILS.isLoaded() && ExtraUtilsHandler.getInstance().deco2ID != null) {
            trace.addTransparentBlock(ExtraUtilsHandler.getInstance().deco2ID, 1);
            trace.addTransparentBlock(ExtraUtilsHandler.getInstance().deco2ID, 2);
            trace.addTransparentBlock(ExtraUtilsHandler.getInstance().deco2ID, 4);
        }
        if (ModList.TINKERER.isLoaded() && TinkerBlockHandler.getInstance().clearGlassID != null) {
            trace.addTransparentBlock(TinkerBlockHandler.getInstance().clearGlassID);
        }
        return trace;
    }

    @DependentMethodStripper.ModDependent(value=ModList.CHROMATICRAFT)
    private static void addCCGlass(RayTracer trace) {
        trace.addTransparentBlock(ChromaBlocks.GLASS.getBlockInstance());
        trace.addTransparentBlock(ChromaBlocks.SELECTIVEGLASS.getBlockInstance());
        trace.addTransparentBlock(ChromaBlocks.DOOR.getBlockInstance());
    }

    @DependentMethodStripper.ModDependent(value=ModList.ROTARYCRAFT)
    private static void addRCGlass(RayTracer trace) {
        trace.addTransparentBlock(BlockRegistry.BLASTGLASS.getBlockInstance());
        trace.addTransparentBlock(BlockRegistry.BLASTPANE.getBlockInstance());
    }
}

