/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class CompositeParticle {
    public final World world;
    public final int x;
    public final int y;
    public final int z;
    public final int frameLength;
    private int frame;
    private final FXState[] data;

    public CompositeParticle(World world, int x, int y, int z, int n, ParticleSpawner p) {
        CacheableFX next;
        int i;
        this.frameLength = n;
        this.data = new FXState[n];
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        ArrayList<CacheableFX> overEnd = new ArrayList<CacheableFX>();
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = new FXState();
            ArrayList<CacheableFX> newFX = new ArrayList<CacheableFX>();
            p.createNewFX(newFX, i);
            for (CacheableFX fx : newFX) {
                this.data[i].particles.add(fx);
            }
            if (i > 0) {
                for (CacheableFX fx : this.data[i - 1].particles) {
                    next = fx.nextFrame();
                    if (next == null) continue;
                    this.data[i].particles.add(next);
                }
            }
            if (i != this.data.length - 1) continue;
            for (CacheableFX fx : this.data[i].particles) {
                next = fx.nextFrame();
                if (next == null) continue;
                overEnd.add(next);
            }
        }
        i = 0;
        while (!overEnd.isEmpty()) {
            ArrayList cp = new ArrayList(overEnd);
            overEnd.clear();
            for (CacheableFX fx : cp) {
                this.data[i].particles.add(fx);
                next = fx.nextFrame();
                if (next == null) continue;
                overEnd.add(next);
            }
            ++i;
        }
    }

    public void render(float ptick) {
        float yaw = ActiveRenderInfo.field_74588_d;
        float pitch = ActiveRenderInfo.field_74586_f;
        float f3 = ActiveRenderInfo.field_74587_g;
        float f4 = ActiveRenderInfo.field_74596_h;
        float f5 = ActiveRenderInfo.field_74589_e;
        this.data[this.frame].render(ptick, yaw, f5, pitch, f3, f4);
        this.frame = this.frame == this.frameLength - 1 ? 0 : this.frame + 1;
    }

    public static interface CacheableFX {
        public CacheableFX nextFrame();
    }

    public static interface ParticleSpawner {
        public void createNewFX(Collection<CacheableFX> var1, int var2);
    }

    private static class FXState {
        private final ArrayList<CacheableFX> particles = new ArrayList();

        private FXState() {
        }

        private void render(float ptick, float yaw, float f5, float pitch, float f3, float f4) {
            for (CacheableFX fx : this.particles) {
                ((EntityFX)fx).func_70539_a(Tessellator.field_78398_a, ptick, yaw, f5, pitch, f3, f4);
            }
        }
    }
}

