/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.input.Keyboard;

public class LODModelPart
extends ModelRenderer {
    private double renderDistanceSqr = -1.0;
    private double lastDistance;
    private long lastTime;
    private TileEntity lastLocation;

    public LODModelPart(ModelBase baseModel, int textureX, int textureZ) {
        super(baseModel, textureX, textureZ);
    }

    public final ModelRenderer func_78786_a(String par1Str, float par2, float par3, float par4, int par5, int par6, int par7) {
        if (!this.field_78804_l.isEmpty()) {
            throw new UnsupportedOperationException("You may only have one box per model piece!");
        }
        super.func_78786_a(par1Str, par2, par3, par4, par5, par6, par7);
        float size = this.calculateVolume();
        this.renderDistanceSqr = this.calculateRenderDistance(size);
        return this;
    }

    public final ModelRenderer func_78789_a(float par1, float par2, float par3, int par4, int par5, int par6) {
        if (!this.field_78804_l.isEmpty()) {
            throw new UnsupportedOperationException("You may only have one box per model piece!");
        }
        super.func_78789_a(par1, par2, par3, par4, par5, par6);
        float size = this.calculateVolume();
        this.renderDistanceSqr = this.calculateRenderDistance(size);
        return this;
    }

    public final void func_78790_a(float par1, float par2, float par3, int par4, int par5, int par6, float par7) {
        if (!this.field_78804_l.isEmpty()) {
            throw new UnsupportedOperationException("You may only have one box per model piece!");
        }
        super.func_78790_a(par1, par2, par3, par4, par5, par6, par7);
        float size = this.calculateVolume();
        this.renderDistanceSqr = this.calculateRenderDistance(size);
    }

    protected final ModelBox getBox() {
        return (ModelBox)this.field_78804_l.get(0);
    }

    public final float calculateVolume() {
        ModelBox box = this.getBox();
        float x = box.field_78252_a - box.field_78248_d;
        float y = box.field_78250_b - box.field_78249_e;
        float z = box.field_78251_c - box.field_78246_f;
        return Math.abs(x * y * z);
    }

    private double calculateRenderDistance(float size) {
        int d = 0;
        d = size > 1024.0f ? 16384 : (size > 512.0f ? 4096 : (size > 128.0f ? 2048 : (size > 32.0f ? 1024 : (size > 8.0f ? 256 : (size > 4.0f ? 128 : (size > 0.0f ? 96 : 0))))));
        return d;
    }

    public final boolean shouldRender(double dist_squared) {
        return Keyboard.isKeyDown((int)29) || this.renderDistanceSqr * this.getDistanceMultiplier() >= dist_squared;
    }

    private double getDistanceMultiplier() {
        ReikaRenderHelper.RenderDistance r = ReikaRenderHelper.getRenderDistance();
        switch (r) {
            case FAR: {
                return 2.0;
            }
            case NORMAL: {
                return 1.0;
            }
            case SHORT: {
                return 0.75;
            }
            case TINY: {
                return 0.4;
            }
        }
        return 1.0;
    }

    public final void render(TileEntity te, float pixelSize) {
        double d = this.calcAndCacheRenderDistance(te);
        if (!te.func_145830_o() || MinecraftForgeClient.getRenderPass() == -1 || this.shouldRender(d)) {
            super.func_78785_a(pixelSize);
        }
    }

    private double calcAndCacheRenderDistance(TileEntity te) {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        long time = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        if (te == this.lastLocation && time == this.lastTime) {
            return this.lastDistance;
        }
        double rx = ep.field_70165_t;
        double ry = ep.field_70163_u;
        double rz = ep.field_70161_v;
        double dx = rx - (double)te.field_145851_c - 0.5;
        double dy = ry - (double)te.field_145848_d - 0.5;
        double dz = rz - (double)te.field_145849_e - 0.5;
        double d = dx * dx + dy * dy + dz * dz;
        this.lastLocation = te;
        this.lastTime = time;
        this.lastDistance = d;
        return d;
    }
}

