/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ReikaJVMParser {
    private static final HashSet<String> args = new HashSet();
    private static final int[] version = ReikaJVMParser.getJavaVersion();

    public static Set<String> getAllArguments() {
        return Collections.unmodifiableSet(args);
    }

    public static boolean isArgumentPresent(String arg) {
        return args.contains(arg);
    }

    public static String getArgumentModifier(String pre) {
        for (String s : args) {
            if (!s.startsWith(pre)) continue;
            return s.substring(pre.length());
        }
        return null;
    }

    public static int getArgumentInteger(String pre) {
        for (String s : args) {
            if (!s.startsWith(pre)) continue;
            int idx = s.indexOf(61);
            String ret = s.substring(idx);
            return ReikaJavaLibrary.safeIntParse(ret);
        }
        return -1;
    }

    public static long getAllocatedHeapMemory() {
        for (String s : args) {
            if (!s.startsWith("-Xmx")) continue;
            String ret = s.substring(4);
            char size = ret.charAt(ret.length() - 1);
            if (Character.isLowerCase(size)) {
                size = Character.toUpperCase(size);
            }
            ret = ret.substring(0, ret.length() - 1);
            int base = Integer.parseInt(ret);
            if (size == 'K') {
                return (long)base * 1000L;
            }
            if (size == 'M') {
                return (long)base * 1000000L;
            }
            if (size == 'G') {
                return (long)base * 1000000000L;
            }
            throw new IllegalArgumentException("Invalid memory specification.");
        }
        return 1000000000L;
    }

    private static int[] getJavaVersion() {
        String v = System.getProperty("java.version");
        String[] parts = v.replaceAll("[^0-9\\._]", "").replaceAll("_", ".").split("\\.");
        int[] ret = new int[parts.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Integer.parseInt(parts[i + 1]);
        }
        return ret;
    }

    public static int getJavaVersion(int subindex) {
        return version[subindex];
    }

    static {
        args.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
        ReikaJavaLibrary.pConsole("Java Version: " + Arrays.toString(version));
        ReikaJavaLibrary.pConsole("Heap memory allocation: " + ReikaJVMParser.getAllocatedHeapMemory());
        ReikaJavaLibrary.pConsole(args.size() + " Java arguments present: " + args);
    }
}

