/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModList;
import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public final class ReikaJavaLibrary
extends DragonAPICore {
    private static int maxRecurse = -1;
    public static boolean dumpStack = false;
    public static boolean silent = false;
    private static final boolean printClasses = ReikaJVMParser.isArgumentPresent("-DragonAPI_printClassInit");
    private static final HashMap<String, Object> threadLock = new HashMap();
    private static final char[] IDChars = new char[]{'\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c2', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9', '\u0393', '\u0394', '\u0398', '\u039b', '\u03a0', '\u03a3', '\u03a6', '\u03a8', '\u03a9', '\u0414', '\u0416', '\u0418', '\u0428', '\u042c', '\u042d', '\u042e', '\u042f', '\u05d0', '\u05d1', '\u05d2', '\u05d3', '\u05d4', '\u05d7', '\u05d8', '\u05da', '\u05db', '\u05dc', '\u05dd', '\u05de', '\u05e1', '\u05e2', '\u05e3', '\u05e4', '\u05e6', '\u05e7', '\u05e8', '\u05e9', '\u05ea'};

    public static void pConsole(Object obj) {
        ReikaJavaLibrary.pConsole(Level.INFO, obj);
    }

    public static void pConsole(Level level, Object obj) {
        if (silent) {
            return;
        }
        if (obj == null) {
            ReikaJavaLibrary.writeLineToConsoleAndLogs(level, "null arg");
        } else {
            Class<?> cl = obj.getClass();
            if (cl != String.class && cl != Integer.class && cl != Boolean.class) {
                ReikaJavaLibrary.writeLineToConsoleAndLogs(level, String.valueOf(obj) + " of " + String.valueOf(cl));
            } else {
                ReikaJavaLibrary.writeLineToConsoleAndLogs(level, String.valueOf(obj));
            }
        }
        if (dumpStack) {
            ReikaJavaLibrary.dumpStack();
        }
    }

    public static void dumpStack() {
        ReikaJavaLibrary.writeLineToConsoleAndLogs(Level.WARN, "Stack Trace:");
        StackTraceElement[] s = new Exception("Stack Trace").getStackTrace();
        for (int i = 1; i < s.length; ++i) {
            ReikaJavaLibrary.writeLineToConsoleAndLogs(Level.WARN, "\t" + s[i].toString());
        }
    }

    private static void writeLineToConsoleAndLogs(Level level, String s) {
        s = s.replaceAll("%", "%%");
        FMLLog.log((Level)level, (String)s, (Object[])new Object[0]);
    }

    public static void spamConsole(Object obj) {
        String sg = String.valueOf(obj);
        for (int i = 0; i < 16; ++i) {
            ReikaJavaLibrary.pConsole(sg);
        }
    }

    public static void writeCoord(World world, int x, int y, int z) {
        ReikaJavaLibrary.pConsole(world.func_147439_a(x, y, z) + ":" + world.func_72805_g(x, y, z) + " @ " + x + ", " + y + ", " + z + " @DIM" + world.field_73011_w.field_76574_g);
    }

    public static void pConsole(Object obj, Side s) {
        if (FMLCommonHandler.instance().getEffectiveSide() == s) {
            ReikaJavaLibrary.pConsole(obj);
        }
    }

    public static void pConsole(Object obj, Side s, boolean con) {
        if (con) {
            ReikaJavaLibrary.pConsole(obj, s);
        }
    }

    public static void pConsole(Object obj, boolean con) {
        if (con) {
            ReikaJavaLibrary.pConsole(obj);
        }
    }

    public static HashSet makeSetFromArray(Object[] obj) {
        HashSet<Object> li = new HashSet<Object>();
        for (int i = 0; i < obj.length; ++i) {
            li.add(obj[i]);
        }
        return li;
    }

    public static ArrayList makeListFromArray(Object[] obj) {
        ArrayList<Object> li = new ArrayList<Object>();
        for (int i = 0; i < obj.length; ++i) {
            li.add(obj[i]);
        }
        return li;
    }

    public static ArrayList<Integer> makeIntListFromArray(int ... obj) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < obj.length; ++i) {
            li.add(obj[i]);
        }
        return li;
    }

    public static ArrayList makeListFrom(Object obj) {
        ArrayList<Object> li = new ArrayList<Object>();
        li.add(obj);
        return li;
    }

    public static ArrayList makeListFrom(Object ... obj) {
        ArrayList<Object> li = new ArrayList<Object>();
        for (int i = 0; i < obj.length; ++i) {
            li.add(obj[i]);
        }
        return li;
    }

    public static boolean isValidInteger(String s) {
        if (s.contentEquals("-")) {
            return true;
        }
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static int safeIntParse(String s) {
        boolean neg = false;
        int num = 0;
        if (s.startsWith("-")) {
            s = s.substring(1);
            neg = true;
        }
        if (s.matches("\\d+")) {
            num = Integer.parseInt(s);
        }
        return neg ? -num : num;
    }

    public static void printLine(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("-");
        }
        ReikaJavaLibrary.pConsole(sb.toString());
    }

    public static <T, E> T getHashMapKeyByValue(HashMap<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean doesClassExist(String cl) {
        try {
            Class.forName(cl, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static Class getClassNoException(String cl) {
        try {
            return Class.forName(cl);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void initClass(String c) {
        try {
            Class.forName(c, true, ReikaJavaLibrary.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c + "! Class not found!");
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c + "! Class not found!");
            e.printStackTrace();
        }
        catch (LinkageError e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c + "! Class not found!");
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c + "!");
            String s = e.getMessage();
            if (s.endsWith("for invalid side SERVER")) {
                ReikaJavaLibrary.pConsole("DRAGONAPI: Attemped to load a clientside class on the server! This is a significant programming error!");
            }
            e.printStackTrace();
        }
    }

    public static void initClass(Class c) {
        if (printClasses) {
            ReikaJavaLibrary.printClassMetadata(c);
        }
        if (c == null) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Cannot initalize a null class!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        try {
            Class.forName(c.getName(), true, ReikaJavaLibrary.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c.getName() + "! Class not found!");
            e.printStackTrace();
            ReikaJavaLibrary.printClassMetadata(c);
        }
        catch (NoClassDefFoundError e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c.getName() + "! Class not found!");
            e.printStackTrace();
            ReikaJavaLibrary.printClassMetadata(c);
        }
        catch (LinkageError e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c.getName() + "! Class not found!");
            e.printStackTrace();
            ReikaJavaLibrary.printClassMetadata(c);
        }
        catch (RuntimeException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Failed to initalize class " + c.getName() + "!");
            String s = e.getMessage();
            if (s.endsWith("for invalid side SERVER")) {
                ReikaJavaLibrary.pConsole("DRAGONAPI: Attemped to load a clientside class on the server! This is a significant programming error!");
            }
            e.printStackTrace();
        }
    }

    public static void printClassSource(Class c, String path) {
        ReikaJavaLibrary.printClassSource(path + c.getName(), ReikaJavaLibrary.getClassBytes(c));
    }

    public static void printClassMetadata(Class c) {
        ReikaJavaLibrary.printClassMetadata(c.getName(), c);
    }

    public static void printClassASM(Class c) {
        ReikaJavaLibrary.printClassASM(c.getName(), ReikaJavaLibrary.getClassBytes(c));
    }

    public static void printClassSource(Class c) {
        ReikaJavaLibrary.printClassSource(c.getName(), ReikaJavaLibrary.getClassBytes(c));
    }

    public static byte[] getClassBytes(Class c) {
        String className = c.getName();
        String classAsPath = className.replace('.', '/') + ".class";
        InputStream stream = c.getClassLoader().getResourceAsStream(classAsPath);
        try {
            return IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Error converting class to byte[]!");
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static void printClassMetadata(String path, Class c) {
        String filename = path + ".classdata";
        try {
            File f = new File(filename);
            f.createNewFile();
            BufferedWriter p = new BufferedWriter(new PrintWriter(f));
            ReikaJavaLibrary.printClassMetadata(p, c);
            p.close();
        }
        catch (IOException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Error printing class data!");
            e.printStackTrace();
        }
    }

    private static void printClassMetadata(BufferedWriter p, Class c) throws IOException {
        try {
            p.write("General:\n");
            p.write("\t" + c.getName() + "\n");
            p.write("\tAnnotations: " + Arrays.toString(c.getAnnotations()) + "\n");
            p.write("\tModifiers: " + Integer.toBinaryString(c.getModifiers()) + "\n");
            p.write("\tSuperclass: " + c.getSuperclass() + "\n");
            p.write("\tInterfaces: " + Arrays.toString(c.getInterfaces()) + "\n");
            p.write("\tSynthetic: " + c.isSynthetic() + "\n");
            p.write("\n\n");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            p.write("Internal Classes:\n");
            for (GenericDeclaration genericDeclaration : c.getDeclaredClasses()) {
                try {
                    ReikaJavaLibrary.printClassMetadata(p, (Class)genericDeclaration);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            p.write("\n\n");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            p.write("Constructors:\n");
            for (AnnotatedElement annotatedElement : c.getDeclaredConstructors()) {
                try {
                    p.write("\t\tAnnotations: " + Arrays.toString(((AccessibleObject)annotatedElement).getAnnotations()) + "\n");
                    p.write("\t\tModifiers: " + Integer.toBinaryString(((Constructor)annotatedElement).getModifiers()) + "\n");
                    p.write("\t\tSignature: " + Arrays.toString(((Constructor)annotatedElement).getParameterTypes()) + "\n");
                    p.write("\t\tExceptions: " + Arrays.toString(((Constructor)annotatedElement).getExceptionTypes()) + "\n");
                    p.write("\tSynthetic: " + ((Constructor)annotatedElement).isSynthetic() + "\n");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            p.write("\n\n");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            p.write("Fields:\n");
            for (AnnotatedElement annotatedElement : c.getDeclaredFields()) {
                try {
                    p.write("\t" + ((Field)annotatedElement).getName() + "\n");
                    p.write("\t\tAnnotations: " + Arrays.toString(((AccessibleObject)annotatedElement).getAnnotations()) + "\n");
                    p.write("\t\tModifiers: " + Integer.toBinaryString(((Field)annotatedElement).getModifiers()) + "\n");
                    p.write("\t\tType: " + ((Field)annotatedElement).getType() + "\n");
                    p.write("\tSynthetic: " + ((Field)annotatedElement).isSynthetic() + "\n");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            p.write("\n\n");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            p.write("Methods:\n");
            for (AnnotatedElement annotatedElement : c.getDeclaredMethods()) {
                try {
                    p.write("\t" + ((Method)annotatedElement).getName());
                    p.write("\t\tAnnotations: " + Arrays.toString(((AccessibleObject)annotatedElement).getAnnotations()) + "\n");
                    p.write("\t\tModifiers: " + Integer.toBinaryString(((Method)annotatedElement).getModifiers()) + "\n");
                    p.write("\t\tSignature: " + Arrays.toString(((Method)annotatedElement).getParameterTypes()) + "\n");
                    p.write("\t\tExceptions: " + Arrays.toString(((Method)annotatedElement).getExceptionTypes()) + "\n");
                    p.write("\t\tReturn: " + ((Method)annotatedElement).getReturnType() + "\n");
                    p.write("\tSynthetic: " + ((Method)annotatedElement).isSynthetic() + "\n");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            p.write("\n\n");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void printClassASM(String path, byte[] data) {
        ClassReader reader = new ClassReader(data);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        String filename = path + ".asm";
        try {
            File f = new File(filename);
            f.createNewFile();
            BufferedWriter p = new BufferedWriter(new PrintWriter(f));
            for (MethodNode m : methods) {
                InsnList inList = m.instructions;
                p.write(m.name);
                for (int i = 0; i < inList.size(); ++i) {
                    p.write(ReikaASMHelper.clearString(inList.get(i)));
                }
            }
            p.close();
        }
        catch (IOException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Error printing class ASM!");
            e.printStackTrace();
        }
    }

    public static void printClassSource(String path, byte[] data) {
        String filename = path + ".class";
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(data);
            fos.close();
        }
        catch (IOException e) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Error printing class!");
            e.printStackTrace();
        }
    }

    public static void initClassWithSubs(Class c) {
        ReikaJavaLibrary.initClass(c);
        for (Class<?> c2 : c.getDeclaredClasses()) {
            ReikaJavaLibrary.initClass(c2);
        }
    }

    public static boolean listContainsArray(List<int[]> li, int[] arr) {
        for (int i = 0; i < li.size(); ++i) {
            if (!Arrays.equals(li.get(i), arr)) continue;
            return true;
        }
        return false;
    }

    public static int getEnumLengthWithoutInitializing(Class<? extends Enum> c) {
        Field[] q = c.getFields();
        int count = 0;
        for (int i = 0; i < q.length; ++i) {
            Field f = q[i];
            if (!f.isEnumConstant()) continue;
            ++count;
        }
        return count;
    }

    public static ArrayList<String> getEnumEntriesWithoutInitializing(Class<? extends Enum> c) {
        ArrayList<String> li = new ArrayList<String>();
        Field[] q = c.getFields();
        for (int i = 0; i < q.length; ++i) {
            Field f = q[i];
            if (!f.isEnumConstant()) continue;
            li.add(f.getName());
        }
        return li;
    }

    public static int getMaximumRecursiveDepth() {
        if (maxRecurse <= 0) {
            ReikaJavaLibrary.recurse(0);
        }
        return maxRecurse;
    }

    private static int recurse(int i) {
        maxRecurse = Math.max(i, maxRecurse);
        try {
            ReikaJavaLibrary.recurse(i + 1);
        }
        catch (StackOverflowError e) {
            return i;
        }
        return 0;
    }

    public static void toggleStackTrace() {
        dumpStack = !dumpStack;
    }

    public static void toggleSilentMode() {
        silent = !silent;
    }

    public static Class[] getObjectClasses(Object ... objs) {
        Class[] c = new Class[objs.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = ReikaJavaLibrary.getClassOf(objs[i]);
        }
        return c;
    }

    public static Class getClassOf(Object o) {
        Class<?> p = ReikaJavaLibrary.getPrimitiveClass(o);
        return p != null ? p : o.getClass();
    }

    private static Class getPrimitiveClass(Object o) {
        String name = o.getClass().getSimpleName().toLowerCase(Locale.ENGLISH);
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("integer")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("character")) {
            return Character.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }

    public static <K, T> boolean collectionMapContainsValue(HashMap<K, Collection<T>> map, T value) {
        for (Collection<T> c : map.values()) {
            if (c == null || !c.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static byte[] streamToBytes(InputStream in) {
        ArrayList<Byte> li = new ArrayList<Byte>();
        try {
            int ret = in.read();
            while (ReikaMathLibrary.isValueInsideBoundsIncl(0, 255, ret)) {
                li.add((byte)ret);
                ret = in.read();
            }
            byte[] arr = new byte[li.size()];
            for (int i = 0; i < li.size(); ++i) {
                arr[i] = (Byte)li.get(i);
            }
            return arr;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <I, O> Collection<O> getConstructedCollection(Collection<I> inputs, Class<I> ci, Class<O> co) {
        try {
            return ReikaJavaLibrary.getConstructedCollection(inputs, co.getConstructor(ci));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <I, O> Collection<O> getConstructedCollection(Collection<I> inputs, Constructor<O> c) {
        ArrayList<O> outputs = new ArrayList<O>();
        try {
            for (I in : inputs) {
                O out = c.newInstance(in);
                outputs.add(out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outputs;
    }

    public static HashMap sortMapByValues(HashMap map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new MapValueSorter());
        LinkedHashMap sortedHashMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sortedHashMap;
    }

    public static <E> E[] collectionToArray(Collection<E> li) {
        Object[] arr = new Object[li.size()];
        int i = 0;
        for (E ps : li) {
            arr[i] = ps;
            ++i;
        }
        return arr;
    }

    public static <E> E getRandomListEntry(Random rand, List<E> li) {
        return li.isEmpty() ? null : (E)li.get(rand.nextInt(li.size()));
    }

    public static <E> E getRandomCollectionEntry(Random rand, Collection<E> c) {
        return c.isEmpty() ? null : (c instanceof List ? (E)ReikaJavaLibrary.getRandomListEntry(rand, (List)c) : (E)new ArrayList<E>(c).get(rand.nextInt(c.size())));
    }

    public static <E> E getAndRemoveRandomCollectionEntry(Random rand, Collection<E> c) {
        if (c instanceof List) {
            return ((List)c).remove(rand.nextInt(c.size()));
        }
        E val = ReikaJavaLibrary.getRandomCollectionEntry(rand, c);
        c.remove(val);
        return val;
    }

    public static String getTopLevelPackage(Class c) {
        String n = c.getName();
        return n.substring(0, n.indexOf(46));
    }

    public static <E> Collection<E> getCompoundCollection(Collection<Collection<E>> colls) {
        ArrayList<E> c = new ArrayList<E>();
        for (Collection<E> c2 : colls) {
            c.addAll(c2);
        }
        return c;
    }

    public static boolean isAnyModLoaded(ModList[] mods) {
        for (int i = 0; i < mods.length; ++i) {
            if (!mods[i].isLoaded()) continue;
            return true;
        }
        return false;
    }

    public static boolean removeValuesFromMap(Map map, Object value) {
        boolean flag = false;
        while (map.values().contains(value)) {
            flag |= map.values().remove(value);
        }
        return flag;
    }

    public static int getNestedMapSize(Map map) {
        int s = 0;
        for (Object k : map.keySet()) {
            Object o = map.get(k);
            s += o instanceof Map ? ((Map)o).size() : 1;
        }
        return s;
    }

    public static <V> Collection<V> getValuesForMapOfMaps(Map<?, Map<?, V>> map) {
        ArrayList<V> li = new ArrayList<V>();
        for (Object k : map.keySet()) {
            Map<?, V> o = map.get(k);
            li.addAll(o.values());
        }
        return li;
    }

    public static <E> Collection<E> getValuesForMapOfCollections(Map<?, Collection<E>> map) {
        ArrayList<E> li = new ArrayList<E>();
        for (Object k : map.keySet()) {
            Collection<E> o = map.get(k);
            li.addAll(o);
        }
        return li;
    }

    public static void cycleList(List li, int n) {
        if (li.isEmpty()) {
            return;
        }
        boolean neg = n < 0;
        n = Math.abs(n);
        for (int i = 0; i < n; ++i) {
            Object o;
            if (neg) {
                o = li.remove(0);
                li.add(o);
                continue;
            }
            o = li.remove(li.size() - 1);
            li.add(0, o);
        }
    }

    public static void cycleLinkedList(LinkedList li, int n) {
        if (li.isEmpty()) {
            return;
        }
        boolean neg = n < 0;
        n = Math.abs(n);
        for (int i = 0; i < n; ++i) {
            Object o;
            if (neg) {
                o = li.removeFirst();
                li.addLast(o);
                continue;
            }
            o = li.removeLast();
            li.addFirst(o);
        }
    }

    public static <V> Collection<V> combineCollections(Collection<V> ... colls) {
        ArrayList<V> ret = new ArrayList<V>();
        for (int i = 0; i < colls.length; ++i) {
            ret.addAll(colls[i]);
        }
        return ret;
    }

    public static <E> Set<E> getSet(E ... elements) {
        return new HashSet<E>(Arrays.asList(elements));
    }

    public static Thread getThreadByName(String name) {
        ThreadGroup tg = ReikaJavaLibrary.getTopLevelThreadGroup();
        Thread[] all = new Thread[tg.activeCount()];
        tg.enumerate(all, true);
        for (int i = 0; i < all.length; ++i) {
            Thread t = all[i];
            String n = t.getName();
            if (n == null || !n.equals(name)) continue;
            return t;
        }
        return null;
    }

    public static ThreadGroup getTopLevelThreadGroup() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        return tg;
    }

    public static boolean exceptionMentions(Throwable e, Class c) {
        StackTraceElement[] arr = e.getStackTrace();
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].getClassName().equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    public static <K> void subtractFromIntMap(Map<K, Integer> map, K key, int num) {
        Integer get = map.get(key);
        int ret = (get != null ? get : 0) - num;
        map.put(key, ret);
    }

    public static <K> void addToIntMap(Map<K, Integer> map, K key, int num) {
        Integer get = map.get(key);
        int ret = (get != null ? get : 0) + num;
        map.put(key, ret);
    }

    public static Collection<Class> getAllClassesFromPackage(String pack) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ArrayList<Class> li = new ArrayList<Class>();
        for (ClassPath.ClassInfo info : ClassPath.from((ClassLoader)loader).getTopLevelClasses()) {
            if (!info.getName().startsWith(pack)) continue;
            Class c = info.load();
            li.add(c);
        }
        return li;
    }

    public static char getIDChar(int id) {
        return IDChars[id % IDChars.length];
    }

    public static int[] splitLong(long val) {
        int l1 = (int)(val >>> 32);
        int l2 = (int)(val & 0xFFFFFFFFL);
        return new int[]{l1, l2};
    }

    public static long buildLong(int l1, int l2) {
        return (long)l1 << 32 | (long)l2 & 0xFFFFFFFFL;
    }

    public static String getClassLocation(Class c) {
        String ret = c.getResource(c.getSimpleName() + ".class").toString();
        ret = ret.substring("file:\\".length());
        ret = ret.replaceAll("%20", " ");
        return ret;
    }

    public static class ReverseComparator
    implements Comparator<Comparable> {
        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o2.compareTo(o1);
        }
    }

    private static class MapValueSorter<V>
    implements Comparator<Map.Entry<V, Comparable>> {
        private MapValueSorter() {
        }

        @Override
        public int compare(Map.Entry<V, Comparable> o1, Map.Entry<V, Comparable> o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

