/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.Exception.VanillaIntegrityException;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraftforge.classloading.FMLForgePlugin;

public class ReikaObfuscationHelper {
    private static final boolean deobf = ReikaObfuscationHelper.testDeobf();
    private static final HashMap<String, Method> methods = new HashMap();
    private static final HashMap<String, Field> fields = new HashMap();
    private static final HashMap<String, String> labels = new HashMap();

    private static boolean testDeobf() {
        return !FMLForgePlugin.RUNTIME_DEOBF;
    }

    public static boolean isDeObfEnvironment() {
        return deobf;
    }

    public static Field getField(String deobf) {
        return fields.get(deobf);
    }

    public static Method getMethod(String deobf) {
        return methods.get(deobf);
    }

    public static String getLabelName(String deobf) {
        String sg = labels.get(deobf);
        if (sg == null) {
            throw new IllegalArgumentException("Tried to get obfuscated name for non-mapped deobf field/method " + deobf + "!");
        }
        if (ReikaObfuscationHelper.isDeObfEnvironment()) {
            return deobf;
        }
        return sg;
    }

    private static void addField(String deobf, String obf, boolean isVisible, Class c) {
        try {
            Field f;
            String sg;
            String string = sg = ReikaObfuscationHelper.isDeObfEnvironment() ? deobf : obf;
            if (isVisible) {
                f = c.getField(sg);
            } else {
                f = c.getDeclaredField(sg);
                f.setAccessible(true);
            }
            fields.put(deobf, f);
            labels.put(deobf, obf);
            ReikaJavaLibrary.pConsole("DRAGONAPI: Registering reflexive field access to " + c + "." + deobf + " (obfuscated as " + obf + ")");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Tried to register nonexistent field " + deobf + "/" + obf, e);
        }
    }

    private static void addMethod(String deobf, String obf, boolean isVisible, Class c, Class ... args) {
        try {
            Method m;
            String sg;
            String string = sg = ReikaObfuscationHelper.isDeObfEnvironment() ? deobf : obf;
            if (isVisible) {
                m = c.getMethod(sg, args);
            } else {
                m = c.getDeclaredMethod(sg, args);
                m.setAccessible(true);
            }
            methods.put(deobf, m);
            labels.put(deobf, obf);
            ReikaJavaLibrary.pConsole("DRAGONAPI: Registering reflexive method access to " + c + "." + deobf + " (obfuscated as " + obf + ")");
        }
        catch (NoSuchMethodException e) {
            throw new VanillaIntegrityException(deobf, c, args);
        }
    }

    private static boolean isClientSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    static {
        ReikaObfuscationHelper.addMethod("dropFewItems", "func_70628_a", false, EntityLivingBase.class, Boolean.TYPE, Integer.TYPE);
        ReikaObfuscationHelper.addMethod("dropEquipment", "func_82160_b", false, EntityLivingBase.class, Boolean.TYPE, Integer.TYPE);
        ReikaObfuscationHelper.addMethod("dropRareDrop", "func_70600_l", false, EntityLivingBase.class, Integer.TYPE);
        ReikaObfuscationHelper.addMethod("jump", "func_70664_aZ", false, EntityLivingBase.class, new Class[0]);
        if (ReikaObfuscationHelper.isClientSide()) {
            ReikaObfuscationHelper.addMethod("getInputStreamByName", "func_110591_a", false, AbstractResourcePack.class, String.class);
        }
        ReikaObfuscationHelper.addField("potionTypes", "field_76425_a", true, Potion.class);
        if (ReikaObfuscationHelper.isClientSide()) {
            // empty if block
        }
    }
}

