/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;

public class ReikaRandomHelper
extends DragonAPICore {
    public static int getSafeRandomInt(int val) {
        return val > 1 ? rand.nextInt(val) : 0;
    }

    public static double getRandomPlusMinus(double base, double range) {
        double add = -range + rand.nextDouble() * range * 2.0;
        return base + add;
    }

    public static int getRandomPlusMinus(int base, int range) {
        int add = -range + rand.nextInt(range * 2 + 1);
        return base + add;
    }

    public static boolean doWithChance(double num) {
        if (num >= 100.0) {
            return true;
        }
        if (num > 1.0) {
            num /= 100.0;
        }
        if (num >= 1.0) {
            return true;
        }
        if (num <= 0.0) {
            return false;
        }
        if (num < 1.0E-14) {
            return rand.nextDouble() * 1.0E13 < num * 1.0E13;
        }
        return rand.nextDouble() < num;
    }

    public static short getRandomShort(int max) {
        int lim = max > 0 ? Math.min(max, 32768) : 32768;
        return (short)rand.nextInt(lim);
    }

    public static short getRandomShort() {
        return ReikaRandomHelper.getRandomShort(32768);
    }

    public static byte getRandomByte(int max) {
        int lim = max > 0 ? Math.min(max, 128) : 128;
        return (byte)rand.nextInt(lim);
    }

    public static byte getRandomByte() {
        return ReikaRandomHelper.getRandomByte(128);
    }

    public static int getLinearRandom(int n) {
        WeightedRandom<Integer> r = new WeightedRandom<Integer>();
        for (int i = 0; i < n; ++i) {
            r.addEntry(i, i + 1);
        }
        return (Integer)r.getRandomEntry();
    }

    public static int getInverseLinearRandom(int n) {
        WeightedRandom<Integer> r = new WeightedRandom<Integer>();
        for (int i = 0; i < n; ++i) {
            r.addEntry(n - i - 1, i + 1);
        }
        return (Integer)r.getRandomEntry();
    }

    public static String generateRandomString(int len) {
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (byte)(32 + rand.nextInt(95));
        }
        return new String(b);
    }

    public static DecimalPosition getRandomSphericalPosition(double x, double y, double z, int r) {
        double dr = rand.nextDouble() * (double)r;
        double[] d = ReikaPhysicsHelper.polarToCartesian(dr, rand.nextInt(360), rand.nextInt(360));
        return new DecimalPosition(x + d[0], y + d[1], z + d[2]);
    }

    public static int getRandomBetween(int min, int max) {
        return min + rand.nextInt(1 + max - min);
    }

    public static double getRandomBetween(double min, double max) {
        return min + rand.nextDouble() * (max - min);
    }
}

