/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaTimeHelper;
import net.minecraft.util.EnumChatFormatting;

public enum Isotopes {
    C14(5730.0, ReikaTimeHelper.YEAR, "Carbon-14"),
    U235(7.04E8, ReikaTimeHelper.YEAR, "Uranium-235"),
    U238(4.468E9, ReikaTimeHelper.YEAR, "Uranium-238"),
    Pu239(2410.0, ReikaTimeHelper.YEAR, "Plutonium-239", true),
    Pu244(8.08E7, ReikaTimeHelper.YEAR, "Plutonium-244"),
    Th232(1.405E10, ReikaTimeHelper.YEAR, "Thorium-232"),
    Rn222(3.8235, ReikaTimeHelper.DAY, "Radon-222", true),
    Ra226(1601.0, ReikaTimeHelper.YEAR, "Radium-226", true),
    Sr90(28.9, ReikaTimeHelper.YEAR, "Strontium-90", true),
    Po210(138.376, ReikaTimeHelper.DAY, "Polonium-210", true),
    Cs134(2.065, ReikaTimeHelper.YEAR, "Cesium-134"),
    Xe135(6.57, ReikaTimeHelper.HOUR, "Xenon-135"),
    Zr93(1530000.0, ReikaTimeHelper.YEAR, "Zirconium-93"),
    Mo99(65.94, ReikaTimeHelper.HOUR, "Molybdenum-99"),
    Cs137(30.17, ReikaTimeHelper.YEAR, "Cesium-137", true),
    Tc99(211000.0, ReikaTimeHelper.YEAR, "Technetium-99"),
    I131(8.02, ReikaTimeHelper.DAY, "Iodine-131", true),
    Pm147(2.62, ReikaTimeHelper.YEAR, "Promethium-147"),
    I129(1.57E7, ReikaTimeHelper.YEAR, "Iodine-129"),
    Sm151(90.0, ReikaTimeHelper.YEAR, "Samarium-151"),
    Ru106(373.6, ReikaTimeHelper.DAY, "Ruthenium-106"),
    Kr85(10.78, ReikaTimeHelper.YEAR, "Krypton-85"),
    Pd107(6500000.0, ReikaTimeHelper.YEAR, "Palladium-107"),
    Se79(327000.0, ReikaTimeHelper.YEAR, "Selenium-79"),
    Gd155(4.76, ReikaTimeHelper.YEAR, "Gadolinium-155"),
    Sb125(2.76, ReikaTimeHelper.YEAR, "Antimony-125"),
    Sn126(230000.0, ReikaTimeHelper.YEAR, "Tin-126"),
    Xe136(1.0E22, ReikaTimeHelper.YEAR, "Xenon-136"),
    I135(6.6, ReikaTimeHelper.HOUR, "Iodine-135"),
    Xe131(12.0, ReikaTimeHelper.DAY, "Xenon-131"),
    Ru103(1.69, ReikaTimeHelper.TICK, "Ruthenium-103"),
    Pm149(53.08, ReikaTimeHelper.HOUR, "Promethium-149"),
    Rh105(35.36, ReikaTimeHelper.HOUR, "Rhodium-105");

    private double half;
    private ReikaTimeHelper base;
    private String name;
    private boolean danger;
    private static final Isotopes[] isoList;

    private Isotopes(double t, ReikaTimeHelper time, String n2) {
        this(t, time, n2, false);
    }

    private Isotopes(double t, ReikaTimeHelper time, String n2, boolean d) {
        this.half = t;
        this.base = time;
        this.name = n2;
        this.danger = d;
    }

    public static Isotopes getIsotope(int i) {
        return isoList[i];
    }

    public static int getNumberIsotopes() {
        return isoList.length;
    }

    public double getHalfLife() {
        return this.half * (double)this.base.getDuration();
    }

    public double getMCHalfLife() {
        return this.half * (double)this.base.getMinecraftDuration();
    }

    public boolean isExtraDangerous() {
        return this.danger;
    }

    public String toString() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.danger) {
            return EnumChatFormatting.RED.toString() + this.name;
        }
        return this.name;
    }

    public String getHalfLifeAsDisplay() {
        return String.format("%.3f%s%s", ReikaMathLibrary.getThousandBase(this.half), ReikaEngLibrary.getSIPrefix(this.half), this.base.getAbbreviation());
    }

    static {
        isoList = Isotopes.values();
    }
}

