/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.IFluidBlock;

public final class ReikaPhysicsHelper
extends DragonAPICore {
    public static final double TNTenergy = 1.242E10;
    public static final double g = 9.81;
    public static final double LIGHT_SPEED = 2.99792458E8;
    public static final double ELECTRON_CHARGE = 1.602 / ReikaMathLibrary.doubpow(10.0, 19.0);
    public static final double ELECTRON_MASS = 9.11 / ReikaMathLibrary.doubpow(10.0, 31.0);
    public static final double NEUTRON_MASS = 1.674 / ReikaMathLibrary.doubpow(10.0, 27.0);
    public static final double PROTON_MASS = 1.672 / ReikaMathLibrary.doubpow(10.0, 27.0);
    private static final Interpolation tempColorList = new Interpolation(true);

    public static double[] polarToCartesian(double mag, double theta, double phi) {
        double[] coords = new double[3];
        theta = ReikaPhysicsHelper.degToRad(theta);
        phi = ReikaPhysicsHelper.degToRad(phi);
        coords[0] = mag * Math.cos(theta) * Math.cos(phi);
        coords[1] = mag * Math.sin(theta);
        coords[2] = mag * Math.cos(theta) * Math.sin(phi);
        return coords;
    }

    public static double[] cartesianToPolar(double x, double y, double z) {
        double[] coords = new double[3];
        boolean is90to270 = false;
        coords[0] = ReikaMathLibrary.py3d(x, y, z);
        coords[1] = Math.acos(y / coords[0]);
        coords[2] = Math.atan2(x, z);
        coords[1] = ReikaPhysicsHelper.radToDeg(coords[1]);
        coords[2] = 180.0 + ReikaPhysicsHelper.radToDeg(coords[2]);
        if (is90to270) {
            coords[2] = coords[2] * -1.0;
        }
        return coords;
    }

    public static double degToRad(double ang) {
        return ang * Math.PI / 180.0;
    }

    public static double radToDeg(double ang) {
        return ang * 180.0 / Math.PI;
    }

    public static double[] targetPosn(double x, double y, double z, double x2, double y2, double z2, double ag) {
        double[] v = new double[3];
        double[] target = new double[]{x2, y2, z2};
        double dx = target[0] - x - 0.5;
        double dy = target[1] - y - 1.0;
        double dz = target[2] - z - 0.5;
        double dl = ReikaMathLibrary.py3d(dx, 0.0, dz);
        double g = 8.4695 * ReikaMathLibrary.doubpow(dl, 0.2701);
        if (dy > 0.0) {
            g *= 0.8951 * ReikaMathLibrary.doubpow(dy, 0.0601);
        }
        double velocity = 10.0;
        int theta = 0;
        int phi = (int)Math.toDegrees(Math.atan2(dz, dx));
        while (theta <= 0) {
            double s = ReikaMathLibrary.intpow(velocity += 1.0, 4) - g * (g * dl * dl + 2.0 * dy * velocity * velocity);
            double a = velocity * velocity + Math.sqrt(s);
            theta = (int)Math.toDegrees(Math.atan(a / (g * dl)));
            phi = (int)Math.toDegrees(Math.atan2(dz, dx));
        }
        v = ReikaPhysicsHelper.polarToCartesian(velocity, theta, phi);
        return v;
    }

    public static double inverseSquare(double dx, double dy, double dz, double mag) {
        return mag / (dx * dx + dy * dy + dz * dz);
    }

    public static float getExplosionFromEnergy(double energy) {
        double ratio = energy / 1.242E10;
        return (float)(4.0 * ratio);
    }

    public static float getEnergyFromExplosion(float ex) {
        return ex / 4.0f * 1.242E10f;
    }

    public static double getBlockDensity(Block b) {
        if (b == Blocks.field_150350_a) {
            return 1.0;
        }
        if (b == Blocks.field_150340_R) {
            return 19300.0;
        }
        if (b == Blocks.field_150339_S) {
            return 7800.0;
        }
        if (b == Blocks.field_150484_ah) {
            return 3500.0;
        }
        if (b == Blocks.field_150475_bE) {
            return 2740.0;
        }
        if (b == Blocks.field_150368_y) {
            return 2800.0;
        }
        if (b == Blocks.field_150351_n) {
            return 1680.0;
        }
        if (b instanceof IFluidBlock) {
            return ((IFluidBlock)b).getFluid().getDensity();
        }
        if (b.func_149688_o() == Material.field_151576_e) {
            return 3000.0;
        }
        if (b.func_149688_o() == Material.field_151592_s) {
            return 3000.0;
        }
        if (b.func_149688_o() == Material.field_151577_b) {
            return 1250.0;
        }
        if (b.func_149688_o() == Material.field_151578_c) {
            return 1220.0;
        }
        if (b.func_149688_o() == Material.field_151571_B) {
            return 1650.0;
        }
        if (b.func_149688_o() == Material.field_151595_p) {
            return 1555.0;
        }
        if (b.func_149688_o() == Material.field_151575_d) {
            return 800.0;
        }
        if (b.func_149688_o() == Material.field_151584_j) {
            return 100.0;
        }
        if (b.func_149688_o() == Material.field_151583_m) {
            return 280.0;
        }
        if (b.func_149688_o() == Material.field_151585_k) {
            return 100.0;
        }
        if (b.func_149688_o() == Material.field_151589_v) {
            return 100.0;
        }
        if (b.func_149688_o() == Material.field_151580_n) {
            return 1314.0;
        }
        if (b.func_149688_o() == Material.field_151573_f) {
            return 7800.0;
        }
        if (b.func_149688_o() == Material.field_151586_h) {
            return 1000.0;
        }
        if (b.func_149688_o() == Material.field_151587_i) {
            return 2700.0;
        }
        if (b.func_149688_o() == Material.field_151588_w) {
            return 917.0;
        }
        return 2200.0;
    }

    public static double getProjectileVelocity(double dist, double ang, double dy, double gravity) {
        ang = Math.toRadians(ang);
        double denom = dist * Math.tan(ang) + dy;
        double root = Math.sqrt(0.5 * gravity * dist * dist / denom);
        return root / Math.cos(ang);
    }

    public static double getProjectileRange(double vel, double ang, double dy, double gravity) {
        ang = Math.toRadians(ang);
        double root = Math.pow(vel * Math.sin(ang), 2.0) + 19.62 * dy;
        double term = vel * Math.sin(ang) + Math.sqrt(root);
        return vel * Math.cos(ang) / gravity * term;
    }

    public static void reflectEntitySpherical(double x, double y, double z, Entity e) {
        double dx = e.field_70165_t - x;
        double dy = e.field_70163_u - y;
        double dz = e.field_70161_v - z;
        Vec3 vec = Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
        double l = vec.func_72433_c();
        vec.field_72450_a /= l;
        vec.field_72448_b /= l;
        vec.field_72449_c /= l;
        double vel = vec.func_72430_b(Vec3.func_72443_a((double)e.field_70159_w, (double)e.field_70181_x, (double)e.field_70179_y));
        e.field_70159_w += -2.0 * vel * vec.field_72450_a;
        e.field_70181_x += -2.0 * vel * vec.field_72448_b;
        e.field_70179_y += -2.0 * vel * vec.field_72449_c;
        e.field_70133_I = true;
    }

    public static int getColorForTemperature(int temp) {
        return (int)tempColorList.getValue(temp);
    }

    static {
        tempColorList.addPoint(500.0, 0.0);
        tempColorList.addPoint(700.0, 1.0223616E7);
        tempColorList.addPoint(1700.0, 1.671168E7);
        tempColorList.addPoint(2700.0, 1.6751616E7);
        tempColorList.addPoint(3700.0, 1.677696E7);
        tempColorList.addPoint(5700.0, 1.6777215E7);
        tempColorList.addPoint(9700.0, 5686527.0);
    }
}

