/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Registry;

import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public enum ReikaDyeHelper {
    BLACK(0x191919),
    RED(0x993333),
    GREEN(6717235),
    BROWN(6704179),
    BLUE(3361970),
    PURPLE(8339378),
    CYAN(5013401),
    LIGHTGRAY(0x999999, "Light Gray"),
    GRAY(0x4C4C4C),
    PINK(15892389),
    LIME(8375321),
    YELLOW(0xE5E533),
    LIGHTBLUE(6724056, "Light Blue"),
    MAGENTA(11685080),
    ORANGE(14188339),
    WHITE(0xFFFFFF);

    public final int color;
    public final String colorName;
    public final String colorNameNoSpaces;
    private static final Random rand;
    public static final ReikaDyeHelper[] dyes;
    private static final HashMap<ReikaDyeHelper, ArrayList<ItemStack>> oreDict;
    private static final HashMap<ItemStack, ReikaDyeHelper> oreDict2;

    private ReikaDyeHelper(int c) {
        this.color = c;
        this.colorName = ReikaStringParser.capFirstChar(this.name());
        this.colorNameNoSpaces = ReikaStringParser.stripSpaces(this.colorName);
    }

    private ReikaDyeHelper(int c, String n2) {
        this.color = c;
        this.colorName = n2;
        this.colorNameNoSpaces = ReikaStringParser.stripSpaces(n2);
    }

    public static ReikaDyeHelper getByName(String s) {
        return ReikaDyeHelper.valueOf(s.toUpperCase(Locale.ENGLISH).replaceAll(" ", ""));
    }

    public static boolean isDyeItem(ItemStack is) {
        return ReikaDyeHelper.getColorFromItem(is) != null;
    }

    public static ReikaDyeHelper getColorFromItem(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (is.func_77973_b() == Items.field_151100_aR) {
            return ReikaDyeHelper.getColorFromDamage(is.func_77960_j());
        }
        return ReikaDyeHelper.getDyeByOreDictionary(is);
    }

    private static ReikaDyeHelper getDyeByOreDictionary(ItemStack is) {
        ReikaDyeHelper color = oreDict2.get(is);
        if (color != null) {
            return color;
        }
        for (int i = 0; i < dyes.length; ++i) {
            ReikaDyeHelper dye = dyes[i];
            String name = dye.getOreDictName();
            ArrayList li = OreDictionary.getOres((String)name);
            if (!ReikaItemHelper.collectionContainsItemStack(li, is)) continue;
            ReikaDyeHelper.addItemMapping(dye, is);
            return dye;
        }
        return null;
    }

    private static void addItemMapping(ReikaDyeHelper dye, ItemStack is) {
        ArrayList<Object> li = oreDict.get((Object)dye);
        if (li == null) {
            li = new ArrayList();
            oreDict.put(dye, li);
        }
        li.add(is);
        oreDict2.put(is, dye);
    }

    public static ReikaDyeHelper getColorFromDamage(int damage) {
        return damage >= 0 && damage < dyes.length ? dyes[damage] : BLACK;
    }

    public static ReikaDyeHelper getRandomColor() {
        return ReikaDyeHelper.getColorFromDamage(rand.nextInt(16));
    }

    public int getDamage() {
        return this.ordinal();
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor() {
        return ReikaTextureHelper.isDefaultResourcePack() ? this.color : this.getColorOverride();
    }

    @SideOnly(value=Side.CLIENT)
    public int getDefaultColor() {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    private int getColorOverride() {
        return ReikaTextureHelper.getColorOverride(this);
    }

    @SideOnly(value=Side.CLIENT)
    public Color getJavaColor() {
        return Color.decode(String.valueOf(this.getColor()));
    }

    @SideOnly(value=Side.CLIENT)
    public int getRed() {
        return this.getJavaColor().getRed();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlue() {
        return this.getJavaColor().getBlue();
    }

    @SideOnly(value=Side.CLIENT)
    public int getGreen() {
        return this.getJavaColor().getGreen();
    }

    public int getWoolMeta() {
        return 15 - this.getDamage();
    }

    public ItemStack getStackOf() {
        return new ItemStack(Items.field_151100_aR, 1, this.getDamage());
    }

    public ItemStack getWoolStack() {
        return new ItemStack(Blocks.field_150325_L, 1, this.getWoolMeta());
    }

    @SideOnly(value=Side.CLIENT)
    public double[] getRedstoneParticleVelocityForColor() {
        if (this == WHITE) {
            return new double[]{20.0, 20.0, 20.0};
        }
        double[] c = new double[]{(double)this.getRed() / 255.0, (double)this.getGreen() / 255.0, (double)this.getBlue() / 255.0};
        return c;
    }

    public String getOreDictName() {
        return "dye" + ReikaStringParser.stripSpaces(this.colorName);
    }

    @SideOnly(value=Side.CLIENT)
    public void setGLColorBlend() {
        Color c = this.getJavaColor();
        GL11.glColor3d((double)((double)this.getRed() / 255.0), (double)((double)this.getGreen() / 255.0), (double)((double)this.getBlue() / 255.0));
    }

    static {
        rand = new Random();
        dyes = ReikaDyeHelper.values();
        oreDict = new HashMap();
        oreDict2 = new HashMap();
    }
}

