/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Registry;

import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public enum ReikaPlantHelper {
    SAPLING(Blocks.field_150345_g),
    SUGARCANE(Blocks.field_150436_aH),
    CACTUS(Blocks.field_150434_aF),
    MUSHROOM(new Block[]{Blocks.field_150338_P, Blocks.field_150337_Q}),
    FLOWER(new Block[]{Blocks.field_150328_O, Blocks.field_150327_N}),
    TALLGRASS(new Block[]{Blocks.field_150329_H}),
    BUSH(new Block[]{Blocks.field_150330_I}),
    CROP(Blocks.field_150464_aj, Blocks.field_150459_bM, Blocks.field_150469_bN, Blocks.field_150394_bc, Blocks.field_150393_bb),
    NETHERWART(Blocks.field_150388_bm),
    LILYPAD(Blocks.field_150392_bi),
    VINES(Blocks.field_150395_bd);

    private List<Block> ids = new ArrayList<Block>();
    public static final ReikaPlantHelper[] plantList;
    private static final HashMap<Block, ReikaPlantHelper> plantMappings;

    private ReikaPlantHelper(Block ... blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            this.ids.add(blocks[i]);
        }
    }

    public static ReikaPlantHelper getPlant(Block id) {
        return plantMappings.get(id);
    }

    public boolean canPlantAt(World world, int x, int y, int z) {
        Block idbelow = world.func_147439_a(x, y - 1, z);
        int metabelow = world.func_72805_g(x, y - 1, z);
        Material matbelow = ReikaWorldHelper.getMaterial(world, x, y - 1, z);
        switch (this) {
            case CACTUS: {
                return idbelow == Blocks.field_150354_m;
            }
            case FLOWER: {
                return ReikaBlockHelper.isDirtType(idbelow, metabelow);
            }
            case MUSHROOM: {
                return idbelow == Blocks.field_150346_d || idbelow == Blocks.field_150391_bh;
            }
            case SAPLING: {
                return ReikaBlockHelper.isDirtType(idbelow, metabelow);
            }
            case SUGARCANE: {
                if (idbelow != Blocks.field_150354_m && !ReikaBlockHelper.isDirtType(idbelow, metabelow)) {
                    return false;
                }
                ForgeDirection water = ReikaWorldHelper.checkForAdjMaterial(world, x, y - 1, z, Material.field_151586_h);
                return water != null && water.offsetY == 0;
            }
            case BUSH: {
                return idbelow == Blocks.field_150354_m;
            }
            case CROP: {
                return idbelow == Blocks.field_150458_ak;
            }
            case NETHERWART: {
                return idbelow == Blocks.field_150425_aM;
            }
            case TALLGRASS: {
                return ReikaBlockHelper.isDirtType(idbelow, metabelow);
            }
            case LILYPAD: {
                return matbelow == Material.field_151586_h && metabelow == 0;
            }
            case VINES: {
                for (int i = 1; i < 6; ++i) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                    if (!world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).func_149662_c()) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public boolean grows() {
        switch (this) {
            case CACTUS: 
            case MUSHROOM: 
            case SAPLING: 
            case SUGARCANE: 
            case CROP: 
            case NETHERWART: 
            case VINES: {
                return true;
            }
        }
        return false;
    }

    static {
        plantList = ReikaPlantHelper.values();
        plantMappings = new HashMap();
        for (int i = 0; i < plantList.length; ++i) {
            ReikaPlantHelper w = plantList[i];
            for (int k = 0; k < w.ids.size(); ++k) {
                plantMappings.put(w.ids.get(k), w);
            }
        }
    }
}

