/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.DummyTeleporter;
import Reika.DragonAPI.Interfaces.ComparableAI;
import Reika.DragonAPI.Interfaces.Entity.CustomProjectile;
import Reika.DragonAPI.Interfaces.Entity.TameHostile;
import Reika.DragonAPI.Interfaces.Item.UnbreakableArmor;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.DartItemHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import WayofTime.alchemicalWizardry.api.spell.EntitySpellProjectile;
import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import net.machinemuse.api.electricity.MuseElectricItem;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S19PacketEntityHeadLook;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public final class ReikaEntityHelper
extends DragonAPICore {
    public static final IEntitySelector hostileOrPlayerSelector = new IEntitySelector(){

        public boolean func_82704_a(Entity e) {
            return e instanceof EntityLivingBase && (e instanceof EntityPlayer || ReikaEntityHelper.isHostile((EntityLivingBase)e));
        }
    };
    public static final IEntitySelector hostileSelector = new IEntitySelector(){

        public boolean func_82704_a(Entity e) {
            return e instanceof EntityLivingBase && ReikaEntityHelper.isHostile((EntityLivingBase)e);
        }
    };
    public static final IEntitySelector nonMobSelector = new IEntitySelector(){

        public boolean func_82704_a(Entity e) {
            return !(e instanceof EntityLivingBase) || !ReikaEntityHelper.isHostile((EntityLivingBase)e);
        }
    };
    public static final IEntitySelector itemSelector = new IEntitySelector(){

        public boolean func_82704_a(Entity e) {
            return e instanceof EntityItem;
        }
    };
    public static final IEntitySelector itemOrXPSelector = new IEntitySelector(){

        public boolean func_82704_a(Entity e) {
            return e instanceof EntityItem || e instanceof EntityXPOrb;
        }
    };
    private static HashMap<Class, Integer> mobColorArray = new HashMap();
    public static boolean tameMobTargeting;
    private static EntityCreeper dummy;

    public static int mobToColor(EntityLivingBase ent) {
        Integer color = mobColorArray.get(ent.getClass());
        if (color == null) {
            color = ReikaEntityHelper.calcMobColor(ent);
            mobColorArray.put(ent.getClass(), color);
        }
        return color;
    }

    private static int calcMobColor(EntityLivingBase e) {
        Class<?> c = e.getClass();
        Class<?> s = c.getSuperclass();
        while (s != null && s != Entity.class) {
            if (mobColorArray.containsKey(s)) {
                int clr = mobColorArray.get(s);
                clr = ReikaColorAPI.getColorWithBrightnessMultiplier(clr, (float)ReikaRandomHelper.getRandomBetween(0.25, 1.0));
                return clr;
            }
            c = s;
            s = c.getSuperclass();
        }
        return 0xFFFFFF;
    }

    public static boolean isHostile(EntityLivingBase mob) {
        if (mob instanceof TameHostile) {
            return false;
        }
        if (mob instanceof EntityMob) {
            return true;
        }
        if (mob instanceof IMob) {
            return true;
        }
        if (mob instanceof EntityGhast) {
            return true;
        }
        if (mob instanceof EntitySlime) {
            return true;
        }
        if (mob instanceof EntityWitch) {
            return true;
        }
        if (mob instanceof EntityDragon) {
            return true;
        }
        if (mob instanceof EntityWither) {
            return true;
        }
        String n = mob.getClass().getName().toLowerCase(Locale.ENGLISH);
        if (n.contains("wisp")) {
            return true;
        }
        if (n.contains("pech")) {
            return true;
        }
        return n.contains("botania") && n.contains("doppleganger");
    }

    public static boolean isHostile(Class<? extends EntityLiving> mob) {
        if (TameHostile.class.isAssignableFrom(mob)) {
            return false;
        }
        if (EntityMob.class.isAssignableFrom(mob)) {
            return true;
        }
        if (EntityGhast.class.isAssignableFrom(mob)) {
            return true;
        }
        if (EntitySlime.class.isAssignableFrom(mob)) {
            return true;
        }
        if (EntityWitch.class.isAssignableFrom(mob)) {
            return true;
        }
        if (EntityDragon.class.isAssignableFrom(mob)) {
            return true;
        }
        if (EntityWither.class.isAssignableFrom(mob)) {
            return true;
        }
        if (mob.getSimpleName().toLowerCase(Locale.ENGLISH).contains("wisp")) {
            return true;
        }
        return mob.getSimpleName().toLowerCase(Locale.ENGLISH).contains("pech");
    }

    public static int mobNameToID(String name) {
        return (Integer)EntityList.field_75622_f.get(name);
    }

    public static Class mobNameToClass(String name) {
        return (Class)EntityList.field_75625_b.get(name);
    }

    public static int getNumberMobsInMC(World world) {
        int i;
        int highestid = 0;
        int numberentities = EntityList.field_75623_d.size();
        Object[] entityKeys = EntityList.field_75623_d.keySet().toArray();
        int[] entityIDs = new int[entityKeys.length];
        for (i = 0; i < entityKeys.length; ++i) {
            entityIDs[i] = Integer.valueOf(String.valueOf(entityKeys[i]));
        }
        for (i = 0; i < entityIDs.length; ++i) {
            if (entityIDs[i] <= highestid) continue;
            highestid = entityIDs[i];
        }
        int numbermobs = 0;
        for (int id = 0; id <= highestid; ++id) {
            Entity ent;
            if (!EntityList.field_75623_d.containsKey(id) || id == 48 || id == 49 || !((ent = EntityList.func_75616_a((int)id, (World)world)) instanceof EntityLivingBase)) continue;
            ++numbermobs;
        }
        return numbermobs;
    }

    public static double getEntityMass(Entity ent) {
        if (ent instanceof EntityItem || ent instanceof EntityXPOrb) {
            return 0.25;
        }
        if (ent instanceof EntityCreeper) {
            return 100.0;
        }
        if (ent instanceof EntitySkeleton) {
            return 30.0;
        }
        if (ent instanceof EntityZombie || ent instanceof EntityPlayer || ent instanceof EntityVillager || ent instanceof EntityWitch) {
            return 70.0;
        }
        if (ent instanceof EntityPigZombie) {
            return 90.0;
        }
        if (ent instanceof EntitySpider) {
            return 60.0;
        }
        if (ent instanceof EntityPig) {
            return 100.0;
        }
        if (ent instanceof EntityCow || ent instanceof EntityMooshroom) {
            return 350.0;
        }
        if (ent instanceof EntityGhast) {
            return 20.0;
        }
        if (ent instanceof EntityBlaze) {
            return 300.0;
        }
        if (ent instanceof EntityMagmaCube) {
            EntityMagmaCube cube = (EntityMagmaCube)ent;
            return 400 * cube.func_70809_q() * cube.func_70809_q();
        }
        if (ent instanceof EntitySlime) {
            EntitySlime cube = (EntitySlime)ent;
            return 200 * cube.func_70809_q() * cube.func_70809_q();
        }
        if (ent instanceof EntityEnderman) {
            return 40.0;
        }
        if (ent instanceof EntitySilverfish) {
            return 1.0;
        }
        if (ent instanceof EntityChicken) {
            return 2.0;
        }
        if (ent instanceof EntityCaveSpider) {
            return 30.0;
        }
        if (ent instanceof EntityDragon) {
            return 10000.0;
        }
        if (ent instanceof EntityWither) {
            return 3000.0;
        }
        if (ent instanceof EntityWolf) {
            return 50.0;
        }
        if (ent instanceof EntityOcelot) {
            return 15.0;
        }
        if (ent instanceof EntityIronGolem) {
            return 32000.0;
        }
        if (ent instanceof EntityGolem) {
            return 100.0;
        }
        if (ent instanceof EntitySheep) {
            return 150.0;
        }
        if (ent instanceof EntitySquid) {
            return 120.0;
        }
        if (ent instanceof EntityBat) {
            return 0.5;
        }
        if (ent instanceof EntityMinecart) {
            return 400.0;
        }
        if (ent instanceof EntityBoat) {
            return 70.0;
        }
        if (ent instanceof EntityTNTPrimed) {
            return 2700.0;
        }
        if (ent instanceof EntityFallingBlock) {
            return 2000.0;
        }
        return 100.0;
    }

    public static ItemStack getBreedItem(EntityAnimal e) {
        if (e instanceof EntitySheep) {
            return new ItemStack(Items.field_151015_O);
        }
        if (e instanceof EntityCow) {
            return new ItemStack(Items.field_151015_O);
        }
        if (e instanceof EntityPig) {
            return new ItemStack(Items.field_151172_bF);
        }
        if (e instanceof EntityChicken) {
            return new ItemStack(Items.field_151014_N);
        }
        if (e instanceof EntityWolf) {
            return new ItemStack(Items.field_151147_al);
        }
        if (e instanceof EntityOcelot) {
            return new ItemStack(Items.field_151115_aP);
        }
        return null;
    }

    public static boolean isHearingRange(long freq, EntityLivingBase ent) {
        if (ent instanceof EntityPlayer || ent instanceof EntityWitch || ent instanceof EntityZombie) {
            if (freq < 20L) {
                return false;
            }
            if (freq > 20000L) {
                return false;
            }
        }
        if (ent instanceof EntitySlime) {
            return false;
        }
        if (ent instanceof EntityZombie || ent instanceof EntitySkeleton) {
            if (freq < 20L) {
                return false;
            }
            if (freq > 5000L) {
                return false;
            }
        }
        if (ent instanceof EntitySpider) {
            if (freq < 1000L) {
                return false;
            }
            if (freq > 100000L) {
                return false;
            }
        }
        if (ent instanceof EntityCreeper) {
            if (freq < 500L) {
                return false;
            }
            if (freq > 40000L) {
                return false;
            }
        }
        if (ent instanceof EntityGhast) {
            if (freq < 200L) {
                return false;
            }
            if (freq > 10000L) {
                return false;
            }
        }
        if (ent instanceof EntityPigZombie) {
            if (freq < 64L) {
                return false;
            }
            if (freq > 5000L) {
                return false;
            }
        }
        if (ent instanceof EntityEnderman) {
            if (freq < 5L) {
                return false;
            }
            if (freq > 2000L) {
                return false;
            }
        }
        if (ent instanceof EntityBlaze && freq > 500L) {
            return false;
        }
        if (ent instanceof EntitySilverfish) {
            if (freq < 1000L) {
                return false;
            }
            if (freq > 35000L) {
                return false;
            }
        }
        if (ent instanceof EntityDragon) {
            if (freq < 5L) {
                return false;
            }
            if (freq > 8000L) {
                return false;
            }
        }
        if (ent instanceof EntityWither) {
            if (freq < 2L) {
                return false;
            }
            if (freq > 10000L) {
                return false;
            }
        }
        if (ent instanceof EntityPig) {
            if (freq < 64L) {
                return false;
            }
            if (freq > 32000L) {
                return false;
            }
        }
        if (ent instanceof EntityCow || ent instanceof EntityMooshroom) {
            if (freq < 23L) {
                return false;
            }
            if (freq > 35000L) {
                return false;
            }
        }
        if (ent instanceof EntityChicken) {
            if (freq < 125L) {
                return false;
            }
            if (freq > 2000L) {
                return false;
            }
        }
        if (ent instanceof EntitySheep) {
            if (freq < 100L) {
                return false;
            }
            if (freq > 30000L) {
                return false;
            }
        }
        if (ent instanceof EntityBat) {
            if (freq < 2000L) {
                return false;
            }
            if (freq > 110000L) {
                return false;
            }
        }
        if (ent instanceof EntityOcelot) {
            if (freq < 45L) {
                return false;
            }
            if (freq > 64000L) {
                return false;
            }
        }
        if (ent instanceof EntityWolf) {
            if (freq < 67L) {
                return false;
            }
            if (freq > 45000L) {
                return false;
            }
        }
        return !(ent instanceof EntitySquid) || freq <= 500L;
    }

    public static void knockbackEntity(Entity a, Entity b, double power) {
        ReikaEntityHelper.knockbackEntityFromPos(a.field_70165_t, a.field_70163_u, a.field_70161_v, b, power);
    }

    public static void knockbackEntityFromPos(double x, double y, double z, Entity ent, double power) {
        double dx = x - ent.field_70165_t;
        double dz = z - ent.field_70161_v;
        double dd = ReikaMathLibrary.py3d(dx, 0.0, dz);
        ent.field_70159_w -= dx / dd / 2.0 * power;
        if (ent.field_70122_E || ent.field_70163_u > y) {
            ent.field_70181_x += 0.4 * power;
        }
        ent.field_70179_y -= dz / dd / 2.0 * power;
        ent.field_70133_I = true;
    }

    public static boolean allAreDead(List mobs, boolean isDeadOnly) {
        for (int i = 0; i < mobs.size(); ++i) {
            EntityLivingBase ent = (EntityLivingBase)mobs.get(i);
            if (!(!ent.field_70128_L && ent.func_110143_aJ() > 0.0f) && (ent.field_70128_L || !isDeadOnly)) continue;
            return false;
        }
        return true;
    }

    public static void addRandomDirVelocity(Entity ent, double max) {
    }

    public static void dropHead(EntityLivingBase e) {
        if (e == null) {
            return;
        }
        ItemStack is = null;
        if (e instanceof EntitySkeleton) {
            EntitySkeleton ek = (EntitySkeleton)e;
            is = ek.func_82202_m() == 1 ? new ItemStack(Items.field_151144_bL, 1, 1) : new ItemStack(Items.field_151144_bL, 1, 0);
        }
        if (e instanceof EntityZombie && !((EntityZombie)e).func_82231_m() && !(e instanceof EntityPigZombie)) {
            is = new ItemStack(Items.field_151144_bL, 1, 2);
        }
        if (e instanceof EntityPlayer) {
            is = new ItemStack(Items.field_151144_bL, 1, 3);
        }
        if (e instanceof EntityCreeper) {
            is = new ItemStack(Items.field_151144_bL, 1, 4);
        }
        if (is == null) {
            return;
        }
        ReikaItemHelper.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u + 0.2, e.field_70161_v, is);
    }

    public static ItemStack getFoodItem(EntityLivingBase e) {
        if (e instanceof EntityCow) {
            return new ItemStack(Items.field_151082_bd);
        }
        if (e instanceof EntityPig) {
            return new ItemStack(Items.field_151147_al);
        }
        if (e instanceof EntityChicken) {
            return new ItemStack(Items.field_151076_bf);
        }
        if (e instanceof EntitySheep) {
            Item id;
            if (ModList.DARTCRAFT.isLoaded() && (id = DartItemHandler.getInstance().meatID) != null) {
                return new ItemStack(id, 1, 0);
            }
        } else {
            if (e instanceof EntityZombie) {
                return new ItemStack(Items.field_151078_bh);
            }
            if (e instanceof EntityHorse) {
                return new ItemStack(Items.field_151082_bd);
            }
        }
        return null;
    }

    public static void spawnParticlesAround(String part, Entity e, int num) {
        for (int k = 0; k < num; ++k) {
            e.field_70170_p.func_72869_a(part, e.field_70165_t - 0.6 + 1.2 * rand.nextDouble(), e.field_70163_u + (double)(e.field_70131_O / 2.0f) - 0.6 + 1.2 * rand.nextDouble(), e.field_70161_v - 0.6 + 1.2 * rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble(), 0.4 * rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble());
        }
    }

    public static int getEntityIDByClass(Class cl) {
        String name = (String)EntityList.field_75626_c.get(cl);
        return ReikaEntityHelper.mobNameToID(name);
    }

    public static int getEntityID(Entity e) {
        if (e instanceof EntityPlayer) {
            return -1;
        }
        return EntityList.func_75619_a((Entity)e);
    }

    public static boolean burnsInSun(EntityLivingBase e) {
        return e.func_70668_bt() == EnumCreatureAttribute.UNDEAD;
    }

    public static boolean isEntityWearingArmorOf(EntityLivingBase e, ItemArmor.ArmorMaterial type) {
        for (int i = 1; i <= 4; ++i) {
            ItemStack is = e.func_71124_b(i);
            if (is != null && is.func_77973_b() instanceof ItemArmor) {
                ItemArmor a = (ItemArmor)is.func_77973_b();
                if (a.func_82812_d() != type) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isEntityWearingFullSuitOf(EntityLivingBase e, ItemArmor.ArmorMaterial type) {
        for (int i = 1; i <= 4; ++i) {
            ItemStack is = e.func_71124_b(i);
            if (is != null && is.func_77973_b() instanceof ItemArmor) {
                ItemArmor a = (ItemArmor)is.func_77973_b();
                if (a.func_82812_d() == type) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static Render getEntityRenderer(Class entityClass) {
        return (Render)RenderManager.field_78727_a.field_78729_o.get(entityClass);
    }

    public static void setNoPotionParticles(EntityLivingBase e) {
        e.func_70096_w().func_75692_b(7, (Object)0);
    }

    public static void setInvulnerable(Entity e, boolean invuln) {
        NBTTagCompound NBT = new NBTTagCompound();
        e.func_70109_d(NBT);
        NBT.func_74757_a("Invulnerable", invuln);
        e.func_70020_e(NBT);
    }

    public static boolean isLivingMob(String mob, boolean allowPlayers) {
        Class c = allowPlayers ? EntityLivingBase.class : EntityLiving.class;
        return c.isAssignableFrom((Class)EntityList.field_75625_b.get(mob));
    }

    public static boolean hasID(String mob) {
        return EntityList.field_75622_f.containsKey(mob);
    }

    public static boolean hasID(Class<? extends Entity> c) {
        return EntityList.field_75624_e.containsKey(c);
    }

    public static String getEntityDisplayName(String name) {
        return StatCollector.func_74838_a((String)("entity." + name + ".name"));
    }

    public static boolean isTameHostile(String mob) {
        return TameHostile.class.isAssignableFrom((Class)EntityList.field_75625_b.get(mob));
    }

    @Deprecated
    public static void overrideEntity(Class mobClass, String name, int entityID) {
        EntityList.EntityEggInfo info = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(entityID);
        ReikaEntityHelper.removeEntityMapping(mobClass, name, entityID);
        EntityList.func_75618_a((Class)mobClass, (String)name, (int)entityID);
        if (info != null) {
            EntityList.field_75627_a.put(entityID, info);
        }
    }

    @Deprecated
    public static void removeEntityFromRegistry(Class c) {
        String s = (String)EntityList.field_75626_c.remove(c);
        int id = (Integer)EntityList.field_75622_f.remove(s);
        EntityList.field_75625_b.remove(s);
        EntityList.field_75623_d.remove(id);
        EntityList.field_75624_e.remove(c);
    }

    @Deprecated
    public static void overrideEntityAtSameID(Class oldClass, Class newClass) {
        DragonAPICore.debug("Preparing to override Entity class " + oldClass + " with " + newClass);
        String s = (String)EntityList.field_75626_c.remove(oldClass);
        int id = (Integer)EntityList.field_75622_f.remove(s);
        DragonAPICore.debug("Found ID String '" + s + "' and numerical ID " + id);
        EntityList.field_75625_b.remove(s);
        EntityList.field_75623_d.remove(id);
        EntityList.field_75624_e.remove(oldClass);
        EntityList.func_75618_a((Class)newClass, (String)s, (int)id);
        DragonAPICore.debug("ID Mapping added. Getters: " + EntityList.field_75626_c.get(newClass) + " & " + EntityList.field_75624_e.get(newClass));
    }

    @Deprecated
    private static void removeEntityMapping(Class mobClass, String name, int entityID) {
        EntityList.field_75625_b.remove(name);
        EntityList.field_75627_a.remove(entityID);
        EntityList.field_75623_d.remove(entityID);
    }

    public static EntityLivingBase getDummyMob(World world, double x, double y, double z) {
        if (dummy == null) {
            dummy = new EntityCreeper(world);
        }
        dummy.func_70012_b(x, y, z, 0.0f, 0.0f);
        return dummy;
    }

    public static void sortEntityListByDistance(List<Entity> li, double x, double y, double z) {
        Collections.sort(li, new EntityDistanceComparator(x, y, z));
    }

    public static boolean isBossMob(EntityLiving e) {
        if (e instanceof EntityWither || e instanceof EntityDragon) {
            return true;
        }
        String name = e.getClass().getName().toLowerCase(Locale.ENGLISH);
        if (name.contains("voidmonster")) {
            return false;
        }
        return name.startsWith("twilightforest.entity.boss");
    }

    public static void transferEntityToDimension(Entity e, int to_dim) {
        ReikaEntityHelper.transferEntityToDimension(e, to_dim, null);
    }

    public static void transferEntityToDimension(Entity e, int to_dim, Teleporter t) {
        if (!e.field_70128_L) {
            if (e instanceof EntityPlayerMP) {
                ReikaEntityHelper.transferPlayerToDimension((EntityPlayerMP)e, to_dim, t);
            } else if (!e.field_70170_p.field_72995_K) {
                e.field_70170_p.field_72984_F.func_76320_a("changeDimension");
                MinecraftServer ms = MinecraftServer.func_71276_C();
                int from_dim = e.field_71093_bK;
                WorldServer from = ms.func_71218_a(from_dim);
                WorldServer to = ms.func_71218_a(to_dim);
                e.field_71093_bK = to_dim;
                e.field_70170_p.func_72900_e(e);
                e.field_70128_L = false;
                e.field_70170_p.field_72984_F.func_76320_a("reposition");
                ms.func_71203_ab().transferEntityToWorld(e, from_dim, from, to, (Teleporter)(t != null ? t : new DummyTeleporter(to)));
                e.field_70170_p.field_72984_F.func_76318_c("reloading");
                Entity copy = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)e), (World)to);
                if (copy != null) {
                    copy.func_82141_a(e, true);
                    to.func_72838_d(copy);
                }
                e.field_70128_L = true;
                e.field_70170_p.field_72984_F.func_76319_b();
                from.func_82742_i();
                to.func_82742_i();
                e.field_70170_p.field_72984_F.func_76319_b();
            } else {
                e.field_71093_bK = to_dim;
            }
        }
    }

    private static void transferPlayerToDimension(EntityPlayerMP ep, int to_dim, Teleporter t) {
        MinecraftServer mcs = ep.field_71133_b;
        if (ep.field_71088_bW > 0) {
            ep.field_71088_bW = 10;
        }
        mcs.func_71203_ab().transferPlayerToDimension(ep, to_dim, (Teleporter)(t != null ? t : new DummyTeleporter(mcs.func_71218_a(to_dim))));
    }

    public static <T extends Entity> T getNearestEntityOfSameType(T e, int r) {
        return (T)e.field_70170_p.func_72857_a(e.getClass(), ReikaAABBHelper.getEntityCenteredAABB(e, 24.0), e);
    }

    public static void decrEntityItemStack(EntityItem ei, int rem) {
        ItemStack is = ei.func_92059_d();
        is.field_77994_a -= rem;
        if (is.field_77994_a <= 0) {
            ei.func_70106_y();
        }
    }

    public static void clearEntities(World world, IEntitySelector sel) {
        for (Entity e : world.field_72996_f) {
            if (sel != null && !sel.func_82704_a(e)) continue;
            e.func_70106_y();
        }
    }

    public static void addAITask(EntityLiving e, EntityAIBase task, int priority) {
        if (!ReikaEntityHelper.hasAITask(e, task)) {
            e.field_70714_bg.func_75776_a(priority, task);
        }
    }

    public static boolean hasAITask(EntityLiving e, EntityAIBase task) {
        for (EntityAITasks.EntityAITaskEntry in : e.field_70714_bg.field_75782_a) {
            if (in.field_75733_a == task || in.field_75733_a.equals(task)) {
                return true;
            }
            if (!(in instanceof ComparableAI) || !(task instanceof ComparableAI)) continue;
            if (((ComparableAI)in).match((ComparableAI)task)) {
                return true;
            }
            if (!((ComparableAI)task).match((ComparableAI)in)) continue;
            return true;
        }
        return false;
    }

    public static void seamlessTeleport(Entity e, int x1, int y1, int z1, int x2, int y2, int z2, ForgeDirection from, ForgeDirection to) {
        if (e.field_70170_p.field_72995_K) {
            return;
        }
        double dx = e.field_70165_t - (double)x1 - 0.5;
        double dy = e.field_70163_u - (double)y1 - 0.5;
        double dz = e.field_70161_v - (double)z1 - 0.5;
        float yaw = ReikaEntityHelper.getDYaw(e, from, to);
        Vec3 vec = Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
        vec = ReikaVectorHelper.rotateVector(vec, 0.0, (double)yaw, 0.0);
        double nx = (double)x2 + vec.field_72450_a + 0.5;
        double ny = (double)y2 + vec.field_72448_b + 0.5;
        double nz = (double)z2 + vec.field_72449_c + 0.5;
        Vec3 vvec = Vec3.func_72443_a((double)e.field_70159_w, (double)e.field_70181_x, (double)e.field_70179_y);
        vvec = ReikaVectorHelper.rotateVector(vvec, 0.0, (double)yaw, 0.0);
        e.field_70159_w = vvec.field_72450_a;
        e.field_70181_x = vvec.field_72448_b;
        e.field_70179_y = vvec.field_72449_c;
        if (e instanceof EntityPlayer) {
            e.field_70177_z += yaw;
            ((EntityPlayer)e).field_70759_as += yaw;
            ((EntityPlayer)e).field_70758_at += yaw;
            e.field_70126_B += yaw;
            ((EntityPlayer)e).func_70634_a(nx, ny, nz);
            byte a = (byte)MathHelper.func_76141_d((float)(((EntityPlayer)e).field_70759_as * 256.0f / 360.0f));
            ((EntityPlayerMP)e).field_71135_a.func_147359_a((Packet)new S19PacketEntityHeadLook(e, a));
        } else {
            e.func_70012_b(nx, ny, nz, e.field_70177_z + yaw, e.field_70125_A);
        }
    }

    private static float getDYaw(Entity e, ForgeDirection from, ForgeDirection to) {
        int rel = ReikaDirectionHelper.getRelativeAngle(from, to);
        if (rel > 180) {
            rel -= 360;
        }
        return rel;
    }

    public static ForgeDirection getDirectionFromEntityLook(EntityLivingBase e, boolean vertical) {
        if (MathHelper.func_76135_e((float)e.field_70125_A) < 60.0f || !vertical) {
            int i;
            for (i = MathHelper.func_76128_c((double)((double)(e.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
            }
            while (i < 0) {
                i += 4;
            }
            switch (i) {
                case 0: {
                    return ForgeDirection.SOUTH;
                }
                case 1: {
                    return ForgeDirection.WEST;
                }
                case 2: {
                    return ForgeDirection.NORTH;
                }
                case 3: {
                    return ForgeDirection.EAST;
                }
            }
        } else {
            if (e.field_70125_A > 0.0f) {
                return ForgeDirection.DOWN;
            }
            return ForgeDirection.UP;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static Class<? extends EntityLivingBase> getEntityCategoryClass(EntityLivingBase e) {
        if (e instanceof EntityPlayer) {
            return EntityPlayer.class;
        }
        if (e instanceof EntityEnderman || e instanceof EntityPigZombie) {
            return e.getClass();
        }
        if (e instanceof EntityMob) {
            return EntityMob.class;
        }
        if (e instanceof EntityAnimal) {
            return EntityAnimal.class;
        }
        return e.getClass();
    }

    public static Entity getShootingEntity(Entity e) {
        if (e instanceof EntityThrowable) {
            return ((EntityThrowable)e).func_85052_h();
        }
        if (e instanceof EntityFireball) {
            return ((EntityFireball)e).field_70235_a;
        }
        if (e instanceof EntityArrow) {
            return ((EntityArrow)e).field_70250_c;
        }
        if (e instanceof CustomProjectile) {
            return ((CustomProjectile)e).getFiringEntity();
        }
        if (ModList.BLOODMAGIC.isLoaded() && InterfaceCache.SPELLSHOT.instanceOf(e)) {
            return ((EntitySpellProjectile)e).shootingEntity;
        }
        return null;
    }

    public static boolean canEntitySeeTheSky(Entity e) {
        return e.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)e.field_70163_u), MathHelper.func_76128_c((double)e.field_70161_v));
    }

    public static boolean isNearSkylight(Entity e) {
        return e.field_70170_p.func_72972_b(EnumSkyBlock.Sky, MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)e.field_70163_u), MathHelper.func_76128_c((double)e.field_70161_v)) > 0;
    }

    public static boolean isEntityWearingPoweredArmor(EntityLivingBase e) {
        for (int i = 1; i <= 4; ++i) {
            ItemStack is = e.func_71124_b(i);
            if (is == null) continue;
            if (InterfaceCache.GASITEM.instanceOf(is.func_77973_b())) {
                return true;
            }
            if (InterfaceCache.RFENERGYITEM.instanceOf(is.func_77973_b())) {
                return true;
            }
            if (InterfaceCache.ENERGYITEM.instanceOf(is.func_77973_b())) {
                return true;
            }
            if (InterfaceCache.IELECTRICITEM.instanceOf(is.func_77973_b())) {
                return true;
            }
            if (!InterfaceCache.MUSEELECTRICITEM.instanceOf(is.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    public static double getCarriedMass(EntityLivingBase e) {
        double mass = 0.0;
        for (int i = 0; i <= 4; ++i) {
            mass += ReikaItemHelper.getItemMass(e.func_71124_b(i));
        }
        return mass;
    }

    public static EntityXPOrb mergeXPOrbs(World world, Collection<EntityXPOrb> c) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        int n = 0;
        int value = 0;
        int age = Integer.MAX_VALUE;
        for (EntityXPOrb e : c) {
            if (e.field_70128_L || e.field_70530_e <= 0 || e.field_70531_b < 2) continue;
            e.func_70106_y();
            x += e.field_70165_t;
            y += e.field_70163_u;
            z += e.field_70161_v;
            vx += e.field_70159_w;
            vy += e.field_70181_x;
            vz += e.field_70179_y;
            ++n;
            value += e.field_70530_e;
            age = Math.min(age, e.field_70531_b);
            e.field_70530_e = 0;
        }
        if (n > 0 && value > 0) {
            EntityXPOrb xp = new EntityXPOrb(world, x /= (double)n, y /= (double)n, z /= (double)n, value);
            xp.field_70159_w = vx /= (double)n;
            xp.field_70181_x = vy /= (double)n;
            xp.field_70179_y = vz /= (double)n;
            xp.field_70531_b = age;
            xp.field_70133_I = true;
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)xp);
            }
            return xp;
        }
        return null;
    }

    public static EntityXPOrb mergeXPOrbs(EntityXPOrb e1, EntityXPOrb e2) {
        if (e1.field_70128_L) {
            return e2;
        }
        if (e2.field_70128_L) {
            return e1;
        }
        e1.func_70106_y();
        e2.func_70106_y();
        double x = (e1.field_70165_t + e2.field_70165_t) / 2.0;
        double y = (e1.field_70163_u + e2.field_70163_u) / 2.0;
        double z = (e1.field_70161_v + e2.field_70161_v) / 2.0;
        EntityXPOrb xp = new EntityXPOrb(e1.field_70170_p, x, y, z, e1.field_70530_e + e2.field_70530_e);
        xp.field_70531_b = Math.min(e1.field_70531_b, e2.field_70531_b);
        if (!e1.field_70170_p.field_72995_K) {
            e1.field_70170_p.func_72838_d((Entity)xp);
        }
        return xp;
    }

    public static int damageArmor(EntityLivingBase e, int amt) {
        int ret = 0;
        for (int i = 1; i < 5; ++i) {
            IEnergyContainerItem ie;
            ItemStack arm = e.func_71124_b(i);
            if (arm == null || !ReikaEntityHelper.canDamageArmorOf(e)) continue;
            Item item = arm.func_77973_b();
            if (InterfaceCache.MUSEELECTRICITEM.instanceOf(item)) {
                MuseElectricItem ms = (MuseElectricItem)item;
                ret += ms.extractEnergy(arm, amt * 50, false);
                continue;
            }
            if (InterfaceCache.RFENERGYITEM.instanceOf(item)) {
                ie = (IEnergyContainerItem)item;
                ret += ie.extractEnergy(arm, amt * 50, false);
                continue;
            }
            if (InterfaceCache.IELECTRICITEM.instanceOf(item)) {
                ie = (IElectricItem)item;
                Item id = ie.getEmptyItem(arm);
                ItemStack newarm = new ItemStack(id, 1, 0);
                e.func_70062_b(i, newarm);
                ret += amt;
                continue;
            }
            if (InterfaceCache.GASITEM.instanceOf(item)) {
                ie = (IGasItem)item;
                GasStack gas = ie.getGas(arm);
                if (gas != null && gas.amount > 0) {
                    gas = ie.removeGas(arm, Math.max(amt, gas.amount * amt / 400));
                }
                ret += gas != null ? gas.amount : 0;
                continue;
            }
            if (item instanceof UnbreakableArmor && !((UnbreakableArmor)item).canBeDamaged()) continue;
            arm.func_77972_a(amt, e);
            if (arm.func_77960_j() > arm.func_77958_k() || arm.field_77994_a <= 0) {
                arm = null;
                e.func_70062_b(i, null);
            }
            e.func_85030_a("random.break", 0.1f, 0.8f);
            ret += amt;
        }
        return ret;
    }

    private static boolean canDamageArmorOf(EntityLivingBase target) {
        MinecraftServer ms = MinecraftServer.func_71276_C();
        return target instanceof EntityPlayer ? ms != null && ms.func_71219_W() : true;
    }

    public static boolean existsAnotherEntityWithin(Entity e, double dist) {
        AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB(e, dist);
        return e.field_70170_p.func_82733_a(e.getClass(), box, (IEntitySelector)new NotSelfSelector(e)).size() > 0;
    }

    public static boolean existsAnotherValidEntityWithin(Entity e, double dist, IEntitySelector check) {
        AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB(e, dist);
        return e.field_70170_p.func_82733_a(e.getClass(), box, ReikaEntityHelper.combineEntitySelectors(true, new NotSelfSelector(e), check)).size() > 0;
    }

    public static IEntitySelector combineEntitySelectors(boolean and, IEntitySelector ... s) {
        CombinedEntitySelector ret = and ? new CombinedEntitySelectorAND() : new CombinedEntitySelectorOR();
        for (int i = 0; i < s.length; ++i) {
            ret.addSelector(s[i]);
        }
        return ret;
    }

    public static void doSetHealthDamage(EntityLivingBase e, DamageSource src, float amt) {
        if (amt >= e.func_110143_aJ()) {
            e.func_70606_j(0.1f);
            e.func_70097_a(src, Float.MAX_VALUE);
        } else {
            e.func_70606_j(e.func_110143_aJ() - amt);
        }
    }

    public static boolean isInWorld(Entity e) {
        return e.field_70170_p != null && e.field_70170_p.func_73045_a(e.func_145782_y()) == e;
    }

    public static boolean isInRain(Entity e) {
        return e.field_70170_p.func_72951_B(MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)e.field_70163_u), MathHelper.func_76128_c((double)e.field_70161_v)) || e.field_70170_p.func_72951_B(MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)(e.field_70163_u + (double)e.field_70131_O)), MathHelper.func_76128_c((double)e.field_70161_v));
    }

    static {
        mobColorArray.put(EntityCreeper.class, ReikaColorAPI.RGBtoHex(65, 183, 54));
        mobColorArray.put(EntitySkeleton.class, ReikaColorAPI.GStoHex(207));
        mobColorArray.put(EntitySpider.class, ReikaColorAPI.RGBtoHex(90, 71, 43));
        mobColorArray.put(EntityGiantZombie.class, ReikaColorAPI.RGBtoHex(67, 109, 53));
        mobColorArray.put(EntityZombie.class, ReikaColorAPI.RGBtoHex(67, 109, 53));
        mobColorArray.put(EntitySlime.class, ReikaColorAPI.RGBtoHex(90, 162, 68));
        mobColorArray.put(EntityGhast.class, ReikaColorAPI.GStoHex(240));
        mobColorArray.put(EntityPigZombie.class, ReikaColorAPI.RGBtoHex(181, 131, 131));
        mobColorArray.put(EntityEnderman.class, ReikaColorAPI.RGBtoHex(204, 15, 248));
        mobColorArray.put(EntityCaveSpider.class, ReikaColorAPI.RGBtoHex(18, 77, 90));
        mobColorArray.put(EntitySilverfish.class, ReikaColorAPI.GStoHex(140));
        mobColorArray.put(EntityBlaze.class, ReikaColorAPI.RGBtoHex(235, 180, 26));
        mobColorArray.put(EntityMagmaCube.class, ReikaColorAPI.RGBtoHex(84, 14, 0));
        mobColorArray.put(EntityDragon.class, ReikaColorAPI.RGBtoHex(224, 121, 250));
        mobColorArray.put(EntityWither.class, ReikaColorAPI.GStoHex(79));
        mobColorArray.put(EntityBat.class, ReikaColorAPI.RGBtoHex(118, 100, 61));
        mobColorArray.put(EntityWitch.class, ReikaColorAPI.RGBtoHex(163, 148, 131));
        mobColorArray.put(EntityPig.class, ReikaColorAPI.RGBtoHex(238, 158, 158));
        mobColorArray.put(EntitySheep.class, ReikaColorAPI.GStoHex(214));
        mobColorArray.put(EntityCow.class, ReikaColorAPI.RGBtoHex(67, 53, 37));
        mobColorArray.put(EntityChicken.class, ReikaColorAPI.RGBtoHex(193, 147, 67));
        mobColorArray.put(EntitySquid.class, ReikaColorAPI.RGBtoHex(83, 108, 127));
        mobColorArray.put(EntityWolf.class, ReikaColorAPI.RGBtoHex(183, 179, 180));
        mobColorArray.put(EntityMooshroom.class, ReikaColorAPI.RGBtoHex(151, 3, 4));
        mobColorArray.put(EntitySnowman.class, ReikaColorAPI.RGBtoHex(226, 143, 34));
        mobColorArray.put(EntityOcelot.class, ReikaColorAPI.RGBtoHex(242, 197, 110));
        mobColorArray.put(EntityIronGolem.class, ReikaColorAPI.RGBtoHex(208, 185, 168));
        mobColorArray.put(EntityVillager.class, ReikaColorAPI.RGBtoHex(178, 122, 98));
        mobColorArray.put(EntityPlayer.class, 255);
        mobColorArray.put(EntityAnimal.class, 40960);
        mobColorArray.put(EntityGolem.class, 0x7F7F7F);
        mobColorArray.put(EntityMob.class, 0xFF0000);
        mobColorArray.put(Entity.class, 0xFFFFFF);
    }

    public static class WrappedDamageSource
    extends DamageSource {
        private final DamageSource wrapped;
        public final EntityPlayer player;

        public WrappedDamageSource(DamageSource src, EntityPlayer ep) {
            super(src.field_76373_n);
            this.wrapped = src;
            this.player = ep;
        }

        public boolean func_76352_a() {
            return this.wrapped.func_76352_a();
        }

        public boolean func_94541_c() {
            return this.wrapped.func_94541_c();
        }

        public boolean func_76363_c() {
            return this.wrapped.func_76363_c();
        }

        public float func_76345_d() {
            return this.wrapped.func_76345_d();
        }

        public boolean func_76357_e() {
            return this.wrapped.func_76357_e();
        }

        public boolean func_151517_h() {
            return this.wrapped.func_151517_h();
        }

        public Entity func_76346_g() {
            return this.player;
        }

        public IChatComponent func_151519_b(EntityLivingBase tg) {
            return this.wrapped.func_151519_b(tg);
        }

        public boolean func_76347_k() {
            return this.wrapped.func_76347_k();
        }

        public String func_76355_l() {
            return this.wrapped.field_76373_n;
        }

        public boolean func_76350_n() {
            return this.wrapped.func_76350_n();
        }

        public boolean func_82725_o() {
            return this.wrapped.func_82725_o();
        }
    }

    public static final class EntityDistanceComparator
    implements Comparator<Entity> {
        public final double posX;
        public final double posY;
        public final double posZ;

        public EntityDistanceComparator(double x, double y, double z) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        @Override
        public int compare(Entity e1, Entity e2) {
            double dd2;
            double dd1 = ReikaMathLibrary.py3d(e1.field_70165_t - this.posX, e1.field_70163_u - this.posY, e1.field_70161_v - this.posZ);
            return dd1 > (dd2 = ReikaMathLibrary.py3d(e2.field_70165_t - this.posX, e2.field_70163_u - this.posY, e2.field_70161_v - this.posZ)) ? 1 : (dd1 < dd2 ? -1 : 0);
        }
    }

    private static final class CombinedEntitySelectorOR
    extends CombinedEntitySelector {
        private CombinedEntitySelectorOR() {
        }

        public boolean func_82704_a(Entity e) {
            for (IEntitySelector ie : this.callers) {
                if (ie.func_82704_a(e)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class CombinedEntitySelectorAND
    extends CombinedEntitySelector {
        private CombinedEntitySelectorAND() {
        }

        public boolean func_82704_a(Entity e) {
            for (IEntitySelector ie : this.callers) {
                if (ie.func_82704_a(e)) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class CombinedEntitySelector
    implements IEntitySelector {
        protected final Collection<IEntitySelector> callers = new ArrayList<IEntitySelector>();

        private CombinedEntitySelector() {
        }

        private final CombinedEntitySelector addSelector(IEntitySelector e) {
            this.callers.add(e);
            return this;
        }
    }

    public static final class EntityIDSelector
    implements IEntitySelector {
        private final int entityID;

        public EntityIDSelector(int id) {
            this.entityID = id;
        }

        public boolean func_82704_a(Entity e) {
            return EntityList.func_75619_a((Entity)e) == this.entityID;
        }
    }

    public static final class MultiItemSelector
    implements IEntitySelector {
        private final HashSet<KeyedItemStack> items = new HashSet();

        public MultiItemSelector(Collection<KeyedItemStack> c) {
            for (KeyedItemStack ks : c) {
                this.items.add(ks.copy().setSimpleHash(true));
            }
        }

        public boolean func_82704_a(Entity e) {
            if (e instanceof EntityItem) {
                KeyedItemStack ks = new KeyedItemStack(((EntityItem)e).func_92059_d()).setSimpleHash(true);
                return this.items.contains(ks);
            }
            return false;
        }
    }

    public static final class SpecificItemSelector
    implements IEntitySelector {
        private final KeyedItemStack item;

        public SpecificItemSelector(KeyedItemStack ks) {
            this.item = ks;
        }

        public boolean func_82704_a(Entity e) {
            return e instanceof EntityItem && this.item.match(((EntityItem)e).func_92059_d());
        }
    }

    public static final class ClassEntitySelector
    implements IEntitySelector {
        private final Class classType;

        public ClassEntitySelector(Class c) {
            this.classType = c;
        }

        public boolean func_82704_a(Entity e) {
            return e.getClass() == this.classType;
        }
    }

    public static final class NotSelfSelector
    implements IEntitySelector {
        private final Entity reference;

        public NotSelfSelector(Entity e) {
            this.reference = e;
        }

        public boolean func_82704_a(Entity e) {
            return e != this.reference;
        }
    }
}

