/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Recipe.RecipePattern;
import Reika.DragonAPI.Interfaces.CustomToStringRecipe;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipesArmor;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesCrafting;
import net.minecraft.item.crafting.RecipesDyes;
import net.minecraft.item.crafting.RecipesFood;
import net.minecraft.item.crafting.RecipesIngots;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.RecipesTools;
import net.minecraft.item.crafting.RecipesWeapons;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ReikaRecipeHelper
extends DragonAPICore {
    private static final CraftingManager cr = CraftingManager.func_77594_a();
    private static final List<IRecipe> recipes = cr.func_77592_b();
    private static final Random rand = new Random();
    private static final int[] permuOffsets = new int[9];
    private static final HashMap<IRecipe, RecipeCache> recipeCache = new HashMap();
    private static final HashMap<IRecipe, RecipeCache> recipeCacheClient = new HashMap();
    private static Field shapedOreHeight;
    private static Field shapedOreWidth;
    private static Field shapedOreInput;

    private static void overwriteShapedOreRecipeInput(ShapedOreRecipe s, Object[] in, int height, int width) {
        try {
            shapedOreInput.set(s, in);
            shapedOreHeight.set(s, height);
            shapedOreWidth.set(s, width);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getOreRecipeHeight(ShapedOreRecipe s) {
        try {
            return shapedOreHeight.getInt(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getOreRecipeWidth(ShapedOreRecipe s) {
        try {
            return shapedOreWidth.getInt(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static IRecipe getRecipeByOutput(ItemStack out) {
        return recipes.get(recipes.indexOf(out));
    }

    public static ItemStack getItemInRecipeAtXY(ShapedRecipes r, int x, int y) {
        int xy = x + r.field_77576_b * y;
        return r.field_77574_d[xy];
    }

    public static ArrayList<IRecipe> getAllRecipesByOutput(List<IRecipe> in, ItemStack out) {
        ArrayList<IRecipe> li = new ArrayList<IRecipe>();
        for (IRecipe ir : in) {
            if (!ReikaItemHelper.matchStacks(ir.func_77571_b(), out)) continue;
            li.add(ir);
        }
        return li;
    }

    public static boolean isCraftable(ItemStack is) {
        return ReikaRecipeHelper.isCraftable(CraftingManager.func_77594_a().func_77592_b(), is);
    }

    public static boolean isCraftable(List<IRecipe> in, ItemStack is) {
        return ReikaRecipeHelper.getAllRecipesByOutput(in, is).size() > 0;
    }

    public static List<ShapedOreRecipe> getShapedOreRecipesByOutput(List<IRecipe> in, ItemStack out) {
        ArrayList<ShapedOreRecipe> li = new ArrayList<ShapedOreRecipe>();
        for (IRecipe ir : in) {
            if (!(ir instanceof ShapedOreRecipe) || !ReikaItemHelper.matchStacks(ir.func_77571_b(), out)) continue;
            li.add((ShapedOreRecipe)ir);
        }
        return li;
    }

    public static List<ShapelessRecipes> getShapelessRecipesByOutput(List<IRecipe> in, ItemStack out) {
        ArrayList<ShapelessRecipes> li = new ArrayList<ShapelessRecipes>();
        for (IRecipe ir : in) {
            if (!(ir instanceof ShapelessRecipes) || !ReikaItemHelper.matchStacks(ir.func_77571_b(), out)) continue;
            li.add((ShapelessRecipes)ir);
        }
        return li;
    }

    public static List<ShapelessOreRecipe> getShapelessOreRecipesByOutput(List<IRecipe> in, ItemStack out) {
        ArrayList<ShapelessOreRecipe> li = new ArrayList<ShapelessOreRecipe>();
        for (IRecipe ir : in) {
            if (!(ir instanceof ShapelessOreRecipe) || !ReikaItemHelper.matchStacks(ir.func_77571_b(), out)) continue;
            li.add((ShapelessOreRecipe)ir);
        }
        return li;
    }

    private static List<ItemStack> getRecipeItemStack(ItemStack is, boolean client) {
        if (is == null) {
            return null;
        }
        if (is.func_77960_j() == Short.MAX_VALUE && client) {
            return ReikaItemHelper.getAllMetadataPermutations(is.func_77973_b());
        }
        return ReikaJavaLibrary.makeListFrom((Object)is);
    }

    private static List<ItemStack> getRecipeItemStacks(Collection<ItemStack> c, boolean client) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack is : c) {
            if (is == null) continue;
            if (is.func_77960_j() == Short.MAX_VALUE && client) {
                ret.addAll(ReikaItemHelper.getAllMetadataPermutations(is.func_77973_b()));
                continue;
            }
            ret.add(is);
        }
        return ret;
    }

    private static RecipeCache getRecipeCacheObject(IRecipe ir, boolean client) {
        HashMap<IRecipe, RecipeCache> map = client ? recipeCacheClient : recipeCache;
        RecipeCache cache = map.get(ir);
        if (cache == null) {
            cache = ReikaRecipeHelper.calculateRecipeToItemStackArray(ir, client);
            map.put(ir, cache);
        }
        return cache;
    }

    public static List<ItemStack>[] getRecipeArray(IRecipe ir) {
        List[] lists = new List[9];
        for (int i = 0; i < 9; ++i) {
            List li = ReikaRecipeHelper.getRecipeCacheObject(ir, false).items[i];
            if (li == null || li.isEmpty()) continue;
            lists[i] = Collections.unmodifiableList(li);
        }
        return lists;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack[] getPermutedRecipeArray(IRecipe ir) {
        RecipeCache r = ReikaRecipeHelper.getRecipeCacheObject(ir, true);
        List[] isin = r.items;
        long ttick = System.currentTimeMillis();
        if (GuiScreen.func_146272_n()) {
            ttick *= 4L;
        }
        if (GuiScreen.func_146271_m()) {
            ttick /= 8L;
        }
        int time = 1000;
        for (int i = 0; i < isin.length; ++i) {
            if (isin[i] == null || isin[i].isEmpty() || ttick % (long)time != 0L) continue;
            ReikaRecipeHelper.permuOffsets[i] = rand.nextInt(isin[i].size());
        }
        int[] indices = new int[9];
        ItemStack[] add = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            List li = isin[i];
            if (li == null || li.isEmpty()) continue;
            int tick = (int)((ttick / (long)time + (long)permuOffsets[i]) % (long)li.size());
            add[i] = (ItemStack)li.get(tick);
        }
        ItemStack[] in = new ItemStack[9];
        if (r.width == 3 && r.height == 3) {
            for (int i = 0; i < 9; ++i) {
                in[i] = add[i];
            }
        }
        if (r.width == 1 && r.height == 1) {
            in[4] = add[0];
        }
        if (r.width == 2 && r.height == 2) {
            in[0] = add[0];
            in[1] = add[1];
            in[3] = add[2];
            in[4] = add[3];
        }
        if (r.width == 1 && r.height == 2) {
            in[4] = add[0];
            in[7] = add[1];
        }
        if (r.width == 2 && r.height == 1) {
            in[0] = add[0];
            in[1] = add[1];
        }
        if (r.width == 3 && r.height == 1) {
            in[0] = add[0];
            in[1] = add[1];
            in[2] = add[2];
        }
        if (r.width == 1 && r.height == 3) {
            in[1] = add[0];
            in[4] = add[1];
            in[7] = add[2];
        }
        if (r.width == 2 && r.height == 3) {
            in[0] = add[0];
            in[1] = add[1];
            in[3] = add[2];
            in[4] = add[3];
            in[6] = add[4];
            in[7] = add[5];
        }
        if (r.width == 3 && r.height == 2) {
            in[3] = add[0];
            in[4] = add[1];
            in[5] = add[2];
            in[6] = add[3];
            in[7] = add[4];
            in[8] = add[5];
        }
        return in;
    }

    private static RecipeCache calculateRecipeToItemStackArray(IRecipe ire, boolean client) {
        List[] isin = new List[9];
        int w = 0;
        int h = 0;
        if (ire == null) {
            DragonAPICore.logError("Recipe is null!");
        }
        if (ire == null) {
            ReikaJavaLibrary.dumpStack();
            return null;
        }
        if (ire instanceof ShapedRecipes) {
            ShapedRecipes r = (ShapedRecipes)ire;
            int num = r.field_77574_d.length;
            w = r.field_77576_b;
            h = r.field_77577_c;
            for (int i = 0; i < r.field_77574_d.length; ++i) {
                ItemStack is = r.field_77574_d[i];
                isin[i] = ReikaRecipeHelper.getRecipeItemStack(is, client);
            }
        } else if (ire instanceof ShapedOreRecipe) {
            ShapedOreRecipe so = (ShapedOreRecipe)ire;
            Object[] objin = so.getInput();
            w = 3;
            h = 3;
            for (int i = 0; i < objin.length; ++i) {
                List li;
                if (objin[i] instanceof ItemStack) {
                    ItemStack is = (ItemStack)objin[i];
                    isin[i] = ReikaRecipeHelper.getRecipeItemStack(is, client);
                    continue;
                }
                if (!(objin[i] instanceof List) || (li = (List)objin[i]).isEmpty()) continue;
                isin[i] = ReikaRecipeHelper.getRecipeItemStacks(li, client);
            }
        } else if (ire instanceof ShapelessRecipes) {
            ShapelessRecipes sr = (ShapelessRecipes)ire;
            for (int i = 0; i < sr.func_77570_a(); ++i) {
                ItemStack is = (ItemStack)sr.field_77579_b.get(i);
                isin[i] = ReikaRecipeHelper.getRecipeItemStack(is, client);
            }
            w = sr.func_77570_a() >= 3 ? 3 : sr.func_77570_a();
            h = (sr.func_77570_a() + 2) / 3;
        } else if (ire instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe so = (ShapelessOreRecipe)ire;
            for (int i = 0; i < so.func_77570_a(); ++i) {
                List li;
                Object obj = so.getInput().get(i);
                if (obj instanceof ItemStack) {
                    ItemStack is = (ItemStack)obj;
                    isin[i] = ReikaRecipeHelper.getRecipeItemStack(is, client);
                    continue;
                }
                if (!(obj instanceof List) || (li = (List)obj).isEmpty()) continue;
                isin[i] = ReikaRecipeHelper.getRecipeItemStacks(li, client);
            }
            w = so.func_77570_a() >= 3 ? 3 : so.func_77570_a();
            h = (so.func_77570_a() + 2) / 3;
        }
        return new RecipeCache(isin, w, h);
    }

    public static ItemStack getFurnaceInput(ItemStack out) {
        HashMap m = (HashMap)FurnaceRecipes.func_77602_a().func_77599_b();
        for (Object o : m.keySet()) {
            ItemStack in = (ItemStack)o;
            if (!ReikaItemHelper.matchStacks(FurnaceRecipes.func_77602_a().func_151395_a(in), out)) continue;
            return in;
        }
        return null;
    }

    public static void addSmelting(ItemStack in, ItemStack out, float xp) {
        FurnaceRecipes.func_77602_a().func_151394_a(in, out, xp);
    }

    public static boolean addOreRecipe(ItemStack out, Object ... in) {
        ShapedOreRecipe so = new ShapedOreRecipe(out, in);
        boolean allowed = true;
        ArrayList<String> missing = new ArrayList<String>();
        for (int i = 0; i < in.length; ++i) {
            if (!(in[i] instanceof String)) continue;
            String s = (String)in[i];
            if (i <= 0 || !(in[i - 1] instanceof Character) || ReikaItemHelper.oreItemExists(s)) continue;
            allowed = false;
            missing.add(s);
        }
        if (allowed) {
            GameRegistry.addRecipe((IRecipe)so);
        } else {
            DragonAPICore.log("Recipe for " + out.func_82833_r() + " requires missing Ore Dictionary items " + missing + ", and has not been loaded.");
        }
        return allowed;
    }

    public static void replaceIngredientInRecipe(ItemStack ingredient, ItemStack replacement, IRecipe ir) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (ingredient == null) {
                            throw new MisuseException("You cannot replace null in recipes!");
                        }
                        if (!(ir instanceof ShapedRecipes)) break block7;
                        ShapedRecipes s = (ShapedRecipes)ir;
                        for (int i = 0; i < s.field_77574_d.length; ++i) {
                            if (!ReikaItemHelper.matchStacks(ingredient, s.field_77574_d[i])) continue;
                            s.field_77574_d[i] = replacement;
                        }
                        break block8;
                    }
                    if (!(ir instanceof ShapelessRecipes)) break block9;
                    ShapelessRecipes s = (ShapelessRecipes)ir;
                    List in = s.field_77579_b;
                    for (int i = 0; i < in.size(); ++i) {
                        if (!ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i))) continue;
                        in.set(i, replacement);
                    }
                    break block8;
                }
                if (!(ir instanceof ShapedOreRecipe)) break block10;
                ShapedOreRecipe s = (ShapedOreRecipe)ir;
                Object[] in = s.getInput();
                for (int i = 0; i < in.length; ++i) {
                    if (in[i] instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)in[i])) {
                        in[i] = replacement;
                        continue;
                    }
                    if (!(in[i] instanceof List) || !ReikaItemHelper.collectionContainsItemStack((List)in[i], ingredient)) continue;
                    in[i] = replacement;
                }
                break block8;
            }
            if (!(ir instanceof ShapelessOreRecipe)) break block8;
            ShapelessOreRecipe s = (ShapelessOreRecipe)ir;
            ArrayList in = s.getInput();
            for (int i = 0; i < in.size(); ++i) {
                if (in.get(i) instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i))) {
                    in.set(i, replacement);
                    continue;
                }
                if (!(in.get(i) instanceof List) || !ReikaItemHelper.collectionContainsItemStack((List)in.get(i), ingredient)) continue;
                in.set(i, replacement);
            }
        }
    }

    public static void replaceIngredientInAllRecipes(ItemStack ingredient, ItemStack replacement, boolean makeCopy) {
        if (ingredient == null) {
            throw new MisuseException("You cannot replace null in recipes!");
        }
        ArrayList<Object> copies = new ArrayList<Object>();
        List li = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe ir : li) {
            int i;
            boolean match;
            ShapedRecipes s;
            if (ir instanceof ShapedRecipes) {
                int i2;
                s = (ShapedRecipes)ir;
                match = false;
                for (i2 = 0; i2 < s.field_77574_d.length; ++i2) {
                    if (!ReikaItemHelper.matchStacks(ingredient, s.field_77574_d[i2])) continue;
                    match = true;
                }
                if (match && makeCopy) {
                    copies.add(new ShapedRecipes(s.field_77576_b, s.field_77577_c, s.field_77574_d, s.func_77571_b()));
                }
                if (!match) continue;
                for (i2 = 0; i2 < s.field_77574_d.length; ++i2) {
                    if (!ReikaItemHelper.matchStacks(ingredient, s.field_77574_d[i2])) continue;
                    s.field_77574_d[i2] = replacement;
                }
                continue;
            }
            if (ir instanceof ShapelessRecipes) {
                int i3;
                s = (ShapelessRecipes)ir;
                match = false;
                List in = s.field_77579_b;
                for (i3 = 0; i3 < in.size(); ++i3) {
                    if (!ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i3))) continue;
                    match = true;
                }
                if (match && makeCopy) {
                    ItemStack[] inarr = new ItemStack[in.size()];
                    for (i = 0; i < inarr.length; ++i) {
                        inarr[i] = (ItemStack)in.get(i);
                    }
                    copies.add(new ShapelessRecipes(s.func_77571_b(), new ArrayList(in)));
                }
                if (!match) continue;
                for (i3 = 0; i3 < in.size(); ++i3) {
                    if (!ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i3))) continue;
                    in.set(i3, replacement);
                }
                continue;
            }
            if (ir instanceof ShapedOreRecipe) {
                int i4;
                s = (ShapedOreRecipe)ir;
                match = false;
                Object[] in = s.getInput();
                for (i4 = 0; i4 < in.length; ++i4) {
                    if (!(in[i4] instanceof ItemStack) || !ReikaItemHelper.matchStacks(ingredient, (ItemStack)in[i4])) continue;
                    match = true;
                }
                if (match && makeCopy) {
                    int h = ReikaRecipeHelper.getOreRecipeHeight((ShapedOreRecipe)s);
                    int w = ReikaRecipeHelper.getOreRecipeWidth((ShapedOreRecipe)s);
                    if (h > 0 && w > 0) {
                        ShapedOreRecipe rec = new ShapedOreRecipe(s.func_77571_b(), new Object[]{Character.valueOf('B'), Blocks.field_150348_b});
                        Object[] items = new Object[in.length];
                        System.arraycopy(in, 0, items, 0, in.length);
                        ReikaRecipeHelper.overwriteShapedOreRecipeInput(rec, items, h, w);
                        copies.add(rec);
                    }
                }
                if (!match) continue;
                for (i4 = 0; i4 < in.length; ++i4) {
                    if (!(in[i4] instanceof ItemStack) || !ReikaItemHelper.matchStacks(ingredient, (ItemStack)in[i4])) continue;
                    in[i4] = replacement;
                }
                continue;
            }
            if (!(ir instanceof ShapelessOreRecipe)) continue;
            s = (ShapelessOreRecipe)ir;
            match = false;
            ArrayList in = s.getInput();
            for (int i5 = 0; i5 < in.size(); ++i5) {
                if (!(in.get(i5) instanceof ItemStack) || !ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i5))) continue;
                match = true;
            }
            if (match && makeCopy) {
                Object[] inarr = new Object[in.size()];
                for (i = 0; i < inarr.length; ++i) {
                    if (in.get(i) instanceof ArrayList) {
                        ItemStack is = (ItemStack)((ArrayList)in.get(i)).get(0);
                        String oreName = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)is));
                        inarr[i] = oreName;
                        continue;
                    }
                    inarr[i] = in.get(i);
                }
                copies.add(new ShapelessOreRecipe(s.func_77571_b(), inarr));
            }
            if (!match) continue;
            for (int i6 = 0; i6 < in.size(); ++i6) {
                if (!(in.get(i6) instanceof ItemStack) || !ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i6))) continue;
                in.set(i6, replacement);
            }
        }
        CraftingManager.func_77594_a().func_77592_b().addAll(copies);
    }

    public static ShapedRecipes getShapedRecipeFor(ItemStack out, Object ... in) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (in[i] instanceof String[]) {
            String[] astring = (String[])in[i++];
            for (int l = 0; l < astring.length; ++l) {
                String s1 = astring[l];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        } else {
            while (in[i] instanceof String) {
                String s2 = (String)in[i++];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        }
        HashMap<Character, ItemStack> hashmap = new HashMap<Character, ItemStack>();
        while (i < in.length) {
            Character character = (Character)in[i];
            ItemStack itemstack1 = null;
            if (in[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)in[i + 1]);
            } else if (in[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)in[i + 1], 1, Short.MAX_VALUE);
            } else if (in[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)in[i + 1];
            }
            hashmap.put(character, itemstack1);
            i += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c0 = s.charAt(i1);
            aitemstack[i1] = hashmap.containsKey(Character.valueOf(c0)) ? ((ItemStack)hashmap.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShapedRecipes shapedrecipes = new ShapedRecipes(j, k, aitemstack, out);
        return shapedrecipes;
    }

    public static ArrayList<ItemStack> getAllItemsInRecipe(IRecipe ire) {
        ArrayList<ItemStack> li;
        block6: {
            block8: {
                block7: {
                    block5: {
                        li = new ArrayList<ItemStack>();
                        if (!(ire instanceof ShapedRecipes)) break block5;
                        ShapedRecipes r = (ShapedRecipes)ire;
                        for (int i = 0; i < r.field_77574_d.length; ++i) {
                            li.add(r.field_77574_d[i]);
                        }
                        break block6;
                    }
                    if (!(ire instanceof ShapedOreRecipe)) break block7;
                    ShapedOreRecipe so = (ShapedOreRecipe)ire;
                    Object[] objin = so.getInput();
                    for (int i = 0; i < objin.length; ++i) {
                        if (objin[i] instanceof ItemStack) {
                            li.add((ItemStack)objin[i]);
                            continue;
                        }
                        if (!(objin[i] instanceof ArrayList)) continue;
                        li.addAll((ArrayList)objin[i]);
                    }
                    break block6;
                }
                if (!(ire instanceof ShapelessRecipes)) break block8;
                ShapelessRecipes sr = (ShapelessRecipes)ire;
                li.addAll(sr.field_77579_b);
                break block6;
            }
            if (!(ire instanceof ShapelessOreRecipe)) break block6;
            ShapelessOreRecipe so = (ShapelessOreRecipe)ire;
            for (int i = 0; i < so.func_77570_a(); ++i) {
                Object obj = so.getInput().get(i);
                if (obj instanceof ItemStack) {
                    li.add((ItemStack)obj);
                    continue;
                }
                if (!(obj instanceof ArrayList)) continue;
                li.addAll((ArrayList)obj);
            }
        }
        return li;
    }

    public static Object[] getInputArrayCopy(IRecipe ire) {
        Object[] out;
        block9: {
            block11: {
                block10: {
                    block8: {
                        out = new Object[9];
                        if (!(ire instanceof ShapedRecipes)) break block8;
                        ShapedRecipes r = (ShapedRecipes)ire;
                        for (int i = 0; i < Math.min(3, r.field_77576_b); ++i) {
                            for (int k = 0; k < Math.min(3, r.field_77577_c); ++k) {
                                int idx = i + k * r.field_77576_b;
                                int idx2 = i + k * 3;
                                if (r.field_77574_d[idx] == null) continue;
                                out[idx2] = r.field_77574_d[idx].func_77946_l();
                            }
                        }
                        break block9;
                    }
                    if (!(ire instanceof ShapedOreRecipe)) break block10;
                    ShapedOreRecipe so = (ShapedOreRecipe)ire;
                    Object[] objin = so.getInput();
                    int w = ReikaRecipeHelper.getOreRecipeWidth(so);
                    for (int i = 0; i < Math.min(3, w); ++i) {
                        for (int k = 0; k < Math.min(3, ReikaRecipeHelper.getOreRecipeHeight(so)); ++k) {
                            int idx = i * w + k;
                            int idx2 = i * 3 + k;
                            Object o = objin[i];
                            if (o instanceof ItemStack) {
                                out[i] = ((ItemStack)o).func_77946_l();
                                continue;
                            }
                            if (!(o instanceof List)) continue;
                            out[i] = new ArrayList((List)o);
                        }
                    }
                    break block9;
                }
                if (!(ire instanceof ShapelessRecipes)) break block11;
                ShapelessRecipes sr = (ShapelessRecipes)ire;
                for (int i = 0; i < sr.field_77579_b.size(); ++i) {
                    ItemStack is = (ItemStack)sr.field_77579_b.get(i);
                    out[i] = is.func_77946_l();
                }
                break block9;
            }
            if (!(ire instanceof ShapelessOreRecipe)) break block9;
            ShapelessOreRecipe so = (ShapelessOreRecipe)ire;
            for (int i = 0; i < so.func_77570_a(); ++i) {
                Object o = so.getInput().get(i);
                if (o instanceof ItemStack) {
                    out[i] = ((ItemStack)o).func_77946_l();
                    continue;
                }
                if (!(o instanceof List)) continue;
                out[i] = new ArrayList((List)o);
            }
        }
        return out;
    }

    public static ArrayList<Object> getAllInputsInRecipe(IRecipe ire) {
        ArrayList<Object> li;
        block4: {
            block6: {
                block5: {
                    block3: {
                        li = new ArrayList<Object>();
                        if (!(ire instanceof ShapedRecipes)) break block3;
                        ShapedRecipes r = (ShapedRecipes)ire;
                        for (int i = 0; i < r.field_77574_d.length; ++i) {
                            li.add(r.field_77574_d[i]);
                        }
                        break block4;
                    }
                    if (!(ire instanceof ShapedOreRecipe)) break block5;
                    ShapedOreRecipe so = (ShapedOreRecipe)ire;
                    Object[] objin = so.getInput();
                    for (int i = 0; i < objin.length; ++i) {
                        li.add(objin[i]);
                    }
                    break block4;
                }
                if (!(ire instanceof ShapelessRecipes)) break block6;
                ShapelessRecipes sr = (ShapelessRecipes)ire;
                li.addAll(sr.field_77579_b);
                break block4;
            }
            if (!(ire instanceof ShapelessOreRecipe)) break block4;
            ShapelessOreRecipe so = (ShapelessOreRecipe)ire;
            for (int i = 0; i < so.func_77570_a(); ++i) {
                Object obj = so.getInput().get(i);
                li.add(obj);
            }
        }
        return li;
    }

    public static ArrayList<ItemStack> getMutableOreDictList(String s) {
        ArrayList li = OreDictionary.getOres((String)s);
        ArrayList<ItemStack> clean = new ArrayList<ItemStack>();
        clean.addAll(li);
        return clean;
    }

    public static IRecipe getShapelessRecipeFor(ItemStack out, ItemStack ... in) {
        return new ShapelessRecipes(out.func_77946_l(), (List)ReikaJavaLibrary.makeListFrom(in));
    }

    public static boolean matchArrayToRecipe(ItemStack[] in, IRecipe ir) {
        RecipePattern r = new RecipePattern(in);
        return ir.func_77569_a((InventoryCrafting)r, null);
    }

    public static boolean recipeContains(IRecipe ir, ItemStack is) {
        return ReikaItemHelper.collectionContainsItemStack(ReikaRecipeHelper.getAllItemsInRecipe(ir), is);
    }

    public static Collection<Integer> getRecipeLocationIndices(IRecipe ir, ItemStack is) {
        ArrayList<Integer> c = new ArrayList<Integer>();
        RecipeCache r = ReikaRecipeHelper.getRecipeCacheObject(ir, false);
        for (int i = 0; i < 9; ++i) {
            List li = r.items[i];
            if (li == null || !ReikaItemHelper.collectionContainsItemStack(li, is)) continue;
            c.add(i);
        }
        return c;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemHashMap<Integer> getItemCountsForDisplay(IRecipe ir) {
        ItemHashMap<Integer> map = new ItemHashMap<Integer>();
        ItemStack[] items = ReikaRecipeHelper.getPermutedRecipeArray(ir);
        for (int i = 0; i < 9; ++i) {
            ItemStack is = items[i];
            if (is == null) continue;
            Integer num = map.get(is);
            int n = num != null ? num : 0;
            map.put(is, (Integer)(n + 1));
        }
        return map;
    }

    public static String toString(IRecipe r) {
        if (r instanceof ShapedRecipes) {
            return "Shaped " + Arrays.toString(((ShapedRecipes)r).field_77574_d) + " > " + r.func_77571_b();
        }
        if (r instanceof ShapelessRecipes) {
            return "Shapeless " + ((ShapelessRecipes)r).field_77579_b.toString() + " > " + r.func_77571_b();
        }
        if (r instanceof ShapedOreRecipe) {
            return "Shaped Ore " + Arrays.toString(((ShapedOreRecipe)r).getInput()) + " > " + r.func_77571_b();
        }
        if (r instanceof ShapelessOreRecipe) {
            return "Shapeless Ore " + ((ShapelessOreRecipe)r).getInput().toString() + " > " + r.func_77571_b();
        }
        if (r instanceof CustomToStringRecipe) {
            return r.toString();
        }
        return "Unknown '" + r.getClass().getName() + "'" + " > " + r.func_77571_b();
    }

    public static boolean isNonVForgeRecipeClass(IRecipe r) {
        Class<?> c = r.getClass();
        if (c == ShapedRecipes.class || c == ShapelessRecipes.class) {
            return false;
        }
        if (c == RecipeBookCloning.class || c == RecipeFireworks.class || c == RecipesArmor.class || c == RecipesArmorDyes.class) {
            return false;
        }
        if (c == RecipesCrafting.class || c == RecipesDyes.class || c == RecipesFood.class || c == RecipesIngots.class) {
            return false;
        }
        if (c == RecipesMapCloning.class || c == RecipesMapExtending.class || c == RecipesTools.class || c == RecipesWeapons.class) {
            return false;
        }
        return c != ShapedOreRecipe.class && c != ShapelessOreRecipe.class;
    }

    public static boolean verifyRecipe(IRecipe r) {
        Object o;
        Object is;
        int i;
        Object in;
        if (!ReikaItemHelper.verifyItemStack(r.func_77571_b(), true)) {
            return false;
        }
        if (r instanceof ShapedRecipes) {
            in = ((ShapedRecipes)r).field_77574_d;
            for (i = 0; i < ((ItemStack[])in).length; ++i) {
                is = in[i];
                if (ReikaItemHelper.verifyItemStack((ItemStack)is, false)) continue;
                return false;
            }
        }
        if (r instanceof ShapelessRecipes) {
            in = ((ShapelessRecipes)r).field_77579_b;
            Iterator i$ = in.iterator();
            while (i$.hasNext()) {
                is = (ItemStack)i$.next();
                if (ReikaItemHelper.verifyItemStack((ItemStack)is, false)) continue;
                return false;
            }
        }
        if (r instanceof ShapedOreRecipe) {
            in = ((ShapedOreRecipe)r).getInput();
            for (i = 0; i < ((Object)in).length; ++i) {
                o = in[i];
                if (o instanceof ItemStack) {
                    if (ReikaItemHelper.verifyItemStack((ItemStack)o, false)) continue;
                    return false;
                }
                if (!(o instanceof List)) continue;
                for (ItemStack is2 : (List)o) {
                    if (ReikaItemHelper.verifyItemStack(is2, false)) continue;
                    return false;
                }
            }
        }
        if (r instanceof ShapelessOreRecipe) {
            in = ((ShapelessOreRecipe)r).getInput();
            Iterator i$ = in.iterator();
            while (i$.hasNext()) {
                o = i$.next();
                if (o instanceof ItemStack) {
                    if (ReikaItemHelper.verifyItemStack((ItemStack)o, false)) continue;
                    return false;
                }
                if (!(o instanceof List)) continue;
                for (ItemStack is2 : (List)o) {
                    if (ReikaItemHelper.verifyItemStack(is2, false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Object[] decode2DArray(Object[][] array) {
        int i;
        String[] input = new String[array.length];
        ArrayList<String> objects = new ArrayList<String>();
        ArrayList<Object> entries = new ArrayList<Object>();
        for (i = 0; i < array.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k < array[i].length; ++k) {
                Object o = array[i][k];
                char c = o == null ? (char)' ' : (char)(97 + (i * 3 + k));
                sb.append(String.valueOf(c));
                if (o == null) continue;
                entries.add(Character.valueOf(c));
                entries.add(o);
            }
            input[i] = sb.toString();
        }
        for (i = 0; i < input.length; ++i) {
            objects.add(input[i]);
        }
        objects.addAll(entries);
        return objects.toArray(new Object[objects.size()]);
    }

    static {
        try {
            shapedOreHeight = ShapedOreRecipe.class.getDeclaredField("height");
            shapedOreWidth = ShapedOreRecipe.class.getDeclaredField("width");
            shapedOreInput = ShapedOreRecipe.class.getDeclaredField("input");
            shapedOreHeight.setAccessible(true);
            shapedOreWidth.setAccessible(true);
            shapedOreInput.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class RecipeCache {
        private final List<ItemStack>[] items;
        private final int width;
        private final int height;

        private RecipeCache(List<ItemStack>[] items, int w, int h) {
            this.items = items;
            this.width = w;
            this.height = h;
        }
    }
}

