/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.World;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Extras.BlockProperties;
import Reika.DragonAPI.Instantiable.Data.Collections.RelativePositionList;
import Reika.DragonAPI.Instantiable.Data.Collections.TimedSet;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldChunk;
import Reika.DragonAPI.Instantiable.Event.MobTargetingEvent;
import Reika.DragonAPI.Instantiable.ResettableRandom;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public final class ReikaWorldHelper
extends DragonAPICore {
    private static final TimedSet<WorldChunk> forcingChunkSet = new TimedSet();
    private static Field moddedGeneratorList;
    private static Method computeModdedGeneratorList;
    private static final Random moddedGenRand_Calcer;
    private static final ResettableRandom moddedGenRand;

    public static boolean softBlocks(IBlockAccess world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a) {
            return true;
        }
        if (b == Blocks.field_150326_M) {
            return false;
        }
        if (ReikaBlockHelper.isLiquid(b)) {
            return true;
        }
        if (b.isReplaceable(world, x, y, z)) {
            return true;
        }
        if (b.isAir(world, x, y, z)) {
            return true;
        }
        if (b == Blocks.field_150395_bd) {
            return true;
        }
        return BlockProperties.isSoft(b);
    }

    public static boolean softBlocks(Block id) {
        if (id == Blocks.field_150350_a || id.func_149688_o() == Material.field_151579_a) {
            return true;
        }
        return BlockProperties.isSoft(id);
    }

    public static boolean flammable(IBlockAccess world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a) {
            return false;
        }
        if (b == Blocks.field_150415_aT || b == Blocks.field_150486_ae) {
            return false;
        }
        if (b.getFlammability(world, x, y, z, ForgeDirection.UP) > 0) {
            return true;
        }
        return BlockProperties.isFlammable(b);
    }

    public static boolean flammable(Block id) {
        if (id == Blocks.field_150350_a) {
            return false;
        }
        return BlockProperties.isFlammable(id);
    }

    public static boolean nonSolidBlocks(IBlockAccess world, int x, int y, int z) {
        return BlockProperties.isNonSolid(world.func_147439_a(x, y, z));
    }

    public static int capMetadata(int meta, int cap) {
        while (meta >= cap) {
            meta -= cap;
        }
        return meta;
    }

    public static Material getMaterial(World world, int x, int y, int z) {
        return world.func_72904_c(x, y, z, x, y, z) ? world.func_147439_a(x, y, z).func_149688_o() : Material.field_151579_a;
    }

    public static boolean isAirBlock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z);
    }

    public static void setBlock(World world, int x, int y, int z, ItemStack is) {
        ReikaWorldHelper.setBlock(world, x, y, z, is, 3);
    }

    public static void setBlock(World world, int x, int y, int z, ItemStack is, int flag) {
        world.func_147465_d(x, y, z, Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j(), flag);
    }

    public static double findSolidSurface(World world, double x, double y, double z) {
        int xp = (int)x;
        int zp = (int)z;
        boolean lowestsolid = false;
        boolean solidup = false;
        boolean soliddown = false;
        while (solidup || !soliddown) {
            solidup = ReikaWorldHelper.getMaterial(world, xp, (int)y, zp) != Material.field_151579_a;
            boolean bl = soliddown = ReikaWorldHelper.getMaterial(world, xp, (int)y - 1, zp) != Material.field_151579_a;
            if (solidup && soliddown) {
                y += 1.0;
            }
            if (solidup && !soliddown) {
                y += 2.0;
            }
            if (solidup || soliddown) {
                // empty if block
            }
            if (solidup || soliddown) continue;
            y -= 1.0;
        }
        return y;
    }

    public static double findWaterSurface(World world, double x, double y, double z) {
        int xp = (int)x;
        int zp = (int)z;
        boolean lowestwater = false;
        boolean waterup = false;
        boolean waterdown = false;
        while (waterup || !waterdown) {
            waterup = ReikaWorldHelper.getMaterial(world, xp, (int)y, zp) == Material.field_151586_h;
            boolean bl = waterdown = ReikaWorldHelper.getMaterial(world, xp, (int)y - 1, zp) == Material.field_151586_h;
            if (waterup && waterdown) {
                y += 1.0;
            }
            if (waterup && !waterdown) {
                return y + 3.0;
            }
            if (waterup || waterdown) {
                // empty if block
            }
            if (waterup || waterdown) continue;
            y -= 1.0;
        }
        return y;
    }

    public static double findFluidSurface(World world, double x, double y, double z) {
        int xp = (int)x;
        int zp = (int)z;
        boolean lowestfluid = false;
        boolean fluidup = false;
        boolean fluiddown = false;
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)world.func_147439_a(xp, (int)y, zp));
        if (f == null) {
            return y + 3.0;
        }
        while (fluidup || !fluiddown) {
            fluidup = ReikaWorldHelper.getFluid(world, xp, (int)y, zp) == f;
            boolean bl = fluiddown = ReikaWorldHelper.getFluid(world, xp, (int)y - 1, zp) == f;
            if (fluidup && fluiddown) {
                y += 1.0;
            }
            if (fluidup && !fluiddown) {
                return y + 3.0;
            }
            if (fluidup || fluiddown) {
                // empty if block
            }
            if (fluidup || fluiddown) continue;
            y -= 1.0;
        }
        return y;
    }

    public static boolean findNearBlock(World world, int x, int y, int z, int range, Block id) {
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    if (world.func_147439_a(x + i, y + j, z + k) != id) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean findNearBlock(World world, int x, int y, int z, int range, Block id, int meta) {
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    if (world.func_147439_a(x + i, y + j, z + k) != id || world.func_72805_g(x + i, y + j, z + k) != meta) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int findNearBlocks(World world, int x, int y, int z, int range, Block id) {
        int count = 0;
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    if (world.func_147439_a(x + i, y + j, z + k) != id) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static int isLookingAt(World world, int x, int y, int z, int range, Block id, int f) {
        Block idfound = Blocks.field_150350_a;
        switch (f) {
            case 0: {
                for (int i = 0; i < range; ++i) {
                    idfound = world.func_147439_a(x, y, z - i);
                    if (idfound != id) continue;
                    return i;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < range; ++i) {
                    idfound = world.func_147439_a(x - i, y, z);
                    if (idfound != id) continue;
                    return i;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < range; ++i) {
                    idfound = world.func_147439_a(x, y, z + i);
                    if (idfound != id) continue;
                    return i;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < range; ++i) {
                    idfound = world.func_147439_a(x + i, y, z);
                    if (idfound != id) continue;
                    return i;
                }
                break;
            }
        }
        return 0;
    }

    public static ForgeDirection checkForAdjNonCube(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            Block id2;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (!world.func_72904_c(dx, dy, dz, dx, dy, dz) || (id2 = world.func_147439_a(dx, dy, dz)).func_149662_c()) continue;
            return dir;
        }
        return null;
    }

    public static ForgeDirection checkForAdjBlock(World world, int x, int y, int z, Block id) {
        for (int i = 0; i < 6; ++i) {
            Block id2;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (!world.func_72904_c(dx, dy, dz, dx, dy, dz) || id != (id2 = world.func_147439_a(dx, dy, dz))) continue;
            return dir;
        }
        return null;
    }

    public static Coordinate checkForAdjBlockWithCorners(World world, int x, int y, int z, Block id) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    Block id2;
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    if (!world.func_72904_c(dx, dy, dz, dx, dy, dz) || id != (id2 = world.func_147439_a(dx, dy, dz))) continue;
                    return new Coordinate(i, j, k);
                }
            }
        }
        return null;
    }

    public static ForgeDirection checkForAdjBlock(World world, int x, int y, int z, Block id, int meta) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (!world.func_72904_c(dx, dy, dz, dx, dy, dz)) continue;
            Block id2 = world.func_147439_a(dx, dy, dz);
            int meta2 = world.func_72805_g(dx, dy, dz);
            if (id != id2 || meta2 != meta && meta != -1) continue;
            return dir;
        }
        return null;
    }

    public static ForgeDirection checkForAdjMaterial(World world, int x, int y, int z, Material mat) {
        for (int i = 0; i < 6; ++i) {
            Material mat2;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (!world.func_72904_c(dx, dy, dz, dx, dy, dz) || !ReikaBlockHelper.matchMaterialsLoosely(mat, mat2 = ReikaWorldHelper.getMaterial(world, dx, dy, dz))) continue;
            return dir;
        }
        return null;
    }

    public static ForgeDirection checkForAdjSourceBlock(World world, int x, int y, int z, Material mat) {
        for (int i = 0; i < 6; ++i) {
            Material mat2;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (!world.func_72904_c(dx, dy, dz, dx, dy, dz) || mat != (mat2 = ReikaWorldHelper.getMaterial(world, dx, dy, dz)) || world.func_72805_g(dx, dy, dz) != 0) continue;
            return dir;
        }
        return null;
    }

    public static ForgeDirection checkForAdjTile(World world, int x, int y, int z, Class<? extends TileEntity> c, boolean inherit) {
        for (int i = 0; i < 6; ++i) {
            TileEntity te;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (!world.func_72904_c(dx, dy, dz, dx, dy, dz) || (te = world.func_147438_o(dx, dy, dz)) == null || te.getClass() != c && (!inherit || !te.getClass().isAssignableFrom(c))) continue;
            return dir;
        }
        return null;
    }

    public static void changeAdjBlock(World world, int x, int y, int z, ForgeDirection side, Block id, int meta) {
        int dx = x + side.offsetX;
        int dy = y + side.offsetY;
        int dz = z + side.offsetZ;
        if (world.func_72904_c(dx, dy, dz, dx, dy, dz)) {
            world.func_147465_d(dx, dy, dz, id, meta, 3);
        }
    }

    public static void temperatureEnvironment(World world, int x, int y, int z, int temperature) {
        int i;
        if (temperature < 0) {
            for (i = 0; i < 6; ++i) {
                ForgeDirection side = ReikaWorldHelper.checkForAdjMaterial(world, x, y, z, Material.field_151586_h);
                if (side == null) continue;
                ReikaWorldHelper.changeAdjBlock(world, x, y, z, side, Blocks.field_150432_aD, 0);
            }
        }
        if (temperature > 450) {
            for (i = 0; i < 4; ++i) {
                if (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151575_d) {
                    ReikaWorldHelper.ignite(world, x - i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151575_d) {
                    ReikaWorldHelper.ignite(world, x + i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151575_d) {
                    ReikaWorldHelper.ignite(world, x, y - i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151575_d) {
                    ReikaWorldHelper.ignite(world, x, y + i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151575_d) {
                    ReikaWorldHelper.ignite(world, x, y, z - i);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151575_d) continue;
                ReikaWorldHelper.ignite(world, x, y, z + i);
            }
        }
        if (temperature > 600) {
            for (i = 0; i < 4; ++i) {
                if (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151580_n) {
                    ReikaWorldHelper.ignite(world, x - i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151580_n) {
                    ReikaWorldHelper.ignite(world, x + i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151580_n) {
                    ReikaWorldHelper.ignite(world, x, y - i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151580_n) {
                    ReikaWorldHelper.ignite(world, x, y + i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151580_n) {
                    ReikaWorldHelper.ignite(world, x, y, z - i);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151580_n) continue;
                ReikaWorldHelper.ignite(world, x, y, z + i);
            }
        }
        if (temperature > 300) {
            for (i = 0; i < 4; ++i) {
                if (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151590_u) {
                    ReikaWorldHelper.ignite(world, x - i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151590_u) {
                    ReikaWorldHelper.ignite(world, x + i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151590_u) {
                    ReikaWorldHelper.ignite(world, x, y - i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151590_u) {
                    ReikaWorldHelper.ignite(world, x, y + i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151590_u) {
                    ReikaWorldHelper.ignite(world, x, y, z - i);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151590_u) continue;
                ReikaWorldHelper.ignite(world, x, y, z + i);
            }
        }
        if (temperature > 230) {
            for (i = 0; i < 4; ++i) {
                if (ReikaWorldHelper.flammable((IBlockAccess)world, x - i, y, z) && (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151584_j || ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151582_l || ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151585_k || ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151569_G)) {
                    ReikaWorldHelper.ignite(world, x - i, y, z);
                }
                if (ReikaWorldHelper.flammable((IBlockAccess)world, x + i, y, z) && (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151584_j || ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151582_l || ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151585_k || ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151569_G)) {
                    ReikaWorldHelper.ignite(world, x + i, y, z);
                }
                if (ReikaWorldHelper.flammable((IBlockAccess)world, x, y - i, z) && (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151584_j || ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151582_l || ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151585_k || ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151569_G)) {
                    ReikaWorldHelper.ignite(world, x, y - i, z);
                }
                if (ReikaWorldHelper.flammable((IBlockAccess)world, x, y + i, z) && (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151584_j || ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151582_l || ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151585_k || ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151569_G)) {
                    ReikaWorldHelper.ignite(world, x, y + i, z);
                }
                if (ReikaWorldHelper.flammable((IBlockAccess)world, x, y, z - i) && (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151584_j || ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151582_l || ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151585_k || ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151569_G)) {
                    ReikaWorldHelper.ignite(world, x, y, z - i);
                }
                if (!ReikaWorldHelper.flammable((IBlockAccess)world, x, y, z + i) || ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151584_j && ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151582_l && ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151585_k && ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151569_G) continue;
                ReikaWorldHelper.ignite(world, x, y, z + i);
            }
        }
        if (temperature > 0) {
            for (i = 0; i < 3; ++i) {
                if (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151588_w) {
                    world.func_147449_b(x - i, y, z, (Block)Blocks.field_150358_i);
                }
                if (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151588_w) {
                    world.func_147449_b(x + i, y, z, (Block)Blocks.field_150358_i);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151588_w) {
                    world.func_147449_b(x, y - i, z, (Block)Blocks.field_150358_i);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151588_w) {
                    world.func_147449_b(x, y + i, z, (Block)Blocks.field_150358_i);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151588_w) {
                    world.func_147449_b(x, y, z - i, (Block)Blocks.field_150358_i);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151588_w) continue;
                world.func_147449_b(x, y, z + i, (Block)Blocks.field_150358_i);
            }
        }
        if (temperature > 0) {
            for (i = 0; i < 3; ++i) {
                if (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151597_y) {
                    world.func_147468_f(x - i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151597_y) {
                    world.func_147468_f(x + i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151597_y) {
                    world.func_147468_f(x, y - i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151597_y) {
                    world.func_147468_f(x, y + i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151597_y) {
                    world.func_147468_f(x, y, z - i);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z + i) == Material.field_151597_y) {
                    world.func_147468_f(x, y, z + i);
                }
                if (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151596_z) {
                    world.func_147468_f(x - i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151596_z) {
                    world.func_147468_f(x + i, y, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151596_z) {
                    world.func_147468_f(x, y - i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151596_z) {
                    world.func_147468_f(x, y + i, z);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151596_z) {
                    world.func_147468_f(x, y, z - i);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151596_z) continue;
                world.func_147468_f(x, y, z + i);
            }
        }
        if (temperature > 900) {
            for (i = 0; i < 3; ++i) {
                if (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151595_p) {
                    world.func_147449_b(x - i, y, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151595_p) {
                    world.func_147449_b(x + i, y, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151595_p) {
                    world.func_147449_b(x, y - i, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151595_p) {
                    world.func_147449_b(x, y + i, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151595_p) {
                    world.func_147449_b(x, y, z - i, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z + i) == Material.field_151595_p) {
                    world.func_147449_b(x, y, z + i, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151578_c) {
                    world.func_147449_b(x - i, y, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151578_c) {
                    world.func_147449_b(x + i, y, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151578_c) {
                    world.func_147449_b(x, y - i, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151578_c) {
                    world.func_147449_b(x, y + i, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151578_c) {
                    world.func_147449_b(x, y, z - i, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z + i) == Material.field_151578_c) {
                    world.func_147449_b(x, y, z + i, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x - i, y, z) == Material.field_151577_b) {
                    world.func_147449_b(x - i, y, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x + i, y, z) == Material.field_151577_b) {
                    world.func_147449_b(x + i, y, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y - i, z) == Material.field_151577_b) {
                    world.func_147449_b(x, y - i, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y + i, z) == Material.field_151577_b) {
                    world.func_147449_b(x, y + i, z, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z - i) == Material.field_151577_b) {
                    world.func_147449_b(x, y, z - i, Blocks.field_150359_w);
                }
                if (ReikaWorldHelper.getMaterial(world, x, y, z + i) != Material.field_151577_b) continue;
                world.func_147449_b(x, y, z + i, Blocks.field_150359_w);
            }
        }
        if (temperature > 1500) {
            for (i = 0; i < 3; ++i) {
                if (ReikaWorldHelper.isMeltable(world, x - i, y, z, temperature)) {
                    world.func_147449_b(x - i, y, z, (Block)Blocks.field_150356_k);
                }
                if (ReikaWorldHelper.isMeltable(world, x + i, y, z, temperature)) {
                    world.func_147449_b(x + i, y, z, (Block)Blocks.field_150356_k);
                }
                if (ReikaWorldHelper.isMeltable(world, x, y - i, z, temperature)) {
                    world.func_147449_b(x, y - i, z, (Block)Blocks.field_150356_k);
                }
                if (ReikaWorldHelper.isMeltable(world, x, y + i, z, temperature)) {
                    world.func_147449_b(x, y + i, z, (Block)Blocks.field_150356_k);
                }
                if (ReikaWorldHelper.isMeltable(world, x, y, z - i, temperature)) {
                    world.func_147449_b(x, y, z - i, (Block)Blocks.field_150356_k);
                }
                if (!ReikaWorldHelper.isMeltable(world, x, y, z + i, temperature)) continue;
                world.func_147449_b(x, y, z + i, (Block)Blocks.field_150356_k);
            }
        }
    }

    public static boolean isMeltable(World world, int x, int y, int z, int temperature) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a || b == Blocks.field_150357_h) {
            return false;
        }
        if (b == Blocks.field_150343_Z) {
            return temperature > 1800;
        }
        Material m = b.func_149688_o();
        if (m == Material.field_151576_e) {
            return temperature > 1500;
        }
        if (m == Material.field_151573_f) {
            return temperature > 2000;
        }
        return false;
    }

    public static void ignite(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
            return;
        }
        if (world.func_147439_a(x - 1, y, z) == Blocks.field_150350_a) {
            world.func_147449_b(x - 1, y, z, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x + 1, y, z) == Blocks.field_150350_a) {
            world.func_147449_b(x + 1, y, z, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150350_a) {
            world.func_147449_b(x, y - 1, z, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a) {
            world.func_147449_b(x, y + 1, z, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x, y, z - 1) == Blocks.field_150350_a) {
            world.func_147449_b(x, y, z - 1, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x, y, z + 1) == Blocks.field_150350_a) {
            world.func_147449_b(x, y, z + 1, (Block)Blocks.field_150480_ab);
        }
    }

    public static int getDepth(World world, int x, int y, int z, String liq) {
        int i = 1;
        if (liq.equals("water")) {
            while (world.func_147439_a(x, y + i, z) == Blocks.field_150358_i || world.func_147439_a(x, y + i, z) == Blocks.field_150355_j) {
                ++i;
            }
            return i - 1;
        }
        if (liq.equals("lava")) {
            while (world.func_147439_a(x, y + i, z) == Blocks.field_150356_k || world.func_147439_a(x, y + i, z) == Blocks.field_150353_l) {
                ++i;
            }
            return i - 1;
        }
        return -1;
    }

    public static boolean caveBlock(Block id) {
        return id == Blocks.field_150350_a || id == Blocks.field_150358_i || id == Blocks.field_150355_j || id == Blocks.field_150356_k || id == Blocks.field_150353_l || id == Blocks.field_150321_G || id == Blocks.field_150474_ac || id == Blocks.field_150337_Q || id == Blocks.field_150338_P;
    }

    public static void overheat(World world, int x, int y, int z, ItemStack drop, int mindrops, int maxdrops, boolean sparks, float sparkmultiplier, boolean flaming, boolean smoke, float force) {
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
        if (force > 0.0f && !world.field_72995_K) {
            if (flaming) {
                world.func_72885_a(null, (double)x, (double)y, (double)z, force, true, smoke);
            } else {
                world.func_72876_a(null, (double)x, (double)y, (double)z, force, smoke);
            }
        }
        int numsparks = rand.nextInt(20) + 20;
        numsparks = (int)((float)numsparks * sparkmultiplier);
        if (sparks) {
            for (int i = 0; i < numsparks; ++i) {
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)(y + 1), (double)((float)z + rand.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
        if (drop != null) {
            ItemStack scrap = drop.func_77946_l();
            int numdrops = rand.nextInt(1 + maxdrops - mindrops) + mindrops;
            if (!world.field_72995_K) {
                for (int i = 0; i < numdrops; ++i) {
                    EntityItem ent = new EntityItem(world, (double)((float)x + rand.nextFloat()), (double)y + 0.5, (double)((float)z + rand.nextFloat()), scrap);
                    ent.field_70159_w = -0.2 + 0.4 * (double)rand.nextFloat();
                    ent.field_70181_x = 0.5 * (double)rand.nextFloat();
                    ent.field_70179_y = -0.2 + 0.4 * (double)rand.nextFloat();
                    world.func_72838_d((Entity)ent);
                    ent.field_70133_I = true;
                }
            }
        }
    }

    public static void splitAndSpawnXP(World world, double x, double y, double z, int xp) {
        ReikaWorldHelper.splitAndSpawnXP(world, x, y, z, xp, 6000);
    }

    public static void splitAndSpawnXP(World world, double x, double y, double z, int xp, int life) {
        int max = xp / 5 + 1;
        while (xp > 0) {
            int value = rand.nextInt(max) + 1;
            while (value > xp) {
                value = rand.nextInt(max) + 1;
            }
            xp -= value;
            EntityXPOrb orb = new EntityXPOrb(world, x, y, z, value);
            orb.field_70159_w = -0.2 + 0.4 * (double)rand.nextFloat();
            orb.field_70181_x = 0.3 * (double)rand.nextFloat();
            orb.field_70179_y = -0.2 + 0.4 * (double)rand.nextFloat();
            orb.field_70531_b = 6000 - life;
            if (world.field_72995_K) continue;
            orb.field_70133_I = true;
            world.func_72838_d((Entity)orb);
        }
    }

    public static boolean is1p9InfiniteLava(World world, int x, int y, int z) {
        if (ReikaWorldHelper.getMaterial(world, x, y, z) != Material.field_151587_i || world.func_72805_g(x, y, z) != 0) {
            return false;
        }
        if (ReikaWorldHelper.getMaterial(world, x + 1, y, z) != Material.field_151587_i || world.func_72805_g(x + 1, y, z) != 0) {
            return false;
        }
        if (ReikaWorldHelper.getMaterial(world, x, y, z + 1) != Material.field_151587_i || world.func_72805_g(x, y, z + 1) != 0) {
            return false;
        }
        if (ReikaWorldHelper.getMaterial(world, x - 1, y, z) != Material.field_151587_i || world.func_72805_g(x - 1, y, z) != 0) {
            return false;
        }
        return ReikaWorldHelper.getMaterial(world, x, y, z - 1) == Material.field_151587_i && world.func_72805_g(x, y, z - 1) == 0;
    }

    public static int findTopBlockBelowY(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        while (b == Blocks.field_150350_a && y >= 0) {
            b = world.func_147439_a(x, --y, z);
        }
        return y;
    }

    public static boolean isLiquidSourceBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        if (b instanceof BlockFluidFinite) {
            return meta == 7;
        }
        if (meta != 0) {
            return false;
        }
        return b instanceof BlockLiquid || b instanceof BlockFluidBase;
    }

    public static void recursiveBreak(World world, int x, int y, int z, Block id, int meta) {
        if (id == Blocks.field_150350_a) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (meta != world.func_72805_g(x, y, z) && meta != -1) {
            return;
        }
        int metad = world.func_72805_g(x, y, z);
        ReikaItemHelper.dropItems(world, x, y, z, id.getDrops(world, x, y, z, metad, 0));
        ReikaSoundHelper.playBreakSound(world, x, y, z, id);
        world.func_147468_f(x, y, z);
        world.func_147471_g(x, y, z);
        ReikaWorldHelper.recursiveBreak(world, x + 1, y, z, id, meta);
        ReikaWorldHelper.recursiveBreak(world, x - 1, y, z, id, meta);
        ReikaWorldHelper.recursiveBreak(world, x, y + 1, z, id, meta);
        ReikaWorldHelper.recursiveBreak(world, x, y - 1, z, id, meta);
        ReikaWorldHelper.recursiveBreak(world, x, y, z + 1, id, meta);
        ReikaWorldHelper.recursiveBreak(world, x, y, z - 1, id, meta);
    }

    public static void recursiveBreakWithinSphere(World world, int x, int y, int z, Block id, int meta, int x0, int y0, int z0, double r) {
        if (id == Blocks.field_150350_a) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (meta != world.func_72805_g(x, y, z) && meta != -1) {
            return;
        }
        if (ReikaMathLibrary.py3d(x - x0, y - y0, z - z0) > r) {
            return;
        }
        int metad = world.func_72805_g(x, y, z);
        ReikaItemHelper.dropItems(world, x, y, z, id.getDrops(world, x, y, z, metad, 0));
        ReikaSoundHelper.playBreakSound(world, x, y, z, id);
        world.func_147468_f(x, y, z);
        world.func_147471_g(x, y, z);
        ReikaWorldHelper.recursiveBreakWithinSphere(world, x + 1, y, z, id, meta, x0, y0, z0, r);
        ReikaWorldHelper.recursiveBreakWithinSphere(world, x - 1, y, z, id, meta, x0, y0, z0, r);
        ReikaWorldHelper.recursiveBreakWithinSphere(world, x, y + 1, z, id, meta, x0, y0, z0, r);
        ReikaWorldHelper.recursiveBreakWithinSphere(world, x, y - 1, z, id, meta, x0, y0, z0, r);
        ReikaWorldHelper.recursiveBreakWithinSphere(world, x, y, z + 1, id, meta, x0, y0, z0, r);
        ReikaWorldHelper.recursiveBreakWithinSphere(world, x, y, z - 1, id, meta, x0, y0, z0, r);
    }

    public static void recursiveBreakWithBounds(World world, int x, int y, int z, Block id, int meta, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (id == Blocks.field_150350_a) {
            return;
        }
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (meta != world.func_72805_g(x, y, z) && meta != -1) {
            return;
        }
        int metad = world.func_72805_g(x, y, z);
        ReikaItemHelper.dropItems(world, x, y, z, id.getDrops(world, x, y, z, metad, 0));
        ReikaSoundHelper.playBreakSound(world, x, y, z, id);
        world.func_147468_f(x, y, z);
        world.func_147471_g(x, y, z);
        ReikaWorldHelper.recursiveBreakWithBounds(world, x + 1, y, z, id, meta, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveBreakWithBounds(world, x - 1, y, z, id, meta, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveBreakWithBounds(world, x, y + 1, z, id, meta, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveBreakWithBounds(world, x, y - 1, z, id, meta, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveBreakWithBounds(world, x, y, z + 1, id, meta, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveBreakWithBounds(world, x, y, z - 1, id, meta, x1, y1, z1, x2, y2, z2);
    }

    public static void recursiveFill(World world, int x, int y, int z, Block id, Block idto, int meta, int metato) {
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (meta != world.func_72805_g(x, y, z) && meta != -1) {
            return;
        }
        int metad = world.func_72805_g(x, y, z);
        world.func_147465_d(x, y, z, idto, metato, 3);
        world.func_147471_g(x, y, z);
        ReikaWorldHelper.recursiveFill(world, x + 1, y, z, id, idto, meta, metato);
        ReikaWorldHelper.recursiveFill(world, x - 1, y, z, id, idto, meta, metato);
        ReikaWorldHelper.recursiveFill(world, x, y + 1, z, id, idto, meta, metato);
        ReikaWorldHelper.recursiveFill(world, x, y - 1, z, id, idto, meta, metato);
        ReikaWorldHelper.recursiveFill(world, x, y, z + 1, id, idto, meta, metato);
        ReikaWorldHelper.recursiveFill(world, x, y, z - 1, id, idto, meta, metato);
    }

    public static void recursiveFillWithBounds(World world, int x, int y, int z, Block id, Block idto, int meta, int metato, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (x < x1 || y < y1 || z < z1 || x > x2 || y > y2 || z > z2) {
            return;
        }
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (meta != world.func_72805_g(x, y, z) && meta != -1) {
            return;
        }
        int metad = world.func_72805_g(x, y, z);
        world.func_147465_d(x, y, z, idto, metato, 3);
        world.func_147471_g(x, y, z);
        ReikaWorldHelper.recursiveFillWithBounds(world, x + 1, y, z, id, idto, meta, metato, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveFillWithBounds(world, x - 1, y, z, id, idto, meta, metato, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveFillWithBounds(world, x, y + 1, z, id, idto, meta, metato, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveFillWithBounds(world, x, y - 1, z, id, idto, meta, metato, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveFillWithBounds(world, x, y, z + 1, id, idto, meta, metato, x1, y1, z1, x2, y2, z2);
        ReikaWorldHelper.recursiveFillWithBounds(world, x, y, z - 1, id, idto, meta, metato, x1, y1, z1, x2, y2, z2);
    }

    public static void recursiveFillWithinSphere(World world, int x, int y, int z, Block id, Block idto, int meta, int metato, int x0, int y0, int z0, double r) {
        if (world.func_147439_a(x, y, z) != id) {
            return;
        }
        if (meta != world.func_72805_g(x, y, z) && meta != -1) {
            return;
        }
        if (ReikaMathLibrary.py3d(x - x0, y - y0, z - z0) > r) {
            return;
        }
        int metad = world.func_72805_g(x, y, z);
        world.func_147465_d(x, y, z, idto, metato, 3);
        world.func_147471_g(x, y, z);
        ReikaWorldHelper.recursiveFillWithinSphere(world, x + 1, y, z, id, idto, meta, metato, x0, y0, z0, r);
        ReikaWorldHelper.recursiveFillWithinSphere(world, x - 1, y, z, id, idto, meta, metato, x0, y0, z0, r);
        ReikaWorldHelper.recursiveFillWithinSphere(world, x, y + 1, z, id, idto, meta, metato, x0, y0, z0, r);
        ReikaWorldHelper.recursiveFillWithinSphere(world, x, y - 1, z, id, idto, meta, metato, x0, y0, z0, r);
        ReikaWorldHelper.recursiveFillWithinSphere(world, x, y, z + 1, id, idto, meta, metato, x0, y0, z0, r);
        ReikaWorldHelper.recursiveFillWithinSphere(world, x, y, z - 1, id, idto, meta, metato, x0, y0, z0, r);
    }

    public static boolean lineOfSight(World world, double x1, double y1, double z1, double x2, double y2, double z2) {
        Vec3 v2;
        Vec3 v1;
        if (world.field_72995_K) {
            // empty if block
        }
        return world.func_72933_a(v1 = Vec3.func_72443_a((double)x1, (double)y1, (double)z1), v2 = Vec3.func_72443_a((double)x2, (double)y2, (double)z2)) == null;
    }

    public static boolean lineOfSight(World world, Entity e1, Entity e2) {
        Vec3 v2;
        Vec3 v1 = Vec3.func_72443_a((double)e1.field_70165_t, (double)(e1.field_70163_u + (double)e1.func_70047_e()), (double)e1.field_70161_v);
        return world.func_72933_a(v1, v2 = Vec3.func_72443_a((double)e2.field_70165_t, (double)(e2.field_70163_u + (double)e2.func_70047_e()), (double)e2.field_70161_v)) == null;
    }

    public static boolean canBlockSee(World world, int x, int y, int z, double x0, double y0, double z0, double range) {
        Block locid = world.func_147439_a(x, y, z);
        range += 2.0;
        for (int k = 0; k < 10; ++k) {
            float a = 0.0f;
            float b = 0.0f;
            float c = 0.0f;
            switch (k) {
                case 1: {
                    a = 1.0f;
                    break;
                }
                case 2: {
                    b = 1.0f;
                    break;
                }
                case 3: {
                    a = 1.0f;
                    b = 1.0f;
                    break;
                }
                case 4: {
                    c = 1.0f;
                    break;
                }
                case 5: {
                    a = 1.0f;
                    c = 1.0f;
                    break;
                }
                case 6: {
                    b = 1.0f;
                    c = 1.0f;
                    break;
                }
                case 7: {
                    a = 1.0f;
                    b = 1.0f;
                    c = 1.0f;
                    break;
                }
                case 8: {
                    a = 0.5f;
                    b = 0.5f;
                    c = 0.5f;
                    break;
                }
                case 9: {
                    b = 0.5f;
                }
            }
            float i = 0.0f;
            while ((double)i <= range) {
                Vec3 vec2 = ReikaVectorHelper.getVec2Pt((float)x + a, (float)y + b, (float)z + c, x0, y0, z0).func_72432_b();
                vec2 = ReikaVectorHelper.scaleVector(vec2, i);
                vec2.field_72450_a += x0;
                vec2.field_72448_b += y0;
                vec2.field_72449_c += z0;
                int dx = MathHelper.func_76128_c((double)vec2.field_72450_a);
                int dy = MathHelper.func_76128_c((double)vec2.field_72448_b);
                int dz = MathHelper.func_76128_c((double)vec2.field_72449_c);
                Block id = world.func_147439_a(dx, dy, dz);
                if (dx == x && dy == y && dz == z) {
                    return true;
                }
                if (id != locid && ReikaBlockHelper.isCollideable(world, dx, dy, dz) && !ReikaWorldHelper.softBlocks((IBlockAccess)world, dx, dy, dz)) {
                    i = (float)(range + 1.0);
                }
                i = (float)((double)i + 0.25);
            }
        }
        return false;
    }

    public static boolean rayTraceTwoBlocks(World world, int x1, int y1, int z1, int x2, int y2, int z2, float a, float b, float c) {
        Vec3 vec1 = Vec3.func_72443_a((double)((float)x1 + a), (double)((float)y1 + b), (double)((float)z1 + c));
        Vec3 vec2 = Vec3.func_72443_a((double)((float)x2 + a), (double)((float)y2 + b), (double)((float)z2 + c));
        Vec3 ray = ReikaVectorHelper.subtract(vec1, vec2);
        double dx = vec2.field_72450_a - vec1.field_72450_a;
        double dy = vec2.field_72448_b - vec1.field_72448_b;
        double dz = vec2.field_72449_c - vec1.field_72449_c;
        double dd = ReikaMathLibrary.py3d(dx, dy, dz);
        for (double d = 0.25; d <= dd; d += 0.5) {
            Vec3 vec0 = ReikaVectorHelper.scaleVector(ray, d);
            Vec3 vec = ReikaVectorHelper.scaleVector(ray, d - 0.25);
            vec0.field_72450_a += vec1.field_72450_a;
            vec0.field_72448_b += vec1.field_72448_b;
            vec0.field_72449_c += vec1.field_72449_c;
            vec.field_72450_a += vec1.field_72450_a;
            vec.field_72448_b += vec1.field_72448_b;
            vec.field_72449_c += vec1.field_72449_c;
            MovingObjectPosition mov = world.func_72933_a(vec, vec0);
            if (mov == null || mov.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) continue;
            int bx = mov.field_72311_b;
            int by = mov.field_72312_c;
            int bz = mov.field_72309_d;
            if (bx == x1 && by == y1 && bz == z1 || bx == x2 && by == y2 && bz == z2 || ReikaWorldHelper.softBlocks((IBlockAccess)world, bx, by, bz) || !ReikaBlockHelper.isCollideable(world, bx, by, bz)) continue;
            return false;
        }
        return true;
    }

    public static boolean rayTraceTwoBlocks(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        return ReikaWorldHelper.rayTraceTwoBlocks(world, x1, y1, z1, x2, y2, z2, 0.5f, 0.5f, 0.5f);
    }

    public static boolean canSeeOrMoveToSeeBlock(World world, int x, int y, int z, Entity ent, double r) {
        double d = 4.0;
        if (ReikaWorldHelper.canBlockSee(world, x, y, z, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, d)) {
            return true;
        }
        double[] pos = new double[3];
        boolean[] signs = new boolean[3];
        boolean[] signs2 = new boolean[3];
        signs[0] = ReikaMathLibrary.isSameSign(ent.field_70165_t, x);
        signs[1] = ReikaMathLibrary.isSameSign(ent.field_70163_u, y);
        signs[2] = ReikaMathLibrary.isSameSign(ent.field_70161_v, z);
        for (double i = ent.field_70165_t - r; i <= ent.field_70165_t + r; i += 0.5) {
            for (double j = ent.field_70163_u - r; j <= ent.field_70163_u + r; j += 0.5) {
                for (double k = ent.field_70161_v - r; k <= ent.field_70161_v + r; k += 0.5) {
                    if (!ReikaWorldHelper.canBlockSee(world, x, y, z, ent.field_70165_t + i, ent.field_70163_u + j, ent.field_70161_v + k, d)) continue;
                    return true;
                }
            }
        }
        signs2[0] = ReikaMathLibrary.isSameSign(pos[0], x);
        signs2[1] = ReikaMathLibrary.isSameSign(pos[1], y);
        signs2[2] = ReikaMathLibrary.isSameSign(pos[2], z);
        if (signs[0] != signs2[0] || signs[1] != signs2[1] || signs[2] != signs2[2]) {
            return false;
        }
        return false;
    }

    public static boolean cornerHasAirAdjacent(World world, int x, int y, int z) {
        if (y <= 0) {
            return false;
        }
        int airs = 0;
        if (world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
            ++airs;
        }
        if (world.func_147439_a(x - 1, y, z) == Blocks.field_150350_a) {
            ++airs;
        }
        if (world.func_147439_a(x, y, z - 1) == Blocks.field_150350_a) {
            ++airs;
        }
        if (world.func_147439_a(x - 1, y, z - 1) == Blocks.field_150350_a) {
            ++airs;
        }
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150350_a) {
            ++airs;
        }
        if (world.func_147439_a(x - 1, y - 1, z) == Blocks.field_150350_a) {
            ++airs;
        }
        if (world.func_147439_a(x, y - 1, z - 1) == Blocks.field_150350_a) {
            ++airs;
        }
        if (world.func_147439_a(x - 1, y - 1, z - 1) == Blocks.field_150350_a) {
            ++airs;
        }
        return airs > 0 && airs != 8;
    }

    public static boolean cornerHasTransAdjacent(World world, int x, int y, int z) {
        if (y <= 0) {
            return false;
        }
        int airs = 0;
        boolean nonopq = false;
        Block id = world.func_147439_a(x, y, z);
        if (id == Blocks.field_150350_a) {
            ++airs;
        } else if (!id.func_149662_c()) {
            nonopq = true;
        }
        id = world.func_147439_a(x - 1, y, z);
        if (id == Blocks.field_150350_a) {
            ++airs;
        } else if (!id.func_149662_c()) {
            nonopq = true;
        }
        id = world.func_147439_a(x, y, z - 1);
        if (id == Blocks.field_150350_a) {
            ++airs;
        } else if (!id.func_149662_c()) {
            nonopq = true;
        }
        id = world.func_147439_a(x - 1, y, z - 1);
        if (id == Blocks.field_150350_a) {
            ++airs;
        } else if (!id.func_149662_c()) {
            nonopq = true;
        }
        id = world.func_147439_a(x, y - 1, z);
        if (id == Blocks.field_150350_a) {
            ++airs;
        } else if (!id.func_149662_c()) {
            nonopq = true;
        }
        id = world.func_147439_a(x - 1, y - 1, z);
        if (id == Blocks.field_150350_a) {
            ++airs;
        } else if (!id.func_149662_c()) {
            nonopq = true;
        }
        id = world.func_147439_a(x, y - 1, z - 1);
        if (id == Blocks.field_150350_a) {
            ++airs;
        } else if (!id.func_149662_c()) {
            nonopq = true;
        }
        id = world.func_147439_a(x - 1, y - 1, z - 1);
        if (id == Blocks.field_150350_a) {
            ++airs;
        } else if (!id.func_149662_c()) {
            nonopq = true;
        }
        return airs != 8 && nonopq;
    }

    public static void spawnParticleLine(World world, double x1, double y1, double z1, double x2, double y2, double z2, String name, double vx, double vy, double vz, int spacing) {
        int i;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double sx = dx / (double)spacing;
        double sy = dy / (double)spacing;
        double sz = dy / (double)spacing;
        double[][] parts = new double[spacing + 1][3];
        for (i = 0; i <= spacing; ++i) {
            parts[i][0] = (double)i * sx + x1;
            parts[i][1] = (double)i * sy + y1;
            parts[i][2] = (double)i * sz + z1;
        }
        for (i = 0; i < parts.length; ++i) {
            world.func_72869_a(name, parts[i][0], parts[i][1], parts[i][2], vx, vy, vz);
        }
    }

    public static boolean isLiquidAColumn(World world, int x, int y, int z) {
        Fluid f = ReikaWorldHelper.getFluid(world, x, y, z);
        if (f == null) {
            return false;
        }
        if (ReikaWorldHelper.isLiquidSourceBlock(world, x, y, z)) {
            return false;
        }
        if (ReikaWorldHelper.getFluid(world, x, y + 1, z) != f) {
            return false;
        }
        if (ReikaWorldHelper.isLiquidSourceBlock(world, x, y + 1, z)) {
            return false;
        }
        if (ReikaWorldHelper.getFluid(world, x, y - 1, z) != f) {
            return false;
        }
        return !ReikaWorldHelper.isLiquidSourceBlock(world, x, y - 1, z);
    }

    public static Fluid getFluid(World world, int x, int y, int z) {
        return FluidRegistry.lookupFluidForBlock((Block)world.func_147439_a(x, y, z));
    }

    public static void causeAdjacentUpdates(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        world.func_147459_d(x, y, z, b);
    }

    public static ArrayList<ItemStack> getDropsAt(World world, int x, int y, int z, int fortune, EntityPlayer ep) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a) {
            return new ArrayList<ItemStack>();
        }
        int meta = world.func_72805_g(x, y, z);
        ArrayList<ItemStack> li = b.getDrops(world, x, y, z, meta, fortune);
        if (ep != null) {
            if (b instanceof BlockTieredResource) {
                BlockTieredResource bt = (BlockTieredResource)b;
                li = new ArrayList<ItemStack>(bt.isPlayerSufficientTier((IBlockAccess)world, x, y, z, ep) ? bt.getHarvestResources(world, x, y, z, fortune, ep) : bt.getNoHarvestResources(world, x, y, z, fortune, ep));
            }
            BlockEvent.HarvestDropsEvent evt = new BlockEvent.HarvestDropsEvent(x, y, z, world, b, meta, fortune, 1.0f, (ArrayList)li, ep, false);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            li = evt.drops;
        }
        return li;
    }

    public static ArrayList<ItemStack> dropBlockAt(World world, int x, int y, int z, int fortune, EntityPlayer ep) {
        ArrayList<ItemStack> li = ReikaWorldHelper.getDropsAt(world, x, y, z, fortune, ep);
        ReikaItemHelper.dropItems(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, li);
        return li;
    }

    public static ArrayList<ItemStack> dropBlockAt(World world, int x, int y, int z, EntityPlayer ep) {
        return ReikaWorldHelper.dropBlockAt(world, x, y, z, 0, ep);
    }

    public static void setBiomeForXZ(World world, int x, int z, BiomeGenBase biome) {
        Chunk ch = world.func_72938_d(x, z);
        int ax = x - ch.field_76635_g * 16;
        int az = z - ch.field_76647_h * 16;
        byte[] biomes = ch.func_76605_m();
        int index = az * 16 + ax;
        if (index < 0 || index >= biomes.length) {
            DragonAPICore.logError("BIOME CHANGE ERROR: " + x + "&" + z + " @ " + ch.field_76635_g + "&" + ch.field_76647_h + ": " + ax + "%" + az + " -> " + index, Side.SERVER);
            return;
        }
        biomes[index] = (byte)biome.field_76756_M;
        ch.func_76616_a(biomes);
        ch.func_76630_e();
        for (int i = 0; i < 256; ++i) {
            ReikaWorldHelper.temperatureEnvironment(world, x, i, z, ReikaBiomeHelper.getBiomeTemp(world, biome));
        }
        if (!world.field_72995_K) {
            int packet = APIPacketHandler.PacketIDs.BIOMECHANGE.ordinal();
            ReikaPacketHelper.sendDataPacket("DragonAPIData", packet, world, x, 0, z, biome.field_76756_M);
        }
    }

    public static BiomeGenBase getNaturalGennedBiomeAt(World world, int x, int z) {
        BiomeGenBase[] biomes = world.func_72959_q().func_76933_b(null, x, z, 1, 1);
        BiomeGenBase natural = biomes != null && biomes.length > 0 ? biomes[0] : null;
        return natural;
    }

    public static void setBiomeAndBlocksForXZ(World world, int x, int z, BiomeGenBase biome) {
        int i;
        int h;
        int y;
        WorldGenAbstractTree gen;
        Chunk ch = world.func_72938_d(x, z);
        int ax = x - ch.field_76635_g * 16;
        int az = z - ch.field_76647_h * 16;
        byte[] biomes = ch.func_76605_m();
        int index = az * 16 + ax;
        if (index < 0 || index >= biomes.length) {
            DragonAPICore.logError("BIOME CHANGE ERROR: " + x + "&" + z + " @ " + ch.field_76635_g + "&" + ch.field_76647_h + ": " + ax + "%" + az + " -> " + index, Side.SERVER);
            return;
        }
        BiomeGenBase from = BiomeGenBase.field_76773_a[biomes[index]];
        biomes[index] = (byte)biome.field_76756_M;
        ch.func_76616_a(biomes);
        for (int i2 = 0; i2 < 256; ++i2) {
            ReikaWorldHelper.temperatureEnvironment(world, x, i2, z, ReikaBiomeHelper.getBiomeTemp(world, biome));
        }
        if (!world.field_72995_K) {
            int packet = APIPacketHandler.PacketIDs.BIOMECHANGE.ordinal();
            ReikaPacketHelper.sendDataPacket("DragonAPIData", packet, world, x, 0, z, biome.field_76756_M);
        }
        Block fillerID = from.field_76753_B;
        Block topID = from.field_76752_A;
        for (int y2 = 30; y2 < world.field_73011_w.getHeight(); ++y2) {
            Block id = world.func_147439_a(x, y2, z);
            if (id == fillerID) {
                world.func_147449_b(x, y2, z, biome.field_76753_B);
            }
            if (id == topID && y2 == world.func_72825_h(x, z) - 1) {
                world.func_147449_b(x, y2, z, biome.field_76752_A);
            }
            if (biome.func_76746_c()) {
                if (world.func_72834_c(x, y2, z, false)) {
                    world.func_147449_b(x, y2, z, Blocks.field_150432_aD);
                    continue;
                }
                if (!world.func_72937_j(x, y2 + 1, z) || !world.func_147437_c(x, y2 + 1, z)) continue;
                world.func_147449_b(x, y2 + 1, z, Blocks.field_150433_aE);
                continue;
            }
            if (id == Blocks.field_150433_aE) {
                world.func_147468_f(x, y2, z);
            }
            if (id != Blocks.field_150432_aD) continue;
            world.func_147449_b(x, y2, z, (Block)Blocks.field_150358_i);
        }
        if (world.field_72995_K) {
            return;
        }
        BiomeDecorator dec = biome.field_76760_I;
        int trees = dec.field_76832_z;
        int grass = dec.field_76803_B;
        int flowers = dec.field_76802_A;
        int cactus = dec.field_76800_F;
        int bushes = dec.field_76804_C;
        int sugar = dec.field_76799_E;
        int mushrooms = dec.field_76798_D;
        int lily = dec.field_76833_y;
        int bigmush = dec.field_76807_J;
        double fac = 0.3333333333333333;
        int top = world.func_72825_h(x, z);
        if (ReikaRandomHelper.doWithChance(fac * (double)trees / 96.0)) {
            gen = biome.func_150567_a(rand);
            if (ReikaPlantHelper.SAPLING.canPlantAt(world, x, top, z)) {
                if (ReikaWorldHelper.softBlocks((IBlockAccess)world, x, top, z)) {
                    world.func_147468_f(x, top, z);
                }
                gen.func_76484_a(world, rand, x, top, z);
            }
        }
        if (ReikaRandomHelper.doWithChance(fac * (double)grass / 64.0)) {
            gen = biome.func_76730_b(rand);
            if (ReikaWorldHelper.softBlocks((IBlockAccess)world, x, top, z)) {
                world.func_147468_f(x, top, z);
            }
            gen.func_76484_a(world, rand, x, top, z);
        }
        if (ReikaRandomHelper.doWithChance(fac * (double)bigmush / 96.0)) {
            if (ReikaWorldHelper.softBlocks((IBlockAccess)world, x, top, z)) {
                world.func_147468_f(x, top, z);
            }
            biome.field_76760_I.field_76826_u.func_76484_a(world, rand, x, top, z);
        }
        if (ReikaRandomHelper.doWithChance(fac * (double)cactus / 256.0) && ReikaPlantHelper.CACTUS.canPlantAt(world, x, y = world.func_72825_h(x, z), z)) {
            h = 1 + rand.nextInt(3);
            for (i = 0; i < h; ++i) {
                world.func_147449_b(x, y + i, z, Blocks.field_150434_aF);
            }
        }
        if (ReikaRandomHelper.doWithChance(fac * (double)sugar / 64.0) && ReikaPlantHelper.SUGARCANE.canPlantAt(world, x, y = world.func_72825_h(x, z), z)) {
            h = 1 + rand.nextInt(3);
            for (i = 0; i < h; ++i) {
                world.func_147449_b(x, y + i, z, Blocks.field_150436_aH);
            }
        }
        if (ReikaRandomHelper.doWithChance(fac * (double)bushes / 64.0) && ReikaPlantHelper.BUSH.canPlantAt(world, x, y = world.func_72825_h(x, z), z)) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150330_I);
        }
        if (ReikaRandomHelper.doWithChance(fac * (double)lily / 64.0) && ReikaPlantHelper.LILYPAD.canPlantAt(world, x, y = world.func_72825_h(x, z), z)) {
            world.func_147449_b(x, y, z, Blocks.field_150392_bi);
        }
        if (ReikaRandomHelper.doWithChance(fac * (double)flowers / 256.0) && ReikaPlantHelper.FLOWER.canPlantAt(world, x, y = world.func_72825_h(x, z), z)) {
            if (rand.nextInt(3) == 0) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150328_O);
            } else {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150327_N);
            }
        }
        if (ReikaRandomHelper.doWithChance(fac * 128.0 * (double)mushrooms / 256.0) && ReikaPlantHelper.MUSHROOM.canPlantAt(world, x, y = world.func_72825_h(x, z), z)) {
            if (rand.nextInt(4) == 0) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150337_Q);
            } else {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150338_P);
            }
        }
        biome.func_76728_a(world, rand, x, z);
        for (int i3 = 40; i3 < 80; ++i3) {
            world.func_147471_g(x, i3, z);
            ReikaWorldHelper.causeAdjacentUpdates(world, x, i3, z);
        }
    }

    public static float getSunIntensity(World world, boolean weather, float ptick) {
        float ang = world.func_72826_c(ptick);
        float base = 1.0f - (MathHelper.func_76134_b((float)(ang * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (base < 0.0f) {
            base = 0.0f;
        }
        if (base > 1.0f) {
            base = 1.0f;
        }
        base = 1.0f - base;
        if (weather) {
            base = (float)((double)base * (1.0 - (double)(world.func_72867_j(ptick) * 5.0f) / 16.0));
            base = (float)((double)base * (1.0 - (double)(world.func_72819_i(ptick) * 5.0f) / 16.0));
        }
        return base * 0.8f + 0.2f;
    }

    public static float getSunAngle(World world) {
        int time = (int)(world.func_72820_D() % 12000L);
        float suntheta = 0.5f * (float)(90.0 * Math.sin(Math.toRadians((double)time * 90.0 / 6000.0)));
        return suntheta;
    }

    public static boolean testBlockProximity(World world, int x, int y, int z, Block id, int meta, int r) {
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int rx = x + i;
                    int ry = y + j;
                    int rz = z + k;
                    Block rid = world.func_147439_a(rx, ry, rz);
                    int rmeta = world.func_72805_g(rx, ry, rz);
                    if (rid != id || meta != -1 && rmeta != meta) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean testLiquidProximity(World world, int x, int y, int z, Material mat, int r) {
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int rx = x + i;
                    int ry = y + j;
                    int rz = z + k;
                    Material rmat = ReikaWorldHelper.getMaterial(world, rx, ry, rz);
                    if (rmat != mat) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean testBlockProximityLoose(World world, int x, int y, int z, Block id, int meta, int r) {
        int total = r * r * r * 8;
        int frac = total / 16;
        for (int i = 0; i < frac; ++i) {
            int rx = ReikaRandomHelper.getRandomPlusMinus(x, r);
            int ry = ReikaRandomHelper.getRandomPlusMinus(y, r);
            int rz = ReikaRandomHelper.getRandomPlusMinus(z, r);
            Block rid = world.func_147439_a(rx, ry, rz);
            int rmeta = world.func_72805_g(rx, ry, rz);
            if (rid != id || meta != -1 && rmeta != meta) continue;
            return true;
        }
        return false;
    }

    public static EntityLivingBase getClosestLivingEntity(World world, double x, double y, double z, AxisAlignedBB box) {
        List li = world.func_72872_a(EntityLivingBase.class, box);
        double d = Double.MAX_VALUE;
        EntityLivingBase index = null;
        for (EntityLivingBase e : li) {
            double dd;
            if (e.field_70128_L || !(e.func_110143_aJ() > 0.0f) || !((dd = ReikaMathLibrary.py3d(e.field_70165_t - x, e.field_70163_u - y, e.field_70161_v - z)) < d)) continue;
            index = e;
            d = dd;
        }
        return index;
    }

    public static EntityLivingBase getClosestLivingEntityNoPlayers(World world, double x, double y, double z, AxisAlignedBB box, boolean excludeCreativeOnly) {
        List li = world.func_72872_a(EntityLivingBase.class, box);
        double d = Double.MAX_VALUE;
        EntityLivingBase index = null;
        for (EntityLivingBase e : li) {
            double dd;
            if (e instanceof EntityPlayer && (!excludeCreativeOnly || ((EntityPlayer)e).field_71075_bZ.field_75098_d) || e.field_70128_L || !(e.func_110143_aJ() > 0.0f) || !((dd = ReikaMathLibrary.py3d(e.field_70165_t - x, e.field_70163_u - y, e.field_70161_v - z)) < d)) continue;
            index = e;
            d = dd;
        }
        return index;
    }

    public static EntityLivingBase getClosestHostileEntity(World world, double x, double y, double z, AxisAlignedBB box) {
        List li = world.func_72872_a(EntityLivingBase.class, box);
        double d = Double.MAX_VALUE;
        EntityLivingBase index = null;
        for (EntityLivingBase e : li) {
            double dd;
            if (!ReikaEntityHelper.isHostile(e) || e.field_70128_L || !(e.func_110143_aJ() > 0.0f) || !((dd = ReikaMathLibrary.py3d(e.field_70165_t - x, e.field_70163_u - y, e.field_70161_v - z)) < d)) continue;
            index = e;
            d = dd;
        }
        return index;
    }

    public static EntityLivingBase getClosestLivingEntityOfClass(Class<? extends EntityLivingBase> c, World world, double x, double y, double z, AxisAlignedBB box) {
        List li = world.func_72872_a(c, box);
        double d = Double.MAX_VALUE;
        EntityLivingBase index = null;
        for (EntityLivingBase e : li) {
            double dd;
            if (e.field_70128_L || !(e.func_110143_aJ() > 0.0f) || !((dd = ReikaMathLibrary.py3d(e.field_70165_t - x, e.field_70163_u - y, e.field_70161_v - z)) < d)) continue;
            index = e;
            d = dd;
        }
        return index;
    }

    public static Entity getClosestEntityOfClass(Class<? extends Entity> c, World world, double x, double y, double z, double range) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b(range, range, range);
        List li = world.func_72872_a(c, box);
        double d = Double.MAX_VALUE;
        Entity index = null;
        for (Entity e : li) {
            double dd;
            if (e.field_70128_L || !((dd = ReikaMathLibrary.py3d(e.field_70165_t - x, e.field_70163_u - y, e.field_70161_v - z)) < d)) continue;
            index = e;
            d = dd;
        }
        return index;
    }

    public static EntityLivingBase getClosestLivingEntityOfClass(Class<? extends EntityLivingBase> c, World world, double x, double y, double z, double range) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b(range, range, range);
        return ReikaWorldHelper.getClosestLivingEntityOfClass(c, world, x, y, z, box);
    }

    public static boolean otherDimensionsExist() {
        return ModList.MYSTCRAFT.isLoaded() || ModList.TWILIGHT.isLoaded() || ModList.EXTRAUTILS.isLoaded();
    }

    public static int getAmbientTemperatureAt(World world, int x, int y, int z) {
        int Tamb = ReikaBiomeHelper.getBiomeTemp(world, x, z);
        float temp = Tamb;
        if (!world.field_73011_w.field_76576_e) {
            if (world.func_72937_j(x, y + 1, z)) {
                float sun = ReikaWorldHelper.getSunIntensity(world, true, 0.0f);
                int mult = world.func_72896_J() ? 10 : 20;
                temp += (sun - 0.75f) * (float)mult;
            }
            if (!ReikaWorldHelper.isVoidWorld(world, x, z)) {
                int h = world.field_73011_w.func_76557_i();
                int dy = h - y;
                if (dy > 0) {
                    if (dy < 20) {
                        temp -= (float)dy;
                        temp = Math.max(temp, (float)(Tamb - 20));
                    } else if (dy < 25) {
                        temp -= (float)(2 * (25 - dy));
                        temp = Math.max(temp, (float)(Tamb - 20));
                    } else {
                        temp += (float)(100 * (dy - 20) / h);
                        temp = Math.min(temp, (float)(Tamb + 70));
                    }
                }
                if (y > 96) {
                    temp -= (float)((y - 96) / 4);
                }
            }
        }
        return (int)temp;
    }

    public static boolean tileExistsAt(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a) {
            return false;
        }
        if (b == null) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        return b.hasTileEntity(meta);
    }

    public static int getFreeDistance(World world, int x, int y, int z, ForgeDirection dir, int maxdist) {
        for (int i = 1; i < maxdist; ++i) {
            int dx = x + dir.offsetX * i;
            int dy = y + dir.offsetY * i;
            int dz = z + dir.offsetZ * i;
            if (ReikaWorldHelper.softBlocks((IBlockAccess)world, dx, dy, dz)) continue;
            return i - 1;
        }
        return maxdist;
    }

    public static boolean isExposedToAir(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetZ;
            int dz = z + dir.offsetY;
            Block b = world.func_147439_a(dx, dy, dz);
            if (b == Blocks.field_150350_a) {
                return true;
            }
            if (b == null) {
                return true;
            }
            if (b.func_149668_a(world, dx, dy, dz) == null) {
                return true;
            }
            Material mat = b.func_149688_o();
            if (mat == null) continue;
            if (mat == Material.field_151594_q || mat == Material.field_151579_a || mat == Material.field_151570_A || mat == Material.field_151581_o) {
                return true;
            }
            if (mat == Material.field_151585_k || mat == Material.field_151567_E || mat == Material.field_151582_l || mat == Material.field_151569_G) {
                return true;
            }
            if (mat.func_76220_a()) continue;
            return true;
        }
        return false;
    }

    public static int countAdjacentBlocks(World world, int x, int y, int z, Block id, boolean checkCorners) {
        Block id2;
        int dz;
        int dy;
        int dx;
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            dx = x + dir.offsetX;
            dy = y + dir.offsetZ;
            dz = z + dir.offsetY;
            id2 = world.func_147439_a(dx, dy, dz);
            if (id != id2) continue;
            ++count;
        }
        if (checkCorners) {
            for (int n = 0; n < RelativePositionList.cornerDirections.getSize(); ++n) {
                Coordinate d = RelativePositionList.cornerDirections.getNthPosition(x, y, z, n);
                dx = d.xCoord;
                dy = d.yCoord;
                dz = d.zCoord;
                id2 = world.func_147439_a(dx, dy, dz);
                if (id != id2) continue;
                ++count;
            }
        }
        return count;
    }

    public static void forceGenAndPopulate(World world, int x, int z) {
        ReikaWorldHelper.forceGenAndPopulate(world, x, z, 0);
    }

    public static void forceGenAndPopulate(World world, int x, int z, int range) {
        for (int i = -range; i <= range; ++i) {
            int dz;
            int dx;
            Chunk ch;
            WorldChunk wc;
            for (int k = -range; k <= range && !forcingChunkSet.contains(wc = new WorldChunk(world, ch = world.func_72938_d(dx = x + i * 16, dz = z + k * 16))); ++k) {
                forcingChunkSet.add(world.func_82737_E(), wc);
                IChunkProvider p = world.func_72863_F();
                if (ch.field_76646_k) continue;
                try {
                    p.func_73153_a(p, dx >> 4, dz >> 4);
                    continue;
                }
                catch (ConcurrentModificationException e) {
                    DragonAPICore.logError("Chunk at " + dx + ", " + dz + " failed to allow population due to a ConcurrentModificationException! Contact Reika with information on any mods that might be multithreading worldgen!");
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    DragonAPICore.logError("Chunk at " + dx + ", " + dz + " failed to allow population!");
                    e.printStackTrace();
                }
            }
        }
    }

    public static Collection<IInventory> getAllInventories(World world, int x, int y, int z, int r) {
        ArrayList<IInventory> c = new ArrayList<IInventory>();
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    TileEntity te;
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    if (!ReikaWorldHelper.tileExistsAt(world, dx, dy, dz) || !((te = world.func_147438_o(dx, dy, dz)) instanceof IInventory)) continue;
                    c.add((IInventory)te);
                }
            }
        }
        return c;
    }

    public static void dropAndDestroyBlockAt(World world, int x, int y, int z, EntityPlayer ep, boolean breakAll, boolean FX) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (b.field_149782_v < 0.0f && !breakAll) {
            return;
        }
        ReikaWorldHelper.dropBlockAt(world, x, y, z, ep);
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
        if (FX) {
            ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), world, x, y, z, Block.func_149682_b((Block)b), meta);
            ReikaSoundHelper.playBreakSound(world, x, y, z, b);
        }
    }

    public static boolean matchWithItemStack(World world, int x, int y, int z, ItemStack is) {
        return ReikaItemHelper.matchStackWithBlock(is, world.func_147439_a(x, y, z)) && is.func_77960_j() == world.func_72805_g(x, y, z);
    }

    public static boolean isSubmerged(IBlockAccess iba, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block b = iba.func_147439_a(dx, dy, dz);
            if (b == Blocks.field_150355_j || b == Blocks.field_150358_i || b.func_149662_c() || b.func_149686_d() || b.func_149645_b() == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isChunkGenerated(WorldServer world, int x, int z) {
        return ReikaWorldHelper.isChunkGeneratedChunkCoords(world, x >> 4, z >> 4);
    }

    public static boolean isChunkGeneratedChunkCoords(WorldServer world, int x, int z) {
        IChunkLoader loader = world.field_73059_b.field_73247_e;
        return loader instanceof AnvilChunkLoader && ((AnvilChunkLoader)loader).chunkExists((World)world, x, z);
    }

    public static int getWaterDepth(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int c = 0;
        while (b == Blocks.field_150355_j) {
            ++c;
            b = world.func_147439_a(x, --y, z);
        }
        return c;
    }

    public static boolean isWorldLoaded(int dim) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new MisuseException("This cannot be called clientside!");
        }
        return DimensionManager.getWorld((int)dim) != null;
    }

    public static int getTopNonAirBlock(World world, int x, int z) {
        int top;
        Chunk ch = world.func_72938_d(x, z);
        for (int y = top = ch.func_76625_h() + 15; y > 0; --y) {
            Block b = ch.func_150810_a(x & 0xF, y, z & 0xF);
            if (b.isAir((IBlockAccess)world, x, y, z)) continue;
            return y;
        }
        return 0;
    }

    public static World getBasicReferenceWorld() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? ReikaWorldHelper.getClientWorld() : DimensionManager.getWorld((int)0);
    }

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static ArrayList<BlockKey> getBlocksAlongVector(World world, double x1, double y1, double z1, double x2, double y2, double z2) {
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        ArrayList<BlockKey> li = new ArrayList<BlockKey>();
        double dd = ReikaMathLibrary.py3d(x2 - x1, y2 - y1, z2 - z1);
        for (double d = 0.0; d <= dd; d += 0.25) {
            double f = d / dd;
            double dx = x1 + f * (x2 - x1);
            double dy = y1 + f * (y2 - y1);
            double dz = z1 + f * (z2 - z1);
            Coordinate c = new Coordinate(dx, dy, dz);
            if (set.contains(c)) continue;
            set.add(c);
            li.add(new BlockKey(c.getBlock(world), c.getBlockMetadata(world)));
        }
        return li;
    }

    public static FluidStack getDrainableFluid(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (b instanceof IFluidBlock) {
            return ((IFluidBlock)b).drain(world, x, y, z, false);
        }
        if (b instanceof BlockLiquid) {
            if (meta != 0) {
                return null;
            }
            Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
            return f != null ? new FluidStack(f, 1000) : null;
        }
        return null;
    }

    public static EntityPlayer getClosestVulnerablePlayer(World world, double x, double y, double z, double r) {
        double dd = Double.POSITIVE_INFINITY;
        double dist = -1.0;
        EntityPlayer ret = null;
        for (EntityPlayer ep : world.field_73010_i) {
            boolean flag = false;
            Event.Result res = MobTargetingEvent.firePre(ep, world, x, y, z, r);
            if (res != Event.Result.DENY && (!ep.field_71075_bZ.field_75102_a || res == Event.Result.ALLOW) && ep.func_70089_S()) {
                dist = ep.func_70092_e(x, y, z);
                if (ep.func_70093_af()) {
                    r *= 0.8;
                }
                if (ep.func_82150_aj()) {
                    float f = ep.func_82243_bO();
                    if (f < 0.1f) {
                        f = 0.1f;
                    }
                    r *= (double)(0.7f * f);
                }
                flag = (r < 0.0 || dist < r * r) && dist < dd;
                flag = MobTargetingEvent.fire(ep, world, x, y, z, r, flag);
            }
            if (!flag) continue;
            dd = dist;
            ret = ep;
        }
        EntityPlayer post = MobTargetingEvent.firePost(world, x, y, z, r);
        if (post != null) {
            ret = post;
        }
        return ret;
    }

    public static void erodeBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        Material mat = b.func_149688_o();
        if (ReikaBlockHelper.isLiquid(b) || mat == Material.field_151585_k || mat == Material.field_151584_j) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        } else if (b == Blocks.field_150347_e) {
            world.func_147449_b(x, y, z, Blocks.field_150351_n);
        } else if (b == Blocks.field_150351_n) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150354_m);
        } else if (b == Blocks.field_150354_m) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        } else if (mat == Material.field_151576_e) {
            world.func_147449_b(x, y, z, Blocks.field_150347_e);
        } else if (b instanceof BlockLog) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
        } else if (mat == Material.field_151578_c) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150354_m);
        } else if (mat == Material.field_151577_b || b == Blocks.field_150349_c) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
    }

    public static boolean hydrateFarmland(World world, int x, int y, int z, boolean fullHydrate) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 7) {
            world.func_72921_c(x, y, z, fullHydrate ? 7 : meta + 1, 3);
            return true;
        }
        return false;
    }

    public static Coordinate findTreeNear(World world, int x, int y, int z, int r) {
        int[] nArray;
        if (r > 2) {
            int[] nArray2 = new int[7];
            nArray2[0] = y - r;
            nArray2[1] = y - r / 2;
            nArray2[2] = y - 1;
            nArray2[3] = y;
            nArray2[4] = y + 1;
            nArray2[5] = y + r / 2;
            nArray = nArray2;
            nArray2[6] = y + r;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = y - 2;
            nArray3[1] = y - 1;
            nArray3[2] = y;
            nArray3[3] = y + 1;
            nArray = nArray3;
            nArray3[4] = y + 2;
        }
        int[] ddy = nArray;
        for (int f = 0; f < ddy.length; ++f) {
            int dy = ddy[f];
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    if (!ReikaBlockHelper.isWood((IBlockAccess)world, x + i, dy, z + k) || !ReikaBlockHelper.isWood((IBlockAccess)world, x + i, dy + 1, z + k) || !ReikaBlockHelper.isWood((IBlockAccess)world, x + i, dy - 1, z + k)) continue;
                    return new Coordinate(x + i, dy, z + k);
                }
            }
        }
        return null;
    }

    public static boolean isBlockEncased(World world, int x, int y, int z, Block b) {
        return ReikaWorldHelper.isBlockEncased(world, x, y, z, b, -1);
    }

    public static boolean isBlockEncased(World world, int x, int y, int z, Block b, int meta) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    Block b2 = world.func_147439_a(dx, dy, dz);
                    int meta2 = world.func_72805_g(dx, dy, dz);
                    if (!(b != null ? b2 != b || meta != -1 && meta2 != meta : b2.isAir((IBlockAccess)world, dx, dy, dz))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean matchBlock(IBlockAccess world, int x, int y, int z, Block b, int meta) {
        return world.func_147439_a(x, y, z) == b && world.func_72805_g(x, y, z) == meta;
    }

    public static void fertilizeAndHealBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (b == Blocks.field_150346_d && meta == 0) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150349_c);
        } else if (b == Blocks.field_150330_I || b == Blocks.field_150329_H && meta == 0) {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150329_H, rand.nextInt(6) == 0 ? 2 : 1, 3);
        } else if (b == Blocks.field_150458_ak) {
            ReikaWorldHelper.hydrateFarmland(world, x, y, z, true);
        }
    }

    public static int getTopSolidOrLiquidBlockForDouble(World world, double x, double z) {
        return world.func_72825_h(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)z));
    }

    public static MobSpawnerBaseLogic generateSpawner(World world, int x, int y, int z, Class mob) {
        world.func_147449_b(x, y, z, Blocks.field_150474_ac);
        TileEntityMobSpawner te = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
        ReikaSpawnerHelper.setMobSpawnerMob(te, (String)EntityList.field_75626_c.get(mob));
        return te.func_145881_a();
    }

    public static boolean hasAdjacentWater(IBlockAccess world, int x, int y, int z, boolean vertical, boolean source) {
        int i;
        int n = i = vertical ? 0 : 2;
        while (i < 6) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block id2 = world.func_147439_a(dx, dy, dz);
            int meta2 = world.func_72805_g(dx, dy, dz);
            if (!(id2 != Blocks.field_150355_j && id2 != Blocks.field_150358_i || meta2 != 0 && source)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void triggerFallingBlock(World world, int x, int y, int z, Block b) {
        if (y >= 0 && BlockFalling.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z)) {
            int r = 32;
            if (!BlockFalling.field_149832_M && world.func_72904_c(x - r, y - r, z - r, x + r, y + r, z + r)) {
                if (!world.field_72995_K) {
                    EntityFallingBlock e = new EntityFallingBlock(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, b, world.func_72805_g(x, y, z));
                    world.func_72838_d((Entity)e);
                }
            } else {
                world.func_147468_f(x, y, z);
                while (BlockFalling.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z) && y > 0) {
                    --y;
                }
                if (y > 0) {
                    world.func_147449_b(x, y, z, b);
                }
            }
        }
    }

    public static boolean isBlockSurroundedBySolid(World world, int x, int y, int z, boolean vertical) {
        int i;
        int n = i = vertical ? 0 : 2;
        while (i < 6) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block id = world.func_147439_a(dx, dy, dz);
            if (!id.func_149688_o().func_76220_a()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean checkForAdjSolidBlock(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block id = world.func_147439_a(dx, dy, dz);
            if (!id.func_149688_o().func_76220_a()) continue;
            return true;
        }
        return false;
    }

    public static boolean isVoidWorld(World world, int x, int z) {
        return world.func_147439_a(x, 0, z) == Blocks.field_150350_a || world.func_72937_j(x, 1, z);
    }

    public static int getSuperflatHeight(World world) {
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge(world)) {
            return ReikaMystcraftHelper.getFlatWorldThickness(world);
        }
        ChunkProviderFlat f = (ChunkProviderFlat)world.field_73011_w.func_76555_c();
        FlatGeneratorInfo ifo = f.field_82699_e;
        int sum = 0;
        for (Object o : ifo.func_82650_c()) {
            FlatLayerInfo fi = (FlatLayerInfo)o;
            sum += fi.func_82657_a();
        }
        return sum;
    }

    public static Coordinate getRandomLoadedCoordinate(World world) {
        ArrayList li = new ArrayList(world.field_72993_I);
        if (li.isEmpty()) {
            return null;
        }
        int idx = rand.nextInt(li.size());
        ChunkCoordIntPair cp = (ChunkCoordIntPair)li.get(idx);
        return new Coordinate((cp.field_77276_a << 4) + rand.nextInt(16), 0, (cp.field_77275_b << 4) + rand.nextInt(16));
    }

    public static boolean isChunkPastNoiseGen(World world, int x, int z) {
        return world instanceof WorldServer ? ((ChunkProviderServer)world.func_72863_F()).field_73244_f.func_76161_b(ChunkCoordIntPair.func_77272_a((int)x, (int)z)) : true;
    }

    public static List<IWorldGenerator> getModdedGenerators() {
        try {
            List li = (List)moddedGeneratorList.get(null);
            while (li == null) {
                computeModdedGeneratorList.invoke(null, new Object[0]);
                li = (List)moddedGeneratorList.get(null);
            }
            return li;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ResettableRandom getModdedGeneratorChunkRand(int cx, int cz, World world) {
        long worldSeed = world.func_72905_C();
        moddedGenRand_Calcer.setSeed(worldSeed);
        long xSeed = moddedGenRand_Calcer.nextLong() >> 3;
        long zSeed = moddedGenRand_Calcer.nextLong() >> 3;
        long seed = xSeed * (long)cx + zSeed * (long)cz ^ worldSeed;
        moddedGenRand.setSeed(seed);
        return moddedGenRand;
    }

    public static void cancelScheduledTick(WorldServer world, int x, int y, int z, Block b) {
        Chunk c = world.func_72938_d(x, z);
        List li = world.func_72920_a(c, true);
        for (NextTickListEntry e : li) {
            if (e.field_77183_a == x && e.field_77181_b == y && e.field_77182_c == z && e.func_151351_a() == b) continue;
            ReikaWorldHelper.rescheduleTick(world, e);
        }
    }

    private static void rescheduleTick(WorldServer world, NextTickListEntry e) {
        world.func_147454_a(e.field_77183_a, e.field_77181_b, e.field_77182_c, e.func_151351_a(), (int)(e.field_77180_e - world.func_82737_E()), e.field_82754_f);
    }

    public static boolean regionContainsBiome(World world, int x0, int x1, int z0, int z1, BiomeGenBase b) {
        return world.func_72807_a(x0, z0) == b || world.func_72807_a(x1, z0) == b || world.func_72807_a(x0, z1) == b || world.func_72807_a(x1, z1) == b;
    }

    public static boolean isAdjacentToCrop(IBlockAccess iba, int x, int y, int z) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dz = z + dir.offsetZ;
            Block id = iba.func_147439_a(dx, y, dz);
            if (ReikaCropHelper.getCrop(id) == null && ModCropList.getModCrop(id, iba.func_72805_g(dx, y, dz)) == null) continue;
            return true;
        }
        return false;
    }

    static {
        moddedGenRand_Calcer = new Random();
        moddedGenRand = new ResettableRandom();
        try {
            moddedGeneratorList = GameRegistry.class.getDeclaredField("sortedGeneratorList");
            moddedGeneratorList.setAccessible(true);
            computeModdedGeneratorList = GameRegistry.class.getDeclaredMethod("computeSortedGeneratorList", new Class[0]);
            computeModdedGeneratorList.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find GameRegistry IWorldGenerator data!", e);
        }
    }
}

