/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class LegacyMagicCropHandler
extends CropHandlerBase {
    public final Block oreID;
    public final Block netherOreID;
    public final Block endOreID;
    public final Item dropID;
    private final int configChance;
    private static final LegacyMagicCropHandler instance = new LegacyMagicCropHandler();

    private LegacyMagicCropHandler() {
        Block idore = null;
        Block idnether = null;
        Block idend = null;
        Item iddrop = null;
        int chance = -1;
        if (this.hasMod()) {
            Class c = this.getMod().getBlockClass();
            for (int i = 0; i < EssenceType.essenceList.length; ++i) {
                EssenceType type = EssenceType.essenceList[i];
                String cropf = type.getCropFieldName();
                String seedf = type.getSeedFieldName();
                String essf = type.type.field;
                try {
                    Field f = c.getField(cropf);
                    Block crop = (Block)f.get(null);
                    f = c.getField(seedf);
                    Item seed = (Item)f.get(null);
                    f = c.getField(essf);
                    Item essence = (Item)f.get(null);
                    type.setIDs(crop, seed, essence);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logFailure(e);
                }
            }
            try {
                Item drop;
                Block ore;
                Field f = c.getField("EssenceOre");
                idore = ore = (Block)f.get(null);
                f = c.getField("EssenceOreNether");
                idnether = ore = (Block)f.get(null);
                f = c.getField("EssenceOreEnd");
                idend = ore = (Block)f.get(null);
                f = c.getField("ExperienceDrop");
                iddrop = drop = (Item)f.get(null);
                Class<?> c2 = Class.forName("com.mark719.magicalcrops.ConfigHandler");
                f = c2.getDeclaredField("seeddropchance");
                f.setAccessible(true);
                chance = f.getInt(null);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.oreID = idore;
        this.netherOreID = idnether;
        this.endOreID = idend;
        this.dropID = iddrop;
        this.configChance = chance >= 0 ? chance : 10;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return EssenceType.cropIDs.containsKey(id);
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return EssenceType.seedIDs.containsKey(is.func_77973_b());
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        int meta;
        Block b = world.func_147439_a(x, y, z);
        return this.isCrop(b, meta = world.func_72805_g(x, y, z)) && meta == 7;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 7, 3);
    }

    public static LegacyMagicCropHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return EssenceType.initialized() && this.configChance != -1 && this.oreID != null && this.netherOreID != null && this.endOreID != null && this.dropID != null;
    }

    public boolean isEssenceOre(Block id) {
        return id == this.netherOreID || id == this.oreID || id == this.endOreID;
    }

    @Override
    public ModList getMod() {
        return ModList.MAGICCROPS;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return 0;
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ItemStack weak;
        ItemStack nature;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (MiscEssence.CHRISTMAS.item != null && ReikaRandomHelper.doWithChance(20 * (1 + fortune))) {
            li.add(MiscEssence.CHRISTMAS.getItem());
        }
        if ((nature = MiscEssence.NATURE.getItem()) != null && ReikaRandomHelper.doWithChance(20 * (1 + fortune))) {
            li.add(nature);
        }
        if (ReikaRandomHelper.doWithChance(20 * (1 + fortune)) && (weak = EssenceType.ESSENCE.getEssence()) != null) {
            li.add(weak);
            if (ReikaRandomHelper.doWithChance(25 * (1 + fortune))) {
                li.add(weak);
            }
        }
        return li;
    }

    public void registerEssence() {
        ItemStack ore = new ItemStack(this.oreID, 1, 0);
        OreDictionary.registerOre((String)"oreEssence", (ItemStack)ore);
        ore = new ItemStack(this.netherOreID, 1, 0);
        OreDictionary.registerOre((String)"oreNetherEssence", (ItemStack)ore);
        ore = new ItemStack(this.endOreID, 1, 0);
        OreDictionary.registerOre((String)"oreEndEssence", (ItemStack)ore);
        ModOreList.ESSENCE.initialize();
        DragonAPICore.logError("Registering Magic Crops Essence ore to the Ore Dictionary!");
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return null;
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return this.configChance == 0;
    }

    public static enum MiscEssence {
        NATURE("T1Essence", 6),
        CHRISTMAS("ChristmasEssence"),
        TAINTED("TaintedEssence"),
        ACCIO("AccioEssence"),
        CRUCIO("CrucioEssence"),
        IMPERIO("ImperioEssence"),
        ZIVICIO("ZivicioEssence");

        private final String field;
        private final int metadata;
        private Item item;

        private MiscEssence(String s) {
            this(s, 0);
        }

        private MiscEssence(String s, int meta) {
            this.field = s;
            this.metadata = meta;
        }

        public ItemStack getItem() {
            return this.item != null ? new ItemStack(this.item, 1, this.metadata) : null;
        }
    }

    private static enum EssenceClass {
        SOULPASSIVE("SoulEssencePassive"),
        SOULHOSTILE("SoulEssenceHostile"),
        MINICIO("MinicioEssence"),
        MATERIAL1("T1Essence"),
        MATERIAL2("T2Essence"),
        MATERIAL3("T3Essence"),
        MATERIAL4("T4Essence"),
        POTION("PotionPetals"),
        MOD("");

        private final String field;

        private EssenceClass(String s) {
            this.field = s;
        }
    }

    public static enum EssenceType {
        COW(EssenceClass.SOULPASSIVE, "Cow", 0),
        SHEEP(EssenceClass.SOULPASSIVE, "Sheep", 2),
        PIG(EssenceClass.SOULPASSIVE, "Pig", 1),
        CHICKEN(EssenceClass.SOULPASSIVE, "Chicken", 3),
        CREEPER(EssenceClass.SOULHOSTILE, "Creeper", 1),
        MAGMA(EssenceClass.SOULHOSTILE, "Magma", 4),
        SKELETON(EssenceClass.SOULHOSTILE, "Skeleton", 5),
        SLIME(EssenceClass.SOULHOSTILE, "Slime", 6),
        SPIDER(EssenceClass.SOULHOSTILE, "Spider", 7),
        GHAST(EssenceClass.SOULHOSTILE, "Ghast", 3),
        WITHER(EssenceClass.SOULHOSTILE, "Wither", 8),
        BLAZE(EssenceClass.SOULHOSTILE, "Blaze", 0),
        ENDER(EssenceClass.SOULHOSTILE, "Enderman", 2),
        ESSENCE(EssenceClass.MINICIO, "Minicio", 0),
        COAL(EssenceClass.MATERIAL1, "Coal", 1),
        DYE(EssenceClass.MATERIAL1, "Dye", 2),
        REDSTONE(EssenceClass.MATERIAL2, "Redstone", 0),
        GLOWSTONE(EssenceClass.MATERIAL2, "Glowstone", 1),
        OBSIDIAN(EssenceClass.MATERIAL2, "Obsidian", 2),
        IRON(EssenceClass.MATERIAL3, "Iron", 0),
        GOLD(EssenceClass.MATERIAL3, "Gold", 1),
        LAPIS(EssenceClass.MATERIAL3, "Lapis", 2),
        QUARTZ(EssenceClass.MATERIAL3, "Quartz", 4),
        XP(EssenceClass.MATERIAL3, "Experience", 3),
        DIAMOND(EssenceClass.MATERIAL4, "Diamond", 0),
        EMERALD(EssenceClass.MATERIAL4, "Emerald", 1),
        WATER(EssenceClass.MATERIAL1, "Water", 5),
        FIRE(EssenceClass.MATERIAL1, "Fire", 4),
        EARTH(EssenceClass.MATERIAL1, "Earth", 3),
        AIR(EssenceClass.MATERIAL1, "Air", 0),
        ABSORPTION(EssenceClass.POTION, "Absorption", 0),
        FIRERESIST(EssenceClass.POTION, "FireResistance", 1),
        HASTE(EssenceClass.POTION, "Haste", 2),
        NIGHTVISION(EssenceClass.POTION, "NightVision", 3),
        REGEN(EssenceClass.POTION, "Regeneration", 4),
        RESISTANCE(EssenceClass.POTION, "Resistance", 5),
        STRENGTH(EssenceClass.POTION, "Strength", 6),
        WATERBREATHING(EssenceClass.POTION, "WaterBreathing", 7);

        private final EssenceClass type;
        private final String tag;
        private Block cropID = null;
        private Item seedID = null;
        private Item essenceID = null;
        private final int essenceMeta;
        public static final EssenceType[] essenceList;
        private static final HashMap<Block, EssenceType> cropIDs;
        private static final HashMap<Item, EssenceType> essenceIDs;
        private static final HashMap<Item, EssenceType> seedIDs;

        private EssenceType(EssenceClass c, String name, int meta) {
            this.type = c;
            this.tag = name;
            this.essenceMeta = meta;
        }

        private void setIDs(Block crop, Item seed, Item essence) {
            this.seedID = seed;
            this.cropID = crop;
            this.essenceID = essence;
            cropIDs.put(crop, this);
            seedIDs.put(seed, this);
            essenceIDs.put(essence, this);
        }

        private String getSeedFieldName() {
            return "Seeds" + this.tag;
        }

        private String getCropFieldName() {
            return "Crop" + this.tag;
        }

        public ItemStack getEssence() {
            return this.essenceID != null ? new ItemStack(this.essenceID, 1, this.essenceMeta) : null;
        }

        public ItemStack getSeeds() {
            return this.seedID != null ? new ItemStack(this.seedID, 1, 0) : null;
        }

        public ItemStack getCrop() {
            return this.cropID != null ? new ItemStack(this.cropID, 1, 0) : null;
        }

        public static boolean initialized() {
            return !cropIDs.isEmpty() && !seedIDs.isEmpty() && !essenceIDs.isEmpty();
        }

        static {
            essenceList = EssenceType.values();
            cropIDs = new HashMap();
            essenceIDs = new HashMap();
            seedIDs = new HashMap();
        }
    }
}

