/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class TinkerToolHandler
extends ModHandlerBase {
    private static final TinkerToolHandler instance = new TinkerToolHandler();
    private boolean init = false;
    public final Item toolCastItem;
    public final Item toolWoodPattern;
    public final Item weaponCastItem;
    public final Item weaponWoodPattern;
    public final Item blankPattern;
    private final HashMap<Item, Tools> tools = new HashMap();
    private final HashMap<Item, Weapons> weapons = new HashMap();
    private final EnumMap<Tools, EnumMap<ToolPartType, ToolParts>> toolPartMap = new EnumMap(Tools.class);

    private TinkerToolHandler() {
        Item cast_t = null;
        Item pattern_t = null;
        Item cast_w = null;
        Item pattern_w = null;
        Item blank = null;
        if (this.hasMod()) {
            Class<?> c;
            Field f;
            Enum t;
            int i;
            try {
                Class<?> tic = Class.forName("tconstruct.tools.TinkerTools");
                for (i = 0; i < Tools.toolList.length; ++i) {
                    t = Tools.toolList[i];
                    try {
                        f = tic.getField(((Tools)t).field);
                        ((Tools)t).item = (Item)f.get(null);
                        this.tools.put(((Tools)t).item, (Tools)t);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (SecurityException e) {
                        DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (NullPointerException e) {
                        DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                        e.printStackTrace();
                        this.logFailure(e);
                    }
                }
                for (i = 0; i < ToolParts.partList.length; ++i) {
                    t = ToolParts.partList[i];
                    try {
                        f = tic.getField(((ToolParts)t).field);
                        ((ToolParts)t).item = (Item)f.get(null);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (SecurityException e) {
                        DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (NullPointerException e) {
                        DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                        e.printStackTrace();
                        this.logFailure(e);
                    }
                }
                for (i = 0; i < ToolBlocks.list.length; ++i) {
                    t = ToolBlocks.list[i];
                    try {
                        f = tic.getField(((ToolBlocks)t).field);
                        ((ToolBlocks)t).item = (Block)f.get(null);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (SecurityException e) {
                        DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (NullPointerException e) {
                        DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                        e.printStackTrace();
                        this.logFailure(e);
                    }
                }
                this.init = true;
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            try {
                c = Class.forName("tconstruct.smeltery.TinkerSmeltery");
                cast_t = (Item)c.getField("metalPattern").get(null);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            try {
                c = Class.forName("tconstruct.tools.TinkerTools");
                pattern_t = (Item)c.getField("woodPattern").get(null);
                blank = (Item)c.getField("blankPattern").get(null);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            try {
                c = Class.forName("tconstruct.weaponry.TinkerWeaponry");
                for (i = 0; i < Weapons.weaponList.length; ++i) {
                    t = Weapons.weaponList[i];
                    try {
                        f = c.getField(((Weapons)t).field);
                        ((Weapons)t).item = (Item)f.get(null);
                        this.weapons.put(((Weapons)t).item, (Weapons)t);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (SecurityException e) {
                        DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (NullPointerException e) {
                        DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                        e.printStackTrace();
                        this.logFailure(e);
                    }
                }
                for (i = 0; i < WeaponParts.partList.length; ++i) {
                    t = WeaponParts.partList[i];
                    try {
                        f = c.getField(((WeaponParts)t).field);
                        ((WeaponParts)t).item = (Item)f.get(null);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (SecurityException e) {
                        DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (NullPointerException e) {
                        DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                        e.printStackTrace();
                        this.logFailure(e);
                    }
                }
                cast_w = (Item)c.getField("metalPattern").get(null);
                pattern_w = (Item)c.getField("woodPattern").get(null);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.toolCastItem = cast_t;
        this.toolWoodPattern = pattern_t;
        this.weaponCastItem = cast_w;
        this.weaponWoodPattern = pattern_w;
        this.blankPattern = blank;
        for (int i = 0; i < Tools.toolList.length; ++i) {
            Tools t = Tools.toolList[i];
            EnumMap<ToolPartType, ToolParts> map = new EnumMap<ToolPartType, ToolParts>(ToolPartType.class);
            this.toolPartMap.put(t, map);
            map.put(ToolPartType.HEAD, t.headPart);
            map.put(ToolPartType.HANDLE, t.handlePart);
            map.put(ToolPartType.ACCESSORY, t.accessoryPart);
            map.put(ToolPartType.EXTRA, t.extraPart);
        }
    }

    public static TinkerToolHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.init;
    }

    @Override
    public ModList getMod() {
        return ModList.TINKERER;
    }

    public boolean isPick(ItemStack is) {
        return is != null && is.func_77973_b() == Tools.PICK.item;
    }

    public boolean isHammer(ItemStack is) {
        return is != null && is.func_77973_b() == Tools.HAMMER.item;
    }

    public boolean isExcavator(ItemStack is) {
        return is != null && is.func_77973_b() == Tools.EXCAVATOR.item;
    }

    public boolean isTool(ItemStack is) {
        return is != null && this.tools.containsKey(is.func_77973_b());
    }

    public boolean isWeapon(ItemStack is) {
        return is != null && this.weapons.containsKey(is.func_77973_b());
    }

    public ItemStack getIngotCast() {
        return new ItemStack(this.toolCastItem, 1, 0);
    }

    public ItemStack getNuggetCast() {
        return new ItemStack(this.toolCastItem, 1, 27);
    }

    public ItemStack getBlankWoodPattern() {
        return new ItemStack(this.blankPattern, 1, 0);
    }

    public ItemStack getBlankAlubrassPattern() {
        return new ItemStack(this.blankPattern, 1, 1);
    }

    public ItemStack getBlankGoldPattern() {
        return new ItemStack(this.blankPattern, 1, 2);
    }

    public int getHarvestLevel(ItemStack is) {
        if (is.field_77990_d == null) {
            return 0;
        }
        NBTTagCompound tag = is.field_77990_d.func_74775_l("InfiTool");
        return tag.func_74762_e("HarvestLevel");
    }

    public int getToolMaterial(ItemStack tool, ToolPartType part) {
        if (tool.field_77990_d == null || !tool.field_77990_d.func_74764_b("InfiTool")) {
            return -1;
        }
        return tool.field_77990_d.func_74775_l("InfiTool").func_74762_e(part.NBTName);
    }

    public ToolParts getPart(Tools tool, ToolPartType type) {
        return this.toolPartMap.get((Object)tool).get((Object)type);
    }

    public boolean isStoneOrBetter(ItemStack is) {
        return this.getHarvestLevel(is) >= 1;
    }

    public boolean isIronOrBetter(ItemStack is) {
        return this.getHarvestLevel(is) >= 2;
    }

    public boolean isDiamondOrBetter(ItemStack is) {
        return this.getHarvestLevel(is) >= 3;
    }

    public boolean isToolStation(Block b) {
        return b == ToolBlocks.TOOLSTATION.item || b == ToolBlocks.TOOLSTATION2.item;
    }

    public boolean isWorkbench(Block b) {
        return b == ToolBlocks.WORKBENCH.item || b == ToolBlocks.CRAFTSLAB.item;
    }

    public Tools getTool(Item item) {
        return this.tools.get(item);
    }

    public Weapons getWeapon(Item item) {
        return this.weapons.get(item);
    }

    public static enum ToolPartType {
        HEAD("Head"),
        HANDLE("Handle"),
        ACCESSORY("Accessory"),
        EXTRA("Extra");

        public final String NBTName;
        public static final ToolPartType[] types;

        private ToolPartType(String n2) {
            this.NBTName = n2;
        }

        static {
            types = ToolPartType.values();
        }
    }

    public static interface TinkerPart {
        public ItemStack getItem(int var1);

        public ItemStack getCast();

        public ItemStack getPattern();

        public float getIngotCost();
    }

    public static enum WeaponParts implements TinkerPart
    {
        ARROWHEAD("arrowhead", false, 25, 0.5f),
        SHURIKEN("partShuriken", true, 0, 0.5f),
        BOWSTRING("bowstring", false, 23, 3.0f),
        CROSSBOWBODY("partCrossbowBody", true, 2, 5.0f),
        CROSSBOWLIMB("partCrossbowLimb", true, 1, 4.0f),
        FLETCHING("fletching", false, 24, 1.0f),
        BOWLIMB("partBowLimb", true, 3, 1.5f);

        private Item item;
        private final String field;
        public final float ingotCost;
        public final int castMeta;
        private final boolean weaponCast;
        public static final WeaponParts[] partList;

        private WeaponParts(String s, boolean wcast, int cast, float n2) {
            this.field = s;
            this.weaponCast = wcast;
            this.ingotCost = n2;
            this.castMeta = cast;
        }

        public Item getItem() {
            return this.item;
        }

        @Override
        public ItemStack getItem(int materialID) {
            return new ItemStack(this.item, 1, materialID);
        }

        @Override
        public ItemStack getCast() {
            return new ItemStack(this.weaponCast ? TinkerToolHandler.getInstance().weaponCastItem : TinkerToolHandler.getInstance().toolCastItem, 1, this.castMeta);
        }

        @Override
        public ItemStack getPattern() {
            return new ItemStack(this.weaponCast ? TinkerToolHandler.getInstance().weaponWoodPattern : TinkerToolHandler.getInstance().toolWoodPattern, 1, this.castMeta);
        }

        @Override
        public float getIngotCost() {
            return this.ingotCost;
        }

        static {
            partList = WeaponParts.values();
        }
    }

    public static enum ToolParts implements TinkerPart
    {
        ROD("toolRod", 1, 0.5f),
        BINDING("binding", 9, 0.5f),
        TOUGHBINDING("toughBinding", 15, 3.0f),
        TOUGHROD("toughRod", 14, 3.0f),
        PLATE("largePlate", 16, 8.0f),
        PICK("pickaxeHead", 2, 1.0f),
        SHOVEL("shovelHead", 3, 1.0f),
        AXEHEAD("hatchetHead", 4, 1.0f),
        PANHEAD("frypanHead", 10, 1.0f),
        SIGN("signHead", 11, 1.0f),
        CHISEL("chiselHead", 13, 0.5f),
        SCYTHE("scytheBlade", 18, 8.0f),
        LUMBER("broadAxeHead", 17, 8.0f),
        EXCAVATOR("excavatorHead", 19, 8.0f),
        HAMMER("hammerHead", 21, 8.0f),
        SWORD("swordBlade", 5, 1.0f),
        CLEAVER("largeSwordBlade", 20, 8.0f),
        DAGGER("knifeBlade", 12, 0.5f),
        WIDEGUARD("wideGuard", 6, 0.5f),
        FULLGUARD("fullGuard", 22, 3.0f),
        HANDGUARD("handGuard", 7, 0.5f),
        CROSSBAR("crossbar", 8, 0.5f);

        private Item item;
        public final float ingotCost;
        public final int castMeta;
        private final String field;
        public static final ToolParts[] partList;

        private ToolParts(String s, int cast, float n2) {
            this.field = s;
            this.ingotCost = n2;
            this.castMeta = cast;
        }

        public Item getItem() {
            return this.item;
        }

        @Override
        public ItemStack getItem(int materialID) {
            return new ItemStack(this.item, 1, materialID);
        }

        @Override
        public ItemStack getCast() {
            return new ItemStack(TinkerToolHandler.getInstance().toolCastItem, 1, this.castMeta);
        }

        @Override
        public ItemStack getPattern() {
            return new ItemStack(TinkerToolHandler.getInstance().toolWoodPattern, 1, this.castMeta);
        }

        @Override
        public float getIngotCost() {
            return this.ingotCost;
        }

        static {
            partList = ToolParts.values();
        }
    }

    public static enum ToolBlocks {
        TOOLSTATION("toolStationWood"),
        TOOLSTATION2("toolStationStone"),
        TOOLFORGE("toolForge"),
        WORKBENCH("craftingStationWood"),
        CRAFTSLAB("craftingSlabWood"),
        FURNACE("furnaceSlab");

        private Block item;
        private final String field;
        private static final ToolBlocks[] list;

        private ToolBlocks(String s) {
            this.field = s;
        }

        public Block getItem() {
            return this.item;
        }

        static {
            list = ToolBlocks.values();
        }
    }

    public static enum Weapons {
        SHURIKEN("shuriken"),
        KNIFE("throwingknife"),
        JAVELIN("javelin"),
        BOW("shortbow"),
        LONGBOW("longbow"),
        CROSSBOW("crossbow");

        private Item item;
        private final String field;
        public static final Weapons[] weaponList;

        private Weapons(String s) {
            this.field = s;
        }

        public Item getItem() {
            return this.item;
        }

        static {
            weaponList = Weapons.values();
        }
    }

    public static enum Tools {
        PICK("pickaxe", ToolParts.PICK, ToolParts.ROD, ToolParts.BINDING),
        SPADE("shovel", ToolParts.SHOVEL, ToolParts.ROD),
        AXE("hatchet", ToolParts.AXEHEAD, ToolParts.ROD),
        BROADSWORD("broadsword", ToolParts.SWORD, ToolParts.ROD, ToolParts.WIDEGUARD),
        LONGSWORD("longsword", ToolParts.SWORD, ToolParts.ROD, ToolParts.HANDGUARD),
        RAPIER("rapier", ToolParts.SWORD, ToolParts.ROD, ToolParts.CROSSBAR),
        DAGGER("dagger", ToolParts.DAGGER, ToolParts.ROD, ToolParts.CROSSBAR),
        CUTLASS("cutlass", ToolParts.SWORD, ToolParts.ROD, ToolParts.FULLGUARD),
        PAN("frypan", ToolParts.PANHEAD, ToolParts.ROD),
        SIGN("battlesign", ToolParts.SIGN, ToolParts.ROD),
        CHISEL("chisel", ToolParts.CHISEL, ToolParts.ROD),
        MATTOCK("mattock", ToolParts.AXEHEAD, ToolParts.ROD, ToolParts.SHOVEL),
        SCYTHE("scythe", ToolParts.SCYTHE, ToolParts.TOUGHROD, ToolParts.TOUGHBINDING, ToolParts.TOUGHROD),
        LUMBERAXE("lumberaxe", ToolParts.LUMBER, ToolParts.TOUGHROD, ToolParts.PLATE, ToolParts.TOUGHBINDING),
        CLEAVER("cleaver", ToolParts.CLEAVER, ToolParts.TOUGHROD, ToolParts.PLATE, ToolParts.TOUGHROD),
        HAMMER("hammer", ToolParts.HAMMER, ToolParts.TOUGHROD, ToolParts.PLATE, ToolParts.PLATE),
        EXCAVATOR("excavator", ToolParts.EXCAVATOR, ToolParts.TOUGHROD, ToolParts.PLATE, ToolParts.TOUGHBINDING),
        BATTLEAX("battleaxe", ToolParts.LUMBER, ToolParts.TOUGHROD, ToolParts.LUMBER, ToolParts.TOUGHBINDING);

        private Item item;
        private final String field;
        public final ToolParts headPart;
        public final ToolParts handlePart;
        public final ToolParts accessoryPart;
        public final ToolParts extraPart;
        public static final Tools[] toolList;

        private Tools(String s, ToolParts ... parts) {
            this.field = s;
            this.headPart = parts.length > 0 ? parts[0] : null;
            this.handlePart = parts.length > 1 ? parts[1] : null;
            this.accessoryPart = parts.length > 2 ? parts[2] : null;
            this.extraPart = parts.length > 3 ? parts[3] : null;
        }

        public Item getItem() {
            return this.item;
        }

        public ItemStack getToolOfMaterials(int head, int handle, int acc, int extra) {
            ItemStack is = new ItemStack(this.getItem());
            is.field_77990_d = new NBTTagCompound();
            NBTTagCompound infi = new NBTTagCompound();
            if (this.headPart != null) {
                infi.func_74768_a(ToolPartType.HEAD.NBTName, head);
                infi.func_74768_a("RenderHead", head);
            }
            if (this.handlePart != null) {
                infi.func_74768_a(ToolPartType.HANDLE.NBTName, handle);
                infi.func_74768_a("RenderHandle", handle);
            }
            if (this.accessoryPart != null) {
                infi.func_74768_a(ToolPartType.ACCESSORY.NBTName, acc);
                infi.func_74768_a("RenderAccessory", acc);
            }
            if (this.extraPart != null) {
                infi.func_74768_a(ToolPartType.EXTRA.NBTName, extra);
                infi.func_74768_a("RenderExtra", extra);
            }
            is.field_77990_d.func_74782_a("InfiTool", (NBTBase)infi);
            return is;
        }

        static {
            toolList = Tools.values();
        }
    }
}

