/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.RecipeHandlers;

import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class ModOreCompat {
    public static final ModOreCompat instance = new ModOreCompat();
    private final MultiMap<OreType, String> modOres = new MultiMap();
    private final Collection<OreVariant> variants = new ArrayList<OreVariant>();

    private ModOreCompat() {
        if (DragonOptions.GREGORES.getState()) {
            this.modOres.addValue(ReikaOreHelper.IRON, "oreBandedIron");
            this.modOres.addValue(ReikaOreHelper.IRON, "oreBrownLimonite");
            this.modOres.addValue(ReikaOreHelper.IRON, "oreYellowLimonite");
            this.modOres.addValue(ReikaOreHelper.QUARTZ, "oreNetherQuartz");
            this.addVariant("Netherrack", "ore*", ModList.GREGTECH);
            this.addVariant("Endstone", "ore*", ModList.GREGTECH);
            this.addVariant("Blackgranite", "ore*", ModList.GREGTECH);
            this.addVariant("Redgranite", "ore*", ModList.GREGTECH);
        }
    }

    public Collection<ItemStack> load(OreType type) {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        for (OreVariant v : this.variants) {
            v.addOreBlocks(type, (Collection<ItemStack>)c);
        }
        for (String s : this.modOres.get(type)) {
            c.addAll(OreDictionary.getOres((String)s));
            for (OreVariant v : this.variants) {
                v.addOreBlocks(s, (Collection<ItemStack>)c);
            }
        }
        return c;
    }

    private void addVariant(String name, String key, ModList ... mods) {
        if (ReikaJavaLibrary.isAnyModLoaded(mods)) {
            this.variants.add(new OreVariant(name, key));
        }
    }

    private static class OreVariant {
        private final String name;
        private final String regex;

        private OreVariant(String s, String r) {
            this.name = s;
            this.regex = r;
        }

        private void addOreBlocks(OreType type, Collection<ItemStack> ores) {
            for (String label : type.getOreDictNames()) {
                this.addOreBlocks(label, ores);
            }
        }

        private void addOreBlocks(String tag, Collection<ItemStack> ores) {
            ores.addAll(OreDictionary.getOres((String)this.parseTag(tag)));
        }

        private String parseTag(String tag) {
            int idx = this.regex.indexOf(42);
            String pre = this.regex.substring(0, idx);
            String suff = tag.substring(pre.length());
            String result = pre + this.name + suff;
            return result;
        }
    }
}

