/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract;

import Reika.DragonAPI.DragonAPICore;
import java.lang.reflect.Field;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ReikaXPFluidHelper {
    private static FluidStack loaded;
    private static Fluid type;
    private static int ratio;

    private static void addFluid(String cf, String sf, String c, String f) {
        try {
            Class<?> cl = Class.forName(c);
            Field fd = cl.getDeclaredField(f);
            fd.setAccessible(true);
            Class<?> clf = Class.forName(cf);
            Field fdf = clf.getDeclaredField(sf);
            fdf.setAccessible(true);
            ReikaXPFluidHelper.addFluid((Fluid)fdf.get(null), fd.getInt(null));
        }
        catch (Exception e) {
            DragonAPICore.logError("Error loading xp fluid type as loaded from " + cf + "#" + sf + ": " + e);
        }
    }

    private static void addFluid(String s, String c, String f) {
        if (loaded != null) {
            return;
        }
        try {
            Class<?> cl = Class.forName(c);
            Field fd = cl.getDeclaredField(f);
            fd.setAccessible(true);
            ReikaXPFluidHelper.addFluid(s, fd.getInt(null));
        }
        catch (Exception e) {
            DragonAPICore.logError("Error loading xp fluid type " + s + ": " + e);
        }
    }

    private static void addFluid(Fluid f, int amt) {
        if (loaded != null) {
            return;
        }
        if (f != null) {
            ReikaXPFluidHelper.register(f, amt);
        }
    }

    private static void addFluid(String s, int amt) {
        Fluid f = FluidRegistry.getFluid((String)s);
        if (f != null) {
            ReikaXPFluidHelper.register(f, amt);
        }
    }

    private static void register(Fluid f, int amt) {
        if (loaded == null) {
            loaded = new FluidStack(f, amt);
            type = f;
            ratio = amt;
            DragonAPICore.log("Loaded XP fluid " + f.getName() + " with ratio of " + amt + " mB/xp.");
        } else {
            DragonAPICore.log("Rejected XP fluid " + f.getName() + " with ratio of " + amt + " mB/xp; a fluid is already loaded.");
        }
    }

    public static Fluid getFluidType() {
        return type;
    }

    public static FluidStack getFluid() {
        return loaded != null ? loaded.copy() : null;
    }

    public static FluidStack getFluid(int xp) {
        FluidStack fs = ReikaXPFluidHelper.getFluid();
        if (fs != null) {
            fs.amount *= xp;
        }
        return fs;
    }

    public static int getXPForAmount(int fluid) {
        return ratio > 0 ? fluid / ratio : 0;
    }

    public static boolean fluidsExist() {
        return loaded != null;
    }

    static {
        ReikaXPFluidHelper.addFluid("openblocks.OpenBlocks$Fluids", "xpJuice", "openblocks.Config", "xpToLiquidRatio");
        ReikaXPFluidHelper.addFluid("openblocks.OpenBlocks$Fluids", "xpJuice", "openmods.utils.EnchantmentUtils", "RATIO");
        ReikaXPFluidHelper.addFluid("crazypants.enderio.EnderIO", "fluidXpJuice", "crazypants.enderio.xp.XpUtil", "RATIO");
        ReikaXPFluidHelper.addFluid("mods.immibis.lxp.LiquidXPMod", "defaultFluid", "mods.immibis.lxp.LiquidXPMod", "mbPerXp");
    }
}

